/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.tdbfmt;

import java.io.IOException;
import uk.me.parabola.io.StructuredInputStream;
import uk.me.parabola.io.StructuredOutputStream;
import uk.me.parabola.tdbfmt.Block;

class HeaderBlock {
    private short familyId;
    private short productId;
    private final int tdbVersion;
    private String seriesName;
    private short productVersion;
    private String familyName;
    private byte enableProfile;
    private int codePage;

    HeaderBlock(int tdbVersion) {
        this.tdbVersion = tdbVersion;
    }

    HeaderBlock(Block block) throws IOException {
        StructuredInputStream ds = block.getInputStream();
        this.productId = (short)ds.read2();
        this.familyId = (short)ds.read2();
        this.tdbVersion = ds.read2();
        this.seriesName = ds.readString();
        this.productVersion = (short)ds.read2();
        this.familyName = ds.readString();
    }

    public void write(Block block) throws IOException {
        StructuredOutputStream os = block.getOutputStream();
        os.write2(this.productId);
        os.write2(this.familyId);
        os.write2(this.tdbVersion);
        os.writeString(this.seriesName);
        os.write2(this.productVersion);
        os.writeString(this.familyName);
        if (this.tdbVersion >= 407) {
            os.write(0);
            os.write(18);
            os.write(1);
            os.write(1);
            os.write(1);
            os.write4(0);
            os.write(0);
            os.write(24);
            os.write4(0);
            os.write4(0);
            os.write4(0);
            os.write4(0);
            os.write3(0);
            os.write4(this.codePage);
            os.write4(10000);
            os.write(1);
            if (this.enableProfile == 1) {
                os.write(1);
            } else {
                os.write(0);
            }
            os.write(0);
        }
    }

    public String toString() {
        return "TDB header: " + this.productId + " version=" + this.tdbVersion + ", series:" + this.seriesName + ", family:" + this.familyName + ", ver=" + this.productVersion;
    }

    public void setProductId(short productId) {
        this.productId = productId;
    }

    public void setSeriesName(String seriesName) {
        this.seriesName = seriesName;
    }

    public void setFamilyName(String familyName) {
        this.familyName = familyName;
    }

    public void setProductVersion(short productVersion) {
        this.productVersion = productVersion;
    }

    public void setFamilyId(short familyId) {
        this.familyId = familyId;
    }

    void setCodePage(int codePage) {
        this.codePage = codePage;
    }

    public int getTdbVersion() {
        return this.tdbVersion;
    }

    public void setEnableProfile(byte enableProfile) {
        this.enableProfile = enableProfile;
    }
}

