//
// MODTOOL
//
// Copyright (c) !998 David Lindauer (LADSOFT)
//
// see license.txt for licensing info
//
// ==============================================================
//
// archive.cpp
//
// archive-related primitives
//
#define STRICT
#include <windows.h>
#include <stdio.h>
#include <time.h>

#include "profile.h"
#include "modlist.h"
#include "analyze.h"

// ==============================================================
//
// get the name of an archive file based on the date
//
// this splits archives into weeks, based on the day received
//
char * GetArchiveName(void)
{
	static char buffer[256];
	strcpy(buffer,archivedirectory);
	int len = strlen(buffer);
	if (len && buffer[len-1] != '\\')
		strcat(buffer,"\\");
	if (datedarchive) {
		char buf2[32];
		time_t t;
		struct tm *tmx;
		int week;
		time(&t);
		tmx = localtime(&t);
		week = tmx->tm_mday/7;
		sprintf(buf2,"%02d%04d%c",
			tmx->tm_mon+1,tmx->tm_year,week + 'a');
		strcat(buffer,buf2);
		strcat(buffer,".nar");
	}
	else
		strcat(buffer,archivefolder);
	return buffer;
	
}