//
// MODTOOL
//
// Copyright (c) !998 David Lindauer (LADSOFT)
//
// see license.txt for licensing info
//
// ==============================================================
//
// DIALOG.CPP
//
// dialog box utility functions, for setting retrieving values
//
#define STRICT
#include <windows.h>
#include <stdio.h>

// ==============================================================
//
// set an edit field to read only
void SetEditFieldRO(HWND hwnd, int control)
{
	HWND hwndedit = GetDlgItem(hwnd,control);
	SendMessage(hwndedit,EM_SETREADONLY,TRUE,0);
}

// ==============================================================
//
// set the value of an edit field
//
void SetEditField(HWND hWnd,int control, char *text)
{
	HWND hwndedit = GetDlgItem(hWnd,control);
	SendMessage(hwndedit,EM_SETSEL,0,-1);
	SendMessage(hwndedit,EM_REPLACESEL,0,(LPARAM) text);
	SendMessage(hwndedit,EM_SETSEL,0,-1);
	SendMessage(hwndedit,EM_SETLIMITTEXT,255,0);
}
void SetEditFieldValue(HWND hWnd,int control, long value)
{
	char string[256];
	sprintf(string,"%ld",value);
	SetEditField(hWnd,control,string);
}
// ==============================================================
//
// get the value of an edit field
//
void GetEditField(HWND hWnd, int control, char *text)
{
	HWND hwndedit = GetDlgItem(hWnd,control);
	char itext[260];
	itext[0] = 0;
	itext[1] = 1;
	int rv = SendMessage(hwndedit,EM_GETLINE,0,(LPARAM) itext);
	itext[rv] = 0;
	strcpy(text,itext);
}
long GetEditFieldValue(HWND hWnd, int control)
{
	char string[256];
	GetEditField(hWnd,control,string);
	return atoi(string);
}
// ==============================================================
// 
// handle checkboxes
//
void SetCBField(HWND hWnd, int control, int value)
{
	CheckDlgButton(hWnd,control,value);
}
int GetCBField(HWND hWnd, int control)
{
	return IsDlgButtonChecked(hWnd,control);
}

// ==============================================================
//
// set focus 
void NewFocus(HWND hWnd, int control)
{
	HWND hwndc = GetDlgItem(hWnd,control);
	SetFocus(hwndc);
}