# $FreeBSD: stable/5/kerberos5/Makefile.inc 133196 2004-08-06 07:27:08Z cperciva $

NOLINT=

KRB5DIR=	${.CURDIR}/../../../crypto/heimdal

CFLAGS+=	-DHAVE_CONFIG_H -I${.CURDIR}/../../include
CFLAGS+=	-DINET6

.if defined(WITH_OPENLDAP)
OPENLDAPBASE?=	/usr/local
LDAPLDADD=	-lldap -llber
LDAPDPADD=	${LDAPLDADD:C;^-l(.*)$;${OPENLDAPBASE}/lib/lib\1.a;}
LDAPCFLAGS=	-I${OPENLDAPBASE}/include -DOPENLDAP=1
LDAPLDFLAGS=	-L${OPENLDAPBASE}/lib -Wl,-rpath,${OPENLDAPBASE}/lib
.endif

.if exists(${.OBJDIR}/../../lib/libvers)
LIBVERS=	${.OBJDIR}/../../lib/libvers/libvers.a
.else
LIBVERS=	${.CURDIR}/../../lib/libvers/libvers.a
.endif

.if exists(${.OBJDIR}/../../lib/libsl)
LIBSL=		${.OBJDIR}/../../lib/libsl/libsl.a
.else
LIBSL=		${.CURDIR}/../../lib/libsl/libsl.a
.endif

.if defined(SRCS)

ETSRCS=	\
	${KRB5DIR}/lib/asn1/asn1_err.et \
	${KRB5DIR}/lib/hdb/hdb_err.et \
	${KRB5DIR}/lib/kadm5/kadm5_err.et \
	${KRB5DIR}/lib/krb5/heim_err.et \
	${KRB5DIR}/lib/krb5/k524_err.et \
	${KRB5DIR}/lib/krb5/krb5_err.et

.for ET in ${ETSRCS}
.for _ET in ${ET:T:R}
.if ${SRCS:M${_ET}.[ch]} != ""
.ORDER: ${_ET}.c ${_ET}.h
${_ET}.c ${_ET}.h: ${ET}
	compile_et ${.ALLSRC}
CLEANFILES+=	${_ET}.h ${_ET}.c
.endif
.endfor
.endfor

.endif defined(SRCS)
