/*	$NetBSD: movefile.c,v 1.1.1.1 2009/04/12 15:33:48 christos Exp $	*/

/*
 * Copyright (c) 2004 by Internet Systems Consortium, Inc. ("ISC")
 * Copyright (c) 2000 by Internet Software Consortium, Inc.
 *
 * Permission to use, copy, modify, and distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND ISC DISCLAIMS ALL WARRANTIES
 * WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS.  IN NO EVENT SHALL ISC BE LIABLE FOR
 * ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT
 * OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */


#include <port_before.h>
#include <stdio.h>
#include <isc/misc.h>
#include <port_after.h>
#ifndef HAVE_MOVEFILE
/*
 * rename() is lame (can't overwrite an existing file) on some systems.
 * use movefile() instead, and let lame OS ports do what they need to.
 */

int
isc_movefile(const char *oldname, const char *newname) {
	return (rename(oldname, newname));
}
#else
	static int os_port_has_isc_movefile = 1;
#endif

/*! \file */
