# $NetBSD: Makefile.inc,v 1.5 2025/12/17 15:54:44 nia Exp $

DIST:=${.PARSEDIR}/dist

VERS_FILE=${DIST}/CMakeLists.txt

.for i in MAJOR MINOR PATCH
FIDO_${i} != \
    ${TOOL_SED} -ne '/FIDO_${i}/s/.*"\([0-9]*\)")$$/\1/p' ${VERS_FILE}
.endfor
FIDO_VERSION=${FIDO_MAJOR}.${FIDO_MINOR}.${FIDO_PATCH}

CPPFLAGS+=-D_FIDO_MAJOR=${FIDO_MAJOR} -D_FIDO_MINOR=${FIDO_MINOR}
CPPFLAGS+=-D_FIDO_PATCH=${FIDO_PATCH}
CPPFLAGS+=-DHAVE_UNISTD_H -DHAVE_ARC4RANDOM_BUF -DHAVE_TIMESPECSUB
CPPFLAGS+=-DHAVE_ENDIAN_H -DHAVE_ERR_H -DHAVE_SIGNAL_H
CPPFLAGS+=-DHAVE_STRLCAT -DHAVE_STRLCPY
CPPFLAGS+=-DHAVE_STRSEP -DHAVE_SYSCONF
