# Copyright (C) 2014-2025 Free Software Foundation, Inc.
#
# Copying and distribution of this file, with or without modification,
# are permitted in any medium without royalty provided the copyright
# notice and this notice are preserved.

TORS=".tors :
  {
    ___ctors = . ;
    *(.ctors)
    ___ctors_end = . ;
    ___dtors = . ;
    *(.dtors)
    ___dtors_end = . ;
  }${RELOCATING+ > ram}"

cat <<EOF
/* Copyright (C) 2014-2025 Free Software Foundation, Inc.

   Copying and distribution of this script, with or without modification,
   are permitted in any medium without royalty provided the copyright
   notice and this notice are preserved.  */

OUTPUT_FORMAT("${OUTPUT_FORMAT}")
OUTPUT_ARCH(${ARCH})
${LIB_SEARCH_DIRS}

EOF

test -n "${RELOCATING}" && cat <<EOF
MEMORY
{
  ram : o = 0x1000, l = 512k
}

EOF

cat <<EOF
SECTIONS
{
  .text :
  {
    *(.text)
    *(.strings)
    ${RELOCATING+ _etext = . ; }
  }
  ${CONSTRUCTING+${TORS}}
  .data  ${RELOCATING+ ALIGN(${TARGET_PAGE_SIZE})} :
  {
    *(.data)
    ${RELOCATING+*(.gcc_exc*)}
    ${RELOCATING+___EH_FRAME_BEGIN__ = . ;}
    ${RELOCATING+*(.eh_fram*)}
    ${RELOCATING+___EH_FRAME_END__ = . ;}
    ${RELOCATING+LONG(0);}
    ${RELOCATING+ _edata = . ; }
  }
  .bss ${RELOCATING+ ALIGN(${TARGET_PAGE_SIZE})} :
  {
    ${RELOCATING+ _bss_start = . ; }
    *(.bss)
    *(COMMON)
    ${RELOCATING+ _end = . ;  }
  }
  .stack :
  {
    ${RELOCATING+ _stack = . ; }
    *(.stack)
  }
  .stab 0 ${RELOCATING+(NOLOAD)} :
  {
    *(.stab)
  }
  .stabstr 0 ${RELOCATING+(NOLOAD)} :
  {
    *(.stabstr)
  }
}
EOF




