/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ftp;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import net.sourceforge.plantuml.ftp.FtpConnexion;
import net.sourceforge.plantuml.ftp.FtpLoop;

public class FtpServer {
    private final Map<String, FtpConnexion> datas = new TreeMap<String, FtpConnexion>();
    private final ExecutorService exeImage = Executors.newFixedThreadPool(2);
    private final String charset = "UTF-8";
    private final int listenPort;
    private int portFree = 10042;
    private String ip;

    public FtpServer(int n) {
        this.listenPort = n;
    }

    public synchronized int getFreePort() {
        ++this.portFree;
        return this.portFree;
    }

    public void go() throws IOException {
        ServerSocket serverSocket = new ServerSocket(this.listenPort);
        ExecutorService executorService = Executors.newCachedThreadPool();
        while (true) {
            Socket socket = serverSocket.accept();
            this.ip = socket.getLocalAddress().getHostAddress();
            System.out.println("New Client Connected from " + socket.getInetAddress().getHostName() + "... ");
            executorService.submit(new FtpLoop(socket, this));
        }
    }

    public String getIpServer() {
        return this.ip;
    }

    public synchronized FtpConnexion getFtpConnexion(String string) {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        FtpConnexion ftpConnexion = this.datas.get(string);
        if (ftpConnexion == null) {
            ftpConnexion = new FtpConnexion(string);
            this.datas.put(string, ftpConnexion);
        }
        return ftpConnexion;
    }

    public static void main(String[] stringArray) throws IOException {
        System.out.println("****************************** ************************************************** ");
        System.out.println("****************************** FTP SERVER***********************************");
        System.out.println("****************************** ************************************************** ");
        System.out.println("Server Started...");
        System.out.println("Waiting for connections...");
        System.out.println(" ");
        new FtpServer(24242).go();
    }

    public void processImage(final FtpConnexion ftpConnexion, final String string) {
        this.exeImage.submit(new Runnable(){

            public void run() {
                try {
                    ftpConnexion.processImage(string);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        });
    }

    public final String getCharset() {
        return "UTF-8";
    }
}

