# Generated by default/object.tt
package Paws::ACMPCA::ApiPassthrough;
  use Moose;
  has Extensions => (is => 'ro', isa => 'Paws::ACMPCA::Extensions');
  has Subject => (is => 'ro', isa => 'Paws::ACMPCA::ASN1Subject');

1;

### main pod documentation begin ###

=head1 NAME

Paws::ACMPCA::ApiPassthrough

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::ACMPCA::ApiPassthrough object:

  $service_obj->Method(Att1 => { Extensions => $value, ..., Subject => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::ACMPCA::ApiPassthrough object:

  $result = $service_obj->Method(...);
  $result->Att1->Extensions

=head1 DESCRIPTION

Contains X.509 certificate information to be placed in an issued
certificate. An C<APIPassthrough> or C<APICSRPassthrough> template
variant must be selected, or else this parameter is ignored.

If conflicting or duplicate certificate information is supplied from
other sources, ACM Private CA applies order of operation rules
(https://docs.aws.amazon.com/acm-pca/latest/userguide/UsingTemplates.html#template-order-of-operations)
to determine what information is used.

=head1 ATTRIBUTES


=head2 Extensions => L<Paws::ACMPCA::Extensions>

Specifies X.509 extension information for a certificate.


=head2 Subject => L<Paws::ACMPCA::ASN1Subject>





=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::ACMPCA>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

