package Daje::Workflow::Database::Model::Context;
use Mojo::Base -base, -signatures;

use Mojo::JSON qw { to_json from_json };
use DBD::Pg ':pg_types';

# NAME
# ====
#
# Daje::Workflow::Database::Model::Context
#
# SYNOPSIS
# ========
#
#    use Daje::Workflow::Database::Model::Context;
#
#    my $context_obj = Daje::Workflow::Database::Model::Context->new(
#           db              => $db,
#           workflow_pkey   => $workflow_pkey
#           context_pkey    => $context_pkey,
#           context         => $context,
#       );
#
#       my $context = $context_obj->load_fk($self)
#
#       my $context = $context_obj->load_pk($self)
#
#       my $context_pkey = $context_obj->save($self, $context)
#
#
# REQUIRES
# ========
#
# Mojo::Base>
#
#  DBD::Pg
#
#
# METHODS
# =======
#
#  load_fk($self)
#
#  load_pk($self)
#
#  save($self, $context)
#
#
# LICENSE
# =======
#
# Copyright (C) janeskil1525.
#
# This library is free software; you can redistribute it and/or modify
# it under the same terms as Perl itself.
#
# AUTHOR
# ======
#
# janeskil1525 E<lt>janeskil1525@gmail.comE<gt>
#


has 'db';
has 'workflow_pkey';
has 'context_pkey';
has 'context';

sub load_pk($self) {
    my $context = $self->_load_pk();
    unless(exists $context->{context_pkey} and $context->{context_pkey} > 0) {
        $context->{context_pkey} = 0;
        $context->{workflow_fkey} = $self->workflow_pkey;
        $context->{context} = $self->context->{context};
        my $context_pkey = $self->save($context);
        $self->context_pkey($context_pkey);
        $context = $self->_load_pk();
    }

    return $context;
}

sub _load_pk($self) {
    my $data = $self->db->select(
        'context', ['*'],
        {
            context_pkey => $self->context_pkey
        }
    );

    my $context;
    $context = $data->hash if $data->rows > 0;
    if (defined $context and exists $context->{context}) {
        $context->{context} = from_json($context->{context});
    }
    return $context;
}

sub load_fk($self) {
    my $context = $self->_load_fk();
    unless(exists $context->{context_pkey} and $context->{context_pkey} > 0) {
        $context->{context_pkey} = 0;
        $context->{workflow_fkey} = $self->workflow_pkey;
        $context->{context} = $self->context->{context};
        my $context_pkey = $self->save($context);
        $self->context_pkey($context_pkey);
        $context = $self->_load_pk();
    }

    return $context;
}

sub _load_fk($self) {
    my $data = $self->db->select(
        'context', ['*'],
        {
            workflow_fkey => $self->workflow_pkey
        }
    );

    my $context;
    $context = $data->hash if $data->rows > 0;
    if (defined $context and exists $context->{context}) {
        $context->{context} = from_json($context->{context});
    }
    return $context;
}

sub save($self, $context) {

    $context->{context_pkey} = 0 unless exists $context->{context_pkey};
    $context->{context} = to_json($context->{context});

    if ($context->{context_pkey} > 0) {
        $self->db->query("UPDATE context SET context = ? WHERE context_pkey = ?",
            ("$context->{context}", "$context->{context_pkey}")
        );

    } else {
        delete %$context{context_pkey};
        $context->{workflow_fkey} = $self->workflow_pkey;

        $context->{context_pkey} = $self->db->query(
            "INSERT INTO context (context, workflow_fkey) VALUES (?,?)  RETURNING context_pkey",
            ("$context->{context}", "$context->{workflow_fkey}")
        )->hash->{context_pkey};
    }

    return $context->{context_pkey};
}

1;












#################### pod generated by Pod::Autopod - keep this line to make pod updates possible ####################

=head1 NAME


Daje::Workflow::Database::Model::Context



=head1 SYNOPSIS


   use Daje::Workflow::Database::Model::Context;

   my $context_obj = Daje::Workflow::Database::Model::Context->new(
          db              => $db,
          workflow_pkey   => $workflow_pkey
          context_pkey    => $context_pkey,
          context         => $context,
      );

      my $context = $context_obj->load_fk($self)

      my $context = $context_obj->load_pk($self)

      my $context_pkey = $context_obj->save($self, $context)




=head1 REQUIRES


Mojo::Base>

 DBD::Pg




=head1 METHODS


 load_fk($self)

 load_pk($self)

 save($self, $context)




=head1 AUTHOR


janeskil1525 E<lt>janeskil1525@gmail.comE<gt>



=head1 LICENSE


Copyright (C) janeskil1525.

This library is free software; you can redistribute it and/or modify
it under the same terms as Perl itself.



=cut

