# Generated by default/object.tt
package Paws::SageMaker::EdgeModelStat;
  use Moose;
  has ActiveDeviceCount => (is => 'ro', isa => 'Int', required => 1);
  has ConnectedDeviceCount => (is => 'ro', isa => 'Int', required => 1);
  has ModelName => (is => 'ro', isa => 'Str', required => 1);
  has ModelVersion => (is => 'ro', isa => 'Str', required => 1);
  has OfflineDeviceCount => (is => 'ro', isa => 'Int', required => 1);
  has SamplingDeviceCount => (is => 'ro', isa => 'Int', required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::SageMaker::EdgeModelStat

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::SageMaker::EdgeModelStat object:

  $service_obj->Method(Att1 => { ActiveDeviceCount => $value, ..., SamplingDeviceCount => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::SageMaker::EdgeModelStat object:

  $result = $service_obj->Method(...);
  $result->Att1->ActiveDeviceCount

=head1 DESCRIPTION

Status of edge devices with this model.

=head1 ATTRIBUTES


=head2 B<REQUIRED> ActiveDeviceCount => Int

The number of devices that have this model version, a heart beat, and
are currently running.


=head2 B<REQUIRED> ConnectedDeviceCount => Int

The number of devices that have this model version and have a heart
beat.


=head2 B<REQUIRED> ModelName => Str

The name of the model.


=head2 B<REQUIRED> ModelVersion => Str

The model version.


=head2 B<REQUIRED> OfflineDeviceCount => Int

The number of devices that have this model version and do not have a
heart beat.


=head2 B<REQUIRED> SamplingDeviceCount => Int

The number of devices with this model version and are producing sample
data.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::SageMaker>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

