use ExtUtils::MakeMaker; 
use ExtUtils::Constant qw (WriteConstants);
use Config qw(%Config);

# Fiddle with flags depending on platform.

my @flags;

if ($^O eq 'darwin') {
        push @flags,(
                LIBS => '-L/usr/X11R6/lib -lGL -lGLU',
                LDDLFLAGS => $Config{lddlflags} . qq( -framework OpenGL),
                INC => '-FOpenGL',
        );
} elsif ($^O eq 'freebsd') {
        # Default configuration..
        push @flags,(
                LIBS => '-L/usr/X11R6/lib -lGL -lGLU',
                CCFLAGS => '-I/usr/X11R6/include',
        );
} elsif ($^O eq 'MSWin32') {
        push @flags,(
                LIBS => '-lopengl32 -lGLU32',
        );
} else {
        # Default configuration..
        push @flags,(
                LIBS => '-lGL -lGLU',
        );
}

# See lib/ExtUtils/MakeMaker.pm for details of how to influence
# the contents of the Makefile that is written.
WriteMakefile(
    'NAME'		=> 'OpenGL::Simple',
    'VERSION_FROM'	=> 'Simple.pm', # finds $VERSION
    'PREREQ_PM'		=> { Imager => 0,
                             ExtUtils::Constant => 0,
                        },
    ($] >= 5.005 ?    ## Add these new keywords supported since 5.005
      (ABSTRACT_FROM => 'Simple.pm', # retrieve abstract from module
       AUTHOR     => 'Jonathan Chin <jon-opengl-simple@earth.li>') : ()),
    @flags
);

WriteConstants(
	NAME => "OpenGL::Simple",
	NAMES => [qw(
		GL_VENDOR GL_RENDERER GL_VERSION GL_EXTENSIONS

 		GL_POINTS GL_LINES GL_LINE_STRIP GL_LINE_LOOP
		GL_TRIANGLES GL_TRIANGLE_STRIP GL_TRIANGLE_FAN
		GL_QUADS GL_QUAD_STRIP GL_POLYGON

		GL_ALPHA_TEST GL_AUTO_NORMAL GL_BLEND GL_CLIP_PLANE0
		GL_CLIP_PLANE1 GL_CLIP_PLANE2 GL_CLIP_PLANE3 GL_CLIP_PLANE4
		GL_CLIP_PLANE5 GL_COLOR_LOGIC_OP GL_COLOR_MATERIAL GL_CULL_FACE
		GL_DEPTH_TEST GL_DITHER GL_FOG GL_INDEX_LOGIC_OP
		GL_LIGHT0 GL_LIGHT1 GL_LIGHT2 GL_LIGHT3
		GL_LIGHT4 GL_LIGHT5 GL_LIGHT6 GL_LIGHT7
		GL_LIGHTING GL_LINE_SMOOTH GL_LINE_STIPPLE GL_MAP1_COLOR_4
		GL_MAP1_INDEX GL_MAP1_NORMAL GL_MAP1_TEXTURE_COORD_1
		GL_MAP1_TEXTURE_COORD_2 GL_MAP1_TEXTURE_COORD_3
		GL_MAP1_TEXTURE_COORD_4 GL_MAP1_VERTEX_3 GL_MAP1_VERTEX_4
		GL_MAP2_COLOR_4 GL_MAP2_INDEX GL_MAP2_NORMAL
		GL_MAP2_TEXTURE_COORD_1 GL_MAP2_TEXTURE_COORD_2
		GL_MAP2_TEXTURE_COORD_3 GL_MAP2_TEXTURE_COORD_4
		GL_MAP2_VERTEX_3 GL_MAP2_VERTEX_4 GL_NORMALIZE
		GL_POINT_SMOOTH GL_POLYGON_OFFSET_FILL GL_POLYGON_OFFSET_LINE
		GL_POLYGON_OFFSET_POINT GL_POLYGON_SMOOTH GL_POLYGON_STIPPLE
		GL_SCISSOR_TEST GL_STENCIL_TEST GL_TEXTURE_1D

		GL_TEXTURE_2D GL_TEXTURE_GEN_Q GL_TEXTURE_GEN_R
		GL_TEXTURE_GEN_S GL_TEXTURE_GEN_T

        GL_Q GL_R GL_S GL_T

        GL_TEXTURE_GEN_MODE GL_REFLECTION_MAP
        GL_OBJECT_LINEAR GL_EYE_LINEAR GL_SPHERE_MAP
        GL_TEXTURE_CUBE_MAP

		GL_COLOR_BUFFER_BIT GL_DEPTH_BUFFER_BIT
		GL_ACCUM_BUFFER_BIT GL_STENCIL_BUFFER_BIT

		GL_MODELVIEW GL_PROJECTION GL_TEXTURE

		GL_COMPILE GL_COMPILE_AND_EXECUTE

		GL_FRONT GL_BACK GL_FRONT_AND_BACK
		GL_AMBIENT GL_DIFFUSE GL_SPECULAR GL_AMBIENT_AND_DIFFUSE

		GL_LIGHT_MODEL_LOCAL_VIEWER GL_LIGHT_MODEL_TWO_SIDE 
		GL_LIGHT_MODEL_AMBIENT

		GL_FLAT GL_SMOOTH

		GL_NEVER GL_LESS GL_EQUAL GL_LEQUAL GL_GREATER
		GL_NOTEQUAL GL_GEQUAL GL_ALWAYS

		GL_TRUE GL_FALSE

		GL_POINT GL_LINE GL_FILL

		GL_ZERO GL_ONE
		GL_DST_COLOR GL_ONE_MINUS_DST_COLOR GL_SRC_ALPHA 
		GL_ONE_MINUS_SRC_ALPHA GL_DST_ALPHA GL_ONE_MINUS_DST_ALPHA
		GL_SRC_ALPHA_SATURATE

		GL_SRC_COLOR GL_ONE_MINUS_SRC_COLOR

		GL_FOG_HINT GL_LINE_SMOOTH_HINT GL_PERSPECTIVE_CORRECTION_HINT
		GL_POINT_SMOOTH_HINT GL_POLYGON_SMOOTH_HINT
		GL_FASTEST GL_NICEST GL_DONT_CARE

		GL_POSITION
		GL_SPOT_DIRECTION GL_SPOT_EXPONENT GL_SPOT_CUTOFF
		GL_CONSTANT_ATTENUATION GL_LINEAR_ATTENUATION
		GL_QUADRATIC_ATTENUATION

		GL_CW GL_CCW

		GL_TEXTURE_MIN_FILTER GL_TEXTURE_MAG_FILTER
		GL_TEXTURE_WRAP_S GL_TEXTURE_WRAP_T GL_TEXTURE_PRIORITY
		GL_TEXTURE_BORDER_COLOR

		GL_NEAREST GL_LINEAR
		GL_NEAREST_MIPMAP_NEAREST GL_LINEAR_MIPMAP_NEAREST
		GL_NEAREST_MIPMAP_LINEAR  GL_LINEAR_MIPMAP_LINEAR

		GL_CLAMP GL_REPEAT


		GL_PROXY_TEXTURE_2D

		GL_ALPHA GL_ALPHA4 GL_ALPHA8 GL_ALPHA12 GL_ALPHA16 
		GL_LUMINANCE GL_LUMINANCE4 GL_LUMINANCE8 
		GL_LUMINANCE12 GL_LUMINANCE16 GL_LUMINANCE_ALPHA 
		GL_LUMINANCE4_ALPHA4 GL_LUMINANCE6_ALPHA2 GL_LUMINANCE8_ALPHA8 
		GL_LUMINANCE12_ALPHA4 GL_LUMINANCE12_ALPHA12 
		GL_LUMINANCE16_ALPHA16 GL_INTENSITY GL_INTENSITY4 
		GL_INTENSITY8 GL_INTENSITY12 GL_INTENSITY16 
		GL_R3_G3_B2 GL_RGB GL_RGB4 GL_RGB5 GL_RGB8 GL_RGB10 GL_RGB12
		GL_RGB16 GL_RGBA GL_RGBA2 GL_RGBA4 GL_RGB5_A1 
		GL_RGBA8 GL_RGB10_A2 GL_RGBA12 GL_RGBA16 

		GL_COLOR_INDEX GL_RED GL_GREEN GL_BLUE

		GL_UNSIGNED_BYTE GL_BYTE GL_BITMAP 
		GL_UNSIGNED_SHORT GL_SHORT GL_UNSIGNED_INT GL_INT GL_FLOAT 

		GL_TEXTURE_ENV_MODE GL_TEXTURE_ENV GL_TEXTURE_ENV_COLOR 

		GL_MODULATE GL_DECAL GL_REPLACE

		GL_COLOR_ARRAY GL_CURRENT_RASTER_POSITION_VALID
		GL_DEPTH_WRITEMASK GL_DOUBLEBUFFER GL_EDGE_FLAG
		GL_EDGE_FLAG_ARRAY GL_INDEX_ARRAY GL_INDEX_MODE
		GL_MAP_COLOR GL_MAP_STENCIL GL_NORMAL_ARRAY
		GL_PACK_LSB_FIRST GL_PACK_SWAP_BYTES GL_RGBA_MODE
		GL_STEREO GL_TEXTURE_COORD_ARRAY GL_UNPACK_LSB_FIRST
		GL_UNPACK_SWAP_BYTES GL_VERTEX_ARRAY GL_COLOR_WRITEMASK
		GL_ACCUM_ALPHA_BITS GL_ACCUM_BLUE_BITS GL_ACCUM_GREEN_BITS
		GL_ACCUM_RED_BITS GL_ALPHA_BITS GL_ALPHA_TEST_FUNC
		GL_ATTRIB_STACK_DEPTH GL_AUX_BUFFERS GL_BLEND_DST
		GL_BLEND_EQUATION_EXT GL_BLEND_SRC GL_CLIENT_ATTRIB_STACK_DEPTH
		GL_COLOR_ARRAY_SIZE GL_COLOR_ARRAY_STRIDE GL_COLOR_ARRAY_TYPE
		GL_COLOR_MATERIAL_FACE GL_COLOR_MATERIAL_PARAMETER
		GL_CULL_FACE_MODE GL_CURRENT_INDEX GL_CURRENT_RASTER_INDEX
		GL_DEPTH_BITS GL_DEPTH_FUNC GL_DRAW_BUFFER
		GL_EDGE_FLAG_ARRAY_STRIDE GL_FOG_INDEX GL_FOG_MODE
		GL_FRONT_FACE GL_GREEN_BITS GL_INDEX_ARRAY_STRIDE
		GL_INDEX_ARRAY_TYPE GL_INDEX_BITS GL_INDEX_CLEAR_VALUE
		GL_INDEX_OFFSET GL_INDEX_SHIFT GL_INDEX_WRITEMASK
		GL_LINE_STIPPLE_PATTERN GL_LINE_STIPPLE_REPEAT GL_LIST_BASE
		GL_LIST_INDEX GL_LIST_MODE GL_LOGIC_OP_MODE
		GL_MAP1_GRID_SEGMENTS GL_MATRIX_MODE
		GL_MAX_CLIENT_ATTRIB_STACK_DEPTH GL_MAX_ATTRIB_STACK_DEPTH
		GL_MAX_CLIP_PLANES GL_MAX_EVAL_ORDER GL_MAX_LIGHTS
		GL_MAX_LIST_NESTING GL_MAX_MODELVIEW_STACK_DEPTH
		GL_MAX_NAME_STACK_DEPTH GL_MAX_PIXEL_MAP_TABLE
		GL_MAX_PROJECTION_STACK_DEPTH GL_MAX_TEXTURE_SIZE
		GL_MAX_TEXTURE_STACK_DEPTH GL_MODELVIEW_STACK_DEPTH
		GL_NAME_STACK_DEPTH GL_NORMAL_ARRAY_STRIDE
		GL_NORMAL_ARRAY_TYPE GL_PACK_ALIGNMENT
		GL_PACK_ROW_LENGTH GL_PACK_SKIP_PIXELS
		GL_PACK_SKIP_ROWS GL_PIXEL_MAP_A_TO_A_SIZE
		GL_PIXEL_MAP_B_TO_B_SIZE GL_PIXEL_MAP_G_TO_G_SIZE
		GL_PIXEL_MAP_I_TO_A_SIZE GL_PIXEL_MAP_I_TO_B_SIZE
		GL_PIXEL_MAP_I_TO_G_SIZE GL_PIXEL_MAP_I_TO_I_SIZE
		GL_PIXEL_MAP_I_TO_R_SIZE GL_PIXEL_MAP_R_TO_R_SIZE
		GL_PIXEL_MAP_S_TO_S_SIZE GL_PROJECTION_STACK_DEPTH
		GL_READ_BUFFER GL_RED_BITS GL_RENDER_MODE GL_SHADE_MODEL
		GL_STENCIL_BITS GL_STENCIL_CLEAR_VALUE GL_STENCIL_FAIL
		GL_STENCIL_FUNC GL_STENCIL_PASS_DEPTH_FAIL
		GL_STENCIL_PASS_DEPTH_PASS GL_STENCIL_REF GL_STENCIL_VALUE_MASK
		GL_STENCIL_WRITEMASK GL_SUBPIXEL_BITS
		GL_TEXTURE_COORD_ARRAY_SIZE GL_TEXTURE_COORD_ARRAY_STRIDE
		GL_TEXTURE_COORD_ARRAY_TYPE GL_TEXTURE_STACK_DEPTH
		GL_UNPACK_ALIGNMENT GL_UNPACK_ROW_LENGTH
		GL_UNPACK_SKIP_PIXELS GL_UNPACK_SKIP_ROWS
		GL_VERTEX_ARRAY_SIZE GL_VERTEX_ARRAY_STRIDE
		GL_VERTEX_ARRAY_TYPE GL_MAP2_GRID_SEGMENTS
		GL_MAX_VIEWPORT_DIMS GL_POLYGON_MODE
		GL_SCISSOR_BOX GL_VIEWPORT
		GL_ALPHA_BIAS GL_ALPHA_SCALE
		GL_ALPHA_TEST_REF GL_BLUE_BIAS GL_BLUE_BITS
		GL_BLUE_SCALE GL_CURRENT_RASTER_DISTANCE
		GL_DEPTH_BIAS GL_DEPTH_CLEAR_VALUE
		GL_DEPTH_SCALE GL_FOG_DENSITY
		GL_FOG_END GL_FOG_START
		GL_GREEN_SCALE GL_LINE_WIDTH
		GL_LINE_WIDTH_GRANULARITY GL_LINE_WIDTH_RANGE
		GL_POINT_SIZE GL_POINT_SIZE_GRANULARITY
		GL_POLYGON_OFFSET_FACTOR GL_POLYGON_OFFSET_UNITS
		GL_RED_BIAS GL_RED_SCALE
		GL_ZOOM_X GL_ZOOM_Y
		GL_DEPTH_RANGE GL_MAP1_GRID_DOMAIN
		GL_POINT_SIZE_RANGE GL_CURRENT_NORMAL
		GL_ACCUM_CLEAR_VALUE GL_BLEND_COLOR_EXT
		GL_COLOR_CLEAR_VALUE GL_CURRENT_COLOR
		GL_CURRENT_RASTER_COLOR GL_CURRENT_RASTER_POSITION
		GL_CURRENT_TEXTURE_COORDS GL_FOG_COLOR
		GL_GREEN_BIAS GL_MAP2_GRID_DOMAIN
		GL_MODELVIEW_MATRIX GL_PROJECTION_MATRIX GL_TEXTURE_MATRIX

		GL_NONE GL_FRONT_LEFT GL_FRONT_RIGHT GL_BACK_LEFT GL_BACK_RIGHT
		GL_LEFT GL_RIGHT GL_AUX0 GL_AUX1 GL_AUX2 GL_AUX3

		GL_PACK_IMAGE_HEIGHT GL_PACK_LENGTH
		GL_PACK_SKIP_IMAGES
		GL_UNPACK_IMAGE_HEIGHT GL_UNPACK_LENGTH
		GL_UNPACK_SKIP_IMAGES
		GL_TEXTURE_WRAP_R GL_TEXTURE_3D

	)]
);
