# Generated by default/object.tt
package Paws::Glue::DecimalNumber;
  use Moose;
  has Scale => (is => 'ro', isa => 'Int', required => 1);
  has UnscaledValue => (is => 'ro', isa => 'Str', required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::Glue::DecimalNumber

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Glue::DecimalNumber object:

  $service_obj->Method(Att1 => { Scale => $value, ..., UnscaledValue => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Glue::DecimalNumber object:

  $result = $service_obj->Method(...);
  $result->Att1->Scale

=head1 DESCRIPTION

Contains a numeric value in decimal format.

=head1 ATTRIBUTES


=head2 B<REQUIRED> Scale => Int

The scale that determines where the decimal point falls in the unscaled
value.


=head2 B<REQUIRED> UnscaledValue => Str

The unscaled numeric value.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Glue>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

