#
# Patch given file with DATA hunks and print to STDOUT.
#
#
# Patch to:
#   - Fixup includes.
#   - Move to uuconfig.h.
#
use strict;
use warnings;
use Text::Patch 'patch';

my $in = $ARGV[0];

my ($txt, $patch);
{
    local $/;
    open my $fh, '<', $in or die "open: $in: $!";
    $txt   = <$fh>;
    $patch = <DATA>;
}

#print $txt;
#print $patch;
#exit;

my $out = patch( $txt, $patch, STYLE => 'Unified' );

print $out;
exit 0;

__END__
--- usrcP/uuid/clear.c	Sun Jan 14 15:29:17 2024
+++ ulib/uuid/clear.c	Sun Jan 14 15:46:57 2024
@@ -32,10 +32,8 @@
  * %End-Header%
  */
 
-#include "config.h"
-#include "string.h"
-
-#include "uuidP.h"
+#include "uuconfig.h"
+#include "uuid/uuidP.h"
 
 void myuuid_clear(myuuid_t uu)
 {

