package Catmandu::Fix::remove_field;

use Catmandu::Sane;

our $VERSION = '1.2006';

use Moo;
use Catmandu::Util::Path qw(as_path);
use namespace::clean;
use Catmandu::Fix::Has;

with 'Catmandu::Fix::Builder';

has path => (fix_arg => 1);

sub _build_fixer {
    my ($self) = @_;
    as_path($self->path)->deleter;
}

1;

__END__

=pod

=head1 NAME

Catmandu::Fix::remove_field - remove a field form the data

=head1 SYNOPSIS

   # Remove the foo.bar field
   remove_field(foo.bar)

=head1 SEE ALSO

L<Catmandu::Fix>

=cut
