/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.filter;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.pdfbox.filter.LZWNode;

class LZWDictionary {
    private Map codeToData = new HashMap();
    private LZWNode root = new LZWNode();
    private ByteArrayOutputStream buffer = new ByteArrayOutputStream();
    private long nextCode = 258L;
    private int codeSize = 9;

    public LZWDictionary() {
        for (long i = 0L; i < 256L; ++i) {
            LZWNode node = new LZWNode();
            node.setCode(i);
            this.root.setNode((byte)i, node);
            this.codeToData.put(new Long(i), new byte[]{(byte)i});
        }
    }

    public byte[] getData(long code) {
        return (byte[])this.codeToData.get(new Long(code));
    }

    public void visit(byte[] data) throws IOException {
        for (int i = 0; i < data.length; ++i) {
            this.visit(data[i]);
        }
    }

    public void visit(byte data) throws IOException {
        this.buffer.write(data);
        byte[] curBuffer = this.buffer.toByteArray();
        LZWNode previous = null;
        LZWNode current = this.root;
        boolean createNewCode = false;
        for (int i = 0; i < curBuffer.length && current != null; ++i) {
            previous = current;
            if ((current = current.getNode(curBuffer[i])) != null) continue;
            createNewCode = true;
            current = new LZWNode();
            previous.setNode(curBuffer[i], current);
        }
        if (createNewCode) {
            long code = this.nextCode++;
            current.setCode(code);
            this.codeToData.put(new Long(code), curBuffer);
            this.buffer.reset();
            this.buffer.write(data);
            this.resetCodeSize();
        }
    }

    public long getNextCode() {
        return this.nextCode;
    }

    public int getCodeSize() {
        return this.codeSize;
    }

    private void resetCodeSize() {
        this.codeSize = this.nextCode >= 2048L ? 12 : (this.nextCode >= 1024L ? 11 : (this.nextCode >= 512L ? 10 : 9));
    }

    public void clear() {
        this.buffer.reset();
    }

    public LZWNode getNode(byte[] data) {
        return this.root.getNode(data);
    }
}

