#include "uulib/compare.h"
#include "uulib/unpack.h"

#define UUCMP(u1,u2) if (u1 != u2) return((u1 < u2) ? -1 : 1);

IV uu_cmp_binary(const uu_t uu1, const uu_t uu2) {
	struct uu us1, us2;

	uu_unpack(uu1, &us1);
	uu_unpack(uu2, &us2);

  return uu_cmp_struct(&us1, &us2);

}

IV uu_cmp_struct(const struct uu *us1, const struct uu *us2) {
	UUCMP(us1->time_low, us2->time_low);
	UUCMP(us1->time_mid, us2->time_mid);
	UUCMP(us1->time_high_and_version, us2->time_high_and_version);
	UUCMP(us1->clock_seq_and_variant, us2->clock_seq_and_variant);
	return memcmp(us1->node, us2->node, 6);
}

/* ex:set ts=2 sw=2 itab=spaces: */
