/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.raw.data;

import java.io.IOException;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.ArrayInputStream;
import org.apache.derby.iapi.services.io.DynamicByteArrayOutputStream;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.store.access.conglomerate.LogicalUndo;
import org.apache.derby.iapi.store.raw.RecordHandle;
import org.apache.derby.iapi.store.raw.xact.RawTransaction;
import org.apache.derby.impl.store.raw.data.BasePage;
import org.apache.derby.impl.store.raw.data.PageActions;

public class DirectActions
implements PageActions {
    protected DynamicByteArrayOutputStream outBytes = new DynamicByteArrayOutputStream();
    protected ArrayInputStream limitIn = new ArrayInputStream();

    public void actionDelete(RawTransaction rawTransaction, BasePage basePage, int n, int n2, boolean bl, LogicalUndo logicalUndo) throws StandardException {
        try {
            basePage.setDeleteStatus(null, n, bl);
        }
        catch (IOException iOException) {
            throw StandardException.newException("XSDA4.S", iOException);
        }
    }

    public int actionUpdate(RawTransaction rawTransaction, BasePage basePage, int n, int n2, Object[] objectArray, FormatableBitSet formatableBitSet, int n3, DynamicByteArrayOutputStream dynamicByteArrayOutputStream, int n4, RecordHandle recordHandle) throws StandardException {
        if (dynamicByteArrayOutputStream == null) {
            this.outBytes.reset();
        } else {
            this.outBytes = dynamicByteArrayOutputStream;
        }
        try {
            int n5 = basePage.logRow(n, false, n2, objectArray, formatableBitSet, this.outBytes, 0, (byte)8, n3, n4, 100);
            this.limitIn.setData(this.outBytes.getByteArray());
            this.limitIn.setPosition(this.outBytes.getBeginPosition());
            this.limitIn.setLimit(this.outBytes.getPosition() - this.outBytes.getBeginPosition());
            basePage.storeRecord(null, n, false, this.limitIn);
            return n5;
        }
        catch (IOException iOException) {
            throw StandardException.newException("XSDA4.S", iOException);
        }
    }

    public void actionPurge(RawTransaction rawTransaction, BasePage basePage, int n, int n2, int[] nArray, boolean bl) throws StandardException {
        try {
            for (int i = n2 - 1; i >= 0; --i) {
                basePage.purgeRecord(null, n + i, nArray[i]);
            }
        }
        catch (IOException iOException) {
            throw StandardException.newException("XSDA4.S", iOException);
        }
    }

    public void actionUpdateField(RawTransaction rawTransaction, BasePage basePage, int n, int n2, int n3, Object object, LogicalUndo logicalUndo) throws StandardException {
        this.outBytes.reset();
        try {
            basePage.logColumn(n, n3, object, this.outBytes, 100);
            this.limitIn.setData(this.outBytes.getByteArray());
            this.limitIn.setPosition(this.outBytes.getBeginPosition());
            this.limitIn.setLimit(this.outBytes.getPosition() - this.outBytes.getBeginPosition());
            basePage.storeField(null, n, n3, this.limitIn);
        }
        catch (IOException iOException) {
            throw StandardException.newException("XSDA4.S", iOException);
        }
    }

    public int actionInsert(RawTransaction rawTransaction, BasePage basePage, int n, int n2, Object[] objectArray, FormatableBitSet formatableBitSet, LogicalUndo logicalUndo, byte by, int n3, boolean bl, int n4, DynamicByteArrayOutputStream dynamicByteArrayOutputStream, int n5, int n6) throws StandardException {
        if (dynamicByteArrayOutputStream == null) {
            this.outBytes.reset();
        } else {
            this.outBytes = dynamicByteArrayOutputStream;
        }
        try {
            n3 = bl ? basePage.logLongColumn(n, n2, objectArray[0], this.outBytes) : basePage.logRow(n, true, n2, objectArray, formatableBitSet, this.outBytes, n3, by, n4, n5, n6);
            this.limitIn.setData(this.outBytes.getByteArray());
            this.limitIn.setPosition(this.outBytes.getBeginPosition());
            this.limitIn.setLimit(this.outBytes.getPosition() - this.outBytes.getBeginPosition());
            basePage.storeRecord(null, n, true, this.limitIn);
            return n3;
        }
        catch (IOException iOException) {
            throw StandardException.newException("XSDA4.S", iOException);
        }
    }

    public void actionCopyRows(RawTransaction rawTransaction, BasePage basePage, BasePage basePage2, int n, int n2, int n3, int[] nArray) throws StandardException {
        try {
            int n4;
            int[] nArray2 = new int[n2];
            for (n4 = 0; n4 < n2; ++n4) {
                this.outBytes.reset();
                basePage2.logRecord(n3 + n4, 0, nArray[n4], null, this.outBytes, null);
                nArray2[n4] = this.outBytes.getUsed();
            }
            if (!basePage.spaceForCopy(n2, nArray2)) {
                throw StandardException.newException("XSDA3.S");
            }
            for (n4 = 0; n4 < n2; ++n4) {
                this.outBytes.reset();
                basePage2.logRecord(n3 + n4, 0, nArray[n4], null, this.outBytes, null);
                this.limitIn.setData(this.outBytes.getByteArray());
                this.limitIn.setPosition(this.outBytes.getBeginPosition());
                this.limitIn.setLimit(this.outBytes.getPosition() - this.outBytes.getBeginPosition());
                basePage.storeRecord(null, n + n4, true, this.limitIn);
            }
        }
        catch (IOException iOException) {
            throw StandardException.newException("XSDA4.S", iOException);
        }
    }

    public void actionInvalidatePage(RawTransaction rawTransaction, BasePage basePage) throws StandardException {
        basePage.setPageStatus(null, (byte)2);
    }

    public void actionInitPage(RawTransaction rawTransaction, BasePage basePage, int n, int n2, long l) throws StandardException {
        boolean bl = (n & 2) != 0;
        boolean bl2 = (n & 1) != 0;
        int n3 = (n & 4) == 0 ? basePage.newRecordId() : 6;
        basePage.initPage(null, (byte)1, n3, bl, bl2);
    }

    public void actionShrinkReservedSpace(RawTransaction rawTransaction, BasePage basePage, int n, int n2, int n3, int n4) throws StandardException {
        try {
            basePage.setReservedSpace(null, n, n3);
        }
        catch (IOException iOException) {
            throw StandardException.newException("XSDA4.S", iOException);
        }
    }
}

