#!/usr/bin/perl

package eBay::API::XML::Call::GetReturnURL;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. GetReturnURL.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 07/07/2008 17:42
# API Release Number: ... 571
#
##########################################################################  

=head1 NAME

eBay::API::XML::Call::GetReturnURL

=head1 DESCRIPTION



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::Call::GetReturnURL inherits from the L<eBay::API::XML::BaseCall> class

=cut

use eBay::API::XML::BaseCall;
our @ISA = ("eBay::API::XML::BaseCall");

use eBay::API::XML::Call::GetReturnURL::GetReturnURLRequestType;
use eBay::API::XML::Call::GetReturnURL::GetReturnURLResponseType;


=head1 Subroutines:

=cut

sub getApiCallName {
   return 'GetReturnURL';
}
sub getRequestDataTypeFullPackage {
   return 'eBay::API::XML::Call::GetReturnURL::GetReturnURLRequestType';
}
sub getResponseDataTypeFullPackage {
   return 'eBay::API::XML::Call::GetReturnURL::GetReturnURLResponseType';
}

#
# input properties
#



#
# output properties
#

=head2 getApplicationDisplayName()

Display name for the application. When your application
redirects users to eBay to complete the authentication and
authorization process, eBay displays this value to identify
your application to the user.

  Returned: Always
#    Returns: 'xs:string'

=cut
       
sub getApplicationDisplayName {
   my $self = shift;
   return $self->getResponseDataType()->getApplicationDisplayName();
}

=head2 getAuthenticationEntryArray()

One or more sets of authentication preferences and other data that you
have configured for your application (if any). Call SetReturnURL to
configure this data.

  Returned: Conditionally
#    Returns: 'ns:AuthenticationEntryArrayType'

=cut
       
sub getAuthenticationEntryArray {
   my $self = shift;
   return $self->getResponseDataType()->getAuthenticationEntryArray();
}





1;   
