/* unixio.h - 14:52 GMT +10:00 Wed 4 Aug 1993 - modifier Geoffrey Tobin */

#ifndef UNIXIO_H
#define UNIXIO_H

/* Include file "unixio.h" from screenio.c */

/* The use of `Void' requires that "config.h" be included beforehand */

#ifndef CONFIG_H
#include "config.h"
#endif /* CONFIG_H */

/* Add a global structure so we don't need BSD specific stuff. */
/*    -- Ian Dall */

/* gt - for some reason, the Aix "xlc" compiler claims that these
   structure declarations of sig_flags and cmode_flags cause invalid
   redeclarations of the same variables where they are defined in
   "unixio.c".
*/
#ifndef IN_UNIXIO_C
extern struct { unsigned int intr, tstop : 1;} sig_flags;
extern struct { unsigned int cbreak, raw, echo : 1;} cmode_flags;
#endif

/* Alex Dickinson                                                         */
/* Definitions for some unix ioctl calls. These external procedures       */
/* refer to the C functions contained in unixio.c.                        */

extern Void save_init_tty (VOID);
extern Void restore_init_tty (VOID);
extern Void save_temp_tty (VOID);
extern Void restore_temp_tty (VOID);
extern Void singlecharon (VOID);
extern Void singlecharoff (VOID);
extern Void echoon (VOID);
extern Void echooff (VOID);
extern Void rawouton (VOID);
extern Void rawoutoff (VOID);
extern int buffercount (VOID);
extern Void suspend (VOID);

#endif /* UNIXIO_H */

/* end unixio.h */
