/* vt100132vdu.c - 19:03 GMT +10:00 Sat 12 Jun 1993 - modifier Geoffrey Tobin */

/* From input file "../include/globals.p" */

#include "config.h"
#include "globals.h"
#include "screenio.h"
#include "vdu.h"

/******************************************************************************/

Void VT100132ResetVDU (VOID)
{
  /* We assume user wants to return to 80 column mode. */
  WriteChar (ESC);
  WriteString ("[?3l");

  textlinewidth = 80;  /* text characters per line */
}
/* VT100132ResetVDU */

/******************************************************************************/

/* On a VT100, a "pixel" is a character. */

#define screenwd        132   /* width of wide VT100 screen in pixels */
#define screenht        24    /* height of VT100 screen in pixels */
#define lineht          1     /* height of one text line in pixels */

extern Void InitVT100();

Void InitVT100132 (VOID)
{
  /* The main program only calls this routine after it has parsed the command
     line and successfully opened the given DVI file.
  */
  /* initialize the VDU parameters */
  InitVT100();
  ResetVDU = VT100132ResetVDU;
  windowwd = screenwd;

  /* 132 column mode */
  WriteChar (ESC);
  WriteString ("[?3h");

  textlinewidth = screenwd;  /* text characters per line */
}
/*InitVT100132 */

#undef screenwd
#undef screenht
#undef lineht

/******************************************************************************/

/* end vt100132vdu.c */
