/* vt640vdu.c - 19:05 GMT +10:00 Sat 12 Jun 1993 - modifier Geoffrey Tobin */

/* From input file "../include/globals.p" */

#include "config.h"
#include "globals.h"

#include "screenio.h"
#include "vdu.h"

#include "tek4010emu.h"
#include "vt100vdu.h"

/******************************************************************************/

#ifdef __STDC__
Void VT640MoveToTextLine (int line)
#else
Void VT640MoveToTextLine (line)
int line;
#endif
{
  /* Move current position to start of given line. */

  WriteChar (GS);   /* cannot send CAN if VT640 is already in VT100 mode */

  WriteChar (CAN);   /* switch to VT100 mode */

  VT100MoveToTextLine (line);
}
/* VT640MoveToTextLine */

/******************************************************************************/

#ifdef __STDC__
Void VT640ClearTextLine (int line)
#else
Void VT640ClearTextLine (line)
int line;
#endif
{
  /* Erase given line; note that DVItoVDU does not assume anything about the
     current position at the end of this routine.
  */

  WriteChar (GS);

  WriteChar (CAN);

  VT100ClearTextLine (line);
}
/* VT640ClearTextLine */

/******************************************************************************/

Void VT640ClearScreen (VOID)
{
  WriteChar (GS);

  WriteChar (CAN);

  VT100ClearScreen();		/* erase all alphanumerics */
  TEK4010ClearScreen();
}
/* VT640ClearScreen */

/******************************************************************************/

Void VT640ResetVDU (VOID)
{
  WriteChar (GS);   /* cannot send CAN if VT640 is already in VT100 mode */

  WriteChar (CAN);   /* switch to VT100 mode */

}
/* VT640ResetVDU */

/******************************************************************************/

Void InitVT640 (VOID)
{
  /* The dialog region will be the top 4 text lines in VT100 mode:
        Line 1 = DVI status line,
        Line 2 = window status line,
        Line 3 = message line,
        Line 4 = command line.
     The window region will be text lines 5 to 24 in VT100 mode.
  */

  InitTEK4010emu();

  /* The following values assume the VT640 is in VT100 mode. */

  DVIstatusl = 1;   /* DVItoVDU assumes top text line = 1 */
  windowstatusl = 2;
  messagel = 3;
  commandl = 4;
  bottoml = 24;   /* also number of text lines on screen */

  textlinewidth = 80;  /* text characters per line */

  /* The following values assume it is emulating a Tektronix 4010.
     Note that windowv must be given a value using DVItoVDU's
     coordinate scheme, where top left pixel is (0,0).
  */

  windowv = 130;
  /* approx. height in TEK4010 pixels of 4 text lines
                              i.e. 4 * 780/24 */
  windowh = 0;
  windowht = 780 - windowv;
  windowwd = 1024;

  MoveToTextLine = VT640MoveToTextLine;
  ClearTextLine  = VT640ClearTextLine;
  ClearScreen    = VT640ClearScreen;
  StartText      = TEK4010StartText;
  StartGraphics  = TEK4010StartGraphics;
  LoadFont       = TEK4010LoadFont;
  ShowChar       = TEK4010ShowChar;
  ShowRectangle  = TEK4010ShowRectangle;
  ResetVDU       = VT640ResetVDU;
}
/*InitVT640 */

/******************************************************************************/

/* end vt640vdu.c */
