/*
 * Created on Mar 17, 2003
 *
 * @author henkel@cs.colorado.edu
 * 
 */
package bibtex.dom;

import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

import bibtex.visitor.BibtexVisitor;

/**
 * @author	henkel
 * @author	Yann-Gal Guhneuc
 */
public class BibtexEntry
	extends BibtexAbstractEntry
	implements Serializable {

	private String entryType;
	private String entryKey;
	private HashMap fields = new HashMap();

	protected BibtexEntry(String entryType, String entryKey) {
		this.entryKey = entryKey;
		this.entryType = entryType.toLowerCase();
	}
	/**
	 * Returns a read only view of the field map.
	 * This is a mapping from java.lang.String instances (field names) to instances of
	 * BibtexAbstractValue.
	 * 
	 * @return HashMap
	 */
	public void accept(final BibtexVisitor visitor) {
		visitor.open(this);

		final Iterator iterator = this.fields.entrySet().iterator();
		while (iterator.hasNext()) {
			final Map.Entry entry = (Map.Entry) iterator.next();
			((BibtexNode) entry.getValue()).accept(visitor);
		}

		visitor.close(this);
	}
	public void addField(final BibtexField bibtexField) {
		// Yann 2003/03/28: Need a type.
		// I need to manage the fieldName as a BibtexKey
		// and BibtexAbstractValue to work with the
		// BibtexVisitor.
		fields.put(bibtexField.getKey(), bibtexField);
	}
	public Map getFields() {
		return Collections.unmodifiableMap((Map) fields.clone());
	}
	public String getKey() {
		return entryKey;
	}
	public String getType() {
		return entryType;
	}
	public void print(PrintWriter writer) {
		writer.print('@');
		writer.print(this.entryType);
		writer.print('{');
		writer.print(this.entryKey);
		writer.println(',');

		final Iterator iterator = this.fields.entrySet().iterator();
		while (iterator.hasNext()) {
			Map.Entry entry = (Map.Entry) iterator.next();
			writer.print('\t');
			((BibtexNode) entry.getValue()).print(writer);
			writer.println(',');
		}

		writer.println('}');
	}
	public void undefineField(String fieldName) {
		this.fields.remove(fieldName);
	}
}
