import java.awt.*;
import javax.swing.*;
import javax.swing.event.*;

/*
 * SlideCommandChooser.java
 *
 */

/**
 *
 *  This class implements a GUI letting the user pick
 *  commands describing slides from a list.
 *
 * @author  Olle Nebendahl
 */

public class SlideCommandChooser extends JDialog 
{
    public CommandRepresentation result;

    private JButton discardButton;
    private JButton saveButton;
    private JLabel jLabel1;
    private JList jList1;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane jScrollPane1;
    
    public boolean approved=false;
    public boolean hasChanged() { return approved; }

    DefaultListModel myListModel;

    /** Creates new form SlideCommandChooser */
    public SlideCommandChooser(java.awt.Frame parent, boolean modal, DefaultListModel lm) 
    {
        super(parent, modal);
        myListModel=lm;
        initComponents();
    }

    public SlideCommandChooser(java.awt.Frame parent, boolean modal, OLL list)
    {
        super(parent, modal);
        myListModel= new DefaultListModel();
        list.reset();
        while(list.hasNext())
            myListModel.addElement(list.getNext());

        initComponents();
    }
    
    private void initComponents() 
    {
        approved=false;
        jLabel1 = new JLabel();
        jPanel1 = new JPanel();
        jScrollPane1 = new JScrollPane();
        jList1 = new JList();
        jList1 = new JList(myListModel);
        jPanel2 = new JPanel();
        discardButton = new JButton();
        saveButton = new JButton();

        getContentPane().setLayout(new BoxLayout(getContentPane(), BoxLayout.Y_AXIS));

        setDefaultCloseOperation(WindowConstants.DISPOSE_ON_CLOSE);
        jLabel1.setText("Edit preferred slide defining commands");
        
        getContentPane().add(jLabel1);
        getContentPane().add(new JLabel("ordered by preference - highest first:"));

        jPanel1.setLayout(new BoxLayout(jPanel1, BoxLayout.X_AXIS));

        jScrollPane1.setPreferredSize(new java.awt.Dimension(260, 32));
        jScrollPane1.setViewportView(jList1);

        jPanel1.add(jScrollPane1);

        jPanel2.setLayout(new BoxLayout(jPanel2, BoxLayout.Y_AXIS));

        jPanel1.add(jPanel2);

        getContentPane().add(jPanel1);

        discardButton.setText("desired command not found");
        discardButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                discardButtonActionPerformed(evt);
            }
        });
        getContentPane().add(discardButton);

        saveButton.setText("choose");
        saveButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                saveButtonActionPerformed(evt);
            }
        });
        getContentPane().add(saveButton);

        pack();
    }
    
    public void setVisible(boolean b)
    {
        if(!b)
        {
            getLocation(Constants.prefSlideCommandsGUICoordinates);
            Constants.savePreferences();
        }
        else setLocation(Constants.prefSlideCommandsGUICoordinates);
        super.setVisible(b);
    }


    private void saveButtonActionPerformed(java.awt.event.ActionEvent evt) 
    {
        int i=jList1.getSelectedIndex();
        result=null;
        if(i>=0)
        {
            approved=true;
            result=(CommandRepresentation)myListModel.get(i);
        }
        setVisible(false);
    }

    private void discardButtonActionPerformed(java.awt.event.ActionEvent evt) 
    {
        setVisible(false);
    }


    /**
     * @param args the command line arguments
     */
    public static void main(String args[]) 
    {
    }
}
