#include <stdio.h>
#include "hfonts.h"
#define INDEX_SIZE 8000
#define DATA_SIZE 128000
#define END_FLAG 0
static unsigned char out_array[INDEX_SIZE + DATA_SIZE];
main()
{
static unsigned char all_array[INDEX_SIZE + DATA_SIZE];
static int indices_done[INDEX_SIZE][2], max_index;
int bytes_got, i, j, k, l, m, index_in, index_out, out_val, new_index;
FILE *inptr, *outptr;
char in_file[] = "hfonts.bin";
char out_file[] = "hload.h";
#define NO_FONTS 4
static char *fonts_wanted[NO_FONTS] = {
"HERSHEY:SIMPLEX_ROMAN",
"HERSHEY:COMPLEX_ROMAN",
"HERSHEY:TRIPLEX_ROMAN",
"HERSHEY:COMPLEX_GREEK"};

	/* open the file */
	if (NULL == (inptr = fopen(in_file, "r"))) {
	    fprintf(stderr, "couldn't open %s for input !\n", in_file);
	    return(0);
	}

	/* load it all in */
	bytes_got = 0;
	/* do it the slow way */	
	while ((!feof(inptr)) && (bytes_got < (INDEX_SIZE + DATA_SIZE)))
	    all_array[bytes_got++] = getc(inptr);

	fprintf(stderr, "read %d bytes\n", bytes_got);	
	fclose(inptr);

	/* now create a new file and index */
	if (NULL == (outptr = fopen(out_file, "w"))) {
	    fprintf(stderr, "couldn't open %s for output !\n", out_file);
	    return(0);
	}

	fprintf(outptr, "\n#define NO_HF %d\n", NO_FONTS);
	fprintf(outptr, "\n#define MAX_HCHARS %d\n", 128);
	fprintf(outptr, "\nstatic char *h_used[NO_HF] = {");

/* now go thru all of the fonts */
	for (i=0; i<(NO_FONTS - 1); ++i) 
	    fprintf(outptr, "\n\"%s\",", fonts_wanted[i]);
	fprintf(outptr, "\n\"%s\"};\n", fonts_wanted[i]);

	fprintf(outptr, "\nstatic int h_array[NO_HF][MAX_HCHARS] = {");
	max_index = 0;
	index_out = 0;
	for (i=0; i<NO_FONTS; ++i) {
	    fprintf(stderr, "starting %s\n", fonts_wanted[i]);
	    for (j=0; (j<NO_HFONTS) && 
		strcmp(fonts_wanted[i], h_names[j]); ++j);
	    if (j>=NO_HFONTS) {
		fprintf(stderr, "couldn't find %s\n", fonts_wanted[i]);
		return(0);
	    } else fprintf(stderr, "using font %d\n", j);
	    fprintf(outptr, "\n{");
	    for (k=0; k<MAX_HCHARS; ++k) {
		if (index_in = h_ptrs[j][k]) {	/* have that character */
		/* have we already done it ? */
		    for (l=0; (l<max_index) && (indices_done[l] != index_in);
			++l);
		    if (l == max_index) {	/* new one */
			indices_done[l][0] = index_in;
			new_index = (all_array[(index_in - 1) * 2] << 8) +
			    all_array[(index_in - 1) * 2 + 1];
			indices_done[l][1] = index_out;
			++max_index;
			m = INDEX_SIZE + (new_index - 1) * 2;
			while ((all_array[m] != END_FLAG) || 
			    (all_array[m+1] != END_FLAG)) {
			    out_array[index_out++] = all_array[m++];
			    out_array[index_out++] = all_array[m++];
			}
			out_array[index_out++] = END_FLAG;
			out_array[index_out++] = END_FLAG;
		    }
		    out_val = indices_done[max_index-1][1];
		} else out_val = -1;
		if (k && !(k%16)) fprintf(outptr, "\n");
		if (k<(MAX_HCHARS - 1)) fprintf(outptr, "%d,", out_val);
		else if (i<(NO_FONTS-1)) fprintf(outptr, "%d},\n", out_val);
		else fprintf(outptr, "%d}};\n", out_val);
	    }
	    fprintf(stderr, "finished %s\n", fonts_wanted[i]);
	}
/* now spit out the data */
	fprintf(outptr, "\nstatic unsigned char hf_array[%d] = {\n",
	    index_out);
	for (i=0; i<index_out; ++i) {
	    if (i && !(i%20)) fputc('\n', outptr);
	    fprintf(outptr, "%d", out_array[i]);
	    if (i<(index_out-1)) fputc(',', outptr);
	}
	fprintf(outptr, "};\n");
	fclose(outptr);
}
