# Voreinstellungsmen fr TeX
#
# Copyright (C) 1994  G. Lamprecht, W. Lotz, R. Weibezahn; LRW c/o Uni Bremen
# Copyright (C) 1996  G. Lamprecht, W. Lotz, R. Weibezahn; IWD, Bremen University

proc tv {} {

proc tvWtae {} { global vv Wt tvErr
 set tvErr 0; tvfocus ""; if {$tvErr==0} {tvfocus ""; destros $Wt; knoepfe; unlock_list}
}

proc tvfocus {w} {global Wt tvFoc
 if {$tvFoc==1} tvEOfull elseif {$tvFoc==2} tvEUfull elseif {$tvFoc==3} tvEMaxL
 if {$w!=""} {focus $w} else {Focus $Wt}
}

proc tvEOfull {} {global vv Wt tvFoc tlOfull tlOverfull tvOMax tvErr
 regsub -all " " $tlOfull "" tlOfull
 if {[CheckNumReal $tlOfull]<=0} {
   set tlOfull $tlOverfull; writescr0 $Wt.d.tt $vv(tvt6); set tvErr 1; mybell 2
 } else {
   if {[catch "if {$tlOfull>$tvOMax} {}"]||($tlOfull>$tvOMax)} \
	{set tlOfull $tvOMax; set tvErr 1; mybell 2}
 }
 set tvFoc 0
}

proc tvEUfull {} {global vv Wt tvFoc tlHBad tlHBadness tvErr
 regsub -all " " $tlHBad "" tlHBad
 if {[CheckNumInt $tlHBad]<=0} {
   set tlHBad $tlHBadness; writescr0 $Wt.d.tt $vv(tvt5); set tvErr 1; mybell 2
 } else {
   if {[string length $tlHBad]>9||($tlHBad>10000)} {set tlHBad 10000; set tvErr 1; mybell 2}
 }
 set tvFoc 0
}

proc tvEMaxL {} {global vv Wt tvFoc tlMaxL tlMaxLines tvErr
 regsub -all " " $tlMaxL "" tlMaxL
 if {[CheckNumInt $tlMaxL]<1} {
   set tlMaxL $tlMaxLines; writescr0 $Wt.d.tt $vv(tvt5); set tvErr 1; mybell 2
 }  else {
   if {[string length $tlMaxL]>9||($tlMaxL>100000)} {set tlMaxL 100000; set tvErr 1; mybell 2}
 }
 set tvFoc 0
}

proc tvLSel {s} {global vv Wt tvsep3 tvLSel_v texloganalyze texlogatext texlogopts
 set texlogatext [getvalue $s 0 $tvsep3]; set texloganalyze [getvalue $s 1 $tvsep3]
 set texlogopts  [getvalue $s 2 $tvsep3]
 writescr0 $Wt.d.tt "$vv(tvt1) $vv(tvc1ll) $texlogatext"; set tvLSel_v "$s"
}

proc tvHSel {s} {
 global vv Wt tvsep4 tvHSel_v hyphentext hyphenprog hyphenopts hyphenchk texposthyph
 set hyphentext [getvalue $s 0 $tvsep4]; set texposthyph [getvalue $s 1 $tvsep4]
 set hyphenprog [getvalue $s 2 $tvsep4]; set hyphenopts [getvalue $s 3 $tvsep4]
 set hyphenchk [getvalue $s 4 $tvsep4]
 if {$hyphenchk==""} {set hyphenchk {$mainfile.hck}}
 if {$hyphenchk=="/dev/null"} {set hyphenchk ""}
 writescr0 $Wt.d.tt "$vv(tvt1) $vv(tvch) $hyphentext"; set tvHSel_v "$s"
}

proc tvanzeigen {w s1} {
 global vv texfmt texfmtt texmem texmtext texmax texsuffix dir efile esuff main_file tsuff
 global texlogatext texloganalyze texlogopts tlDirIgnore quickenable quickverbatim quickprereq
 global quickpreform quicksuffix quickpreamble quickendpre quickenddoc texposttex
 global hyphentext hyphenprog hyphenopts hyphenchk texposthyph
if {$texmax==1} {set tvTexMax $texmax} else {set tvTexMax "$vv(max) $texmax"}
 if {($texfmtt!=$texfmt)&&($texfmtt!="")} {set t "($texfmtt)"} else {set t ""}
 if {$quickenable} {set qe $vv(enabl)} else {set qe $vv(disabl)}
 writescr0 $w.d.tt "$s1\n\n TeX-$vv(tv2) $texfmt $t\n" \
   [alternative $texmem "    $vv(tv3) $texmtext\n" "    $vv(tv3) $texmtext   <$texmem>\n"] \
   "    $vv(tv4) $texmax\n    texposttex=$texposttex\n    texposthyph=$texposthyph\n" \
   " $vv(tvch) $hyphentext\n" \
   [alternative $hyphenprog "" "    hyphenprog=$hyphenprog $hyphenopts $hyphenchk\n"] \
   " $vv(tvc1ll)\n" \
   " $texlogatext ($texloganalyze" [alternative $texlogopts "" :$texlogopts] ")\n" \
   " $vv(tvt7) $tlDirIgnore\n\n" \
   " $vv(tv5) $dir\n $vv(tv6) $texsuffix\n" \
   [alternative $efile " $vv(bad1)\n" " $vv(bad2) $efile$esuff\n"] \
   [alternative $main_file " $vv(tvbad1) $texfmt $vv(tvbad3)\n" \
     " $vv(tvbad2) $texfmt $vv(tvbad3): $main_file$tsuff\n\n"] \
   "$vv(xtc1qd) $qe: $quickenable $quickverbatim $quickprereq $quickpreform $quicksuffix\n"
 if {$quickenable} {writescr $w.d.tt \
	"             $quickpreamble  <$vv(qd7)>  $quickendpre <$vv(qd8)>  $quickenddoc\n\n"
 }
}

proc tvfsel {s} {
 global Wt vv tvsep2 texfmtt texfmt tvfsel_v quickenable quickverbatim quickprereq
 global quickpreform quicksuffix quickpreamble quickendpre quickenddoc
 set texfmtt [getvalue $s 0 $tvsep2]; set texfmt [getvalue $s 1 $tvsep2]
 set quickenable [getvalue $s 2 $tvsep2]; set quickverbatim [getvalue $s 3 $tvsep2]
 set quickprereq [getvalue $s 4 $tvsep2]; set quickpreform [getvalue $s 5 $tvsep2]
 set quicksuffix [getvalue $s 6 $tvsep2]; set quickpreamble [getvalue $s 7 $tvsep2]
 set quickendpre [getvalue $s 8 $tvsep2]; set quickenddoc [getvalue $s 9 $tvsep2]
 if {$quickenable==""} {set quickenable 0}
 if {$quickenable} {setInUnlockListe .c.1.qd} {delFromUnlockListe .c.1.qd}
 if {$quickenable} {set qe $vv(enabl)} else {set qe $vv(disabl)}
 writescr0 $Wt.d.tt "$vv(tvt1) $vv(tv2) $texfmt\n$vv(xtc1qd) $qe"; knoepfe; set tvfsel_v "$s"
}

proc tvssel {s} {
 global Wt vv tvsep1 texmem texmtext tvssel_v
 set texmtext [getvalue $s 0 $tvsep1]; set texmem [getvalue $s 1 $tvsep1]
 writescr0 $Wt.d.tt "$vv(tvt1) $vv(tv3) $texmtext " [alternative $texmem "\n" "<$texmem>\n"]
 knoepfe; set tvssel_v "$s"
}

proc tvmsel {s} {
 global Wt vv texmax tvmsel_v
 if {[string length $s]>1} {set texmax [lindex $s 1]} else {set texmax "$s"}
 writescr0 $Wt.d.tt "$vv(tvt1) $vv(tv4) $texmax\n"; knoepfe; set tvmsel_v "$s"
}


global Wt vv tvsep1 tvsep2 tvsep3 tvsep4 tvfsel_v tvssel_v tvmsel_v tvLSel_v tvHSel_v
global main_file texfmt texfmtt texmtext texmax texlogatext tlOfull tlHBad tvFoc tvOMax tlMaxL
global hyphentext

set tvOMax 999999.99


toplevel_init $Wt "$vv(tvvor)" 0 0;  set tyh 16


# Bereich a fuer erste Buttons

insertTopButtons $Wt tv_h tvWtae
button $Wt.a.g -text "$vv(ag)" -command {vstr_tex; tvanzeigen $Wt "$vv(ausg1)"; knoepfe}
Bind3HF $Wt.a.g tv_grund $Wt.d.tt
pack configure $Wt.a.g -side left -padx 3 -pady 3


# Bereich bv fuer eigene Einstellungen

frame $Wt.bv; pack configure $Wt.bv -pady 13 -anchor w

label  $Wt.bv.dv -text "$vv(bvdv)" -width 23 -anchor w
Bind3HF $Wt.bv.dv z_voreinst1 $Wt.d.tt
button $Wt.bv.va -text "$vv(bvva)" -command {tvanzeigen $Wt "$vv(aus0)"}
Bind3HF $Wt.bv.va z_voreinst1 $Wt.d.tt

pack configure $Wt.bv.dv $Wt.bv.va -side left


# Bereich c fuer Wechsel: Format, Speichergre, max.TeX-Durchlufe, Logfile-Analyse

frame $Wt.c; pack configure $Wt.c -anchor nw
foreach w "$Wt.c.f $Wt.c.s $Wt.c.m $Wt.c.l $Wt.c.h" \
	{frame $w; pack configure $w -anchor ne -side left -pady 3 -ipadx 3}

# Format
set tvsep2 [getsep texfmt.vst]
CreateLSBox $Wt.c.f $vv(tvc1fl) top 16 5 2 tv_fmtsel $Wt.d.tt \
	$tvsep2 [vst2list texfmt.vst 1 $tvsep2 "$texfmtt" tvfsel_v] tvfsel "" tvWtae

# Speichergre
set tvsep1 [getsep texsiz.vst]; set sl [vst2list texsiz.vst 1 $tvsep1 "$texmtext" tvssel_v]
if {[llength $sl]>1} {
  CreateLSBox $Wt.c.s $vv(tvc1sl) top 12 5 2 tv_speich $Wt.d.tt $tvsep1 "$sl" tvssel "" tvWtae
}

# max.TeX-Durchlufe
if {$texmax==1} {set tvmsel_v $texmax} else {set tvmsel_v "$vv(max) $texmax"}
set ml "1 {$vv(max) 2} {$vv(max) 3} {$vv(max) 4}"
CreateLSBox $Wt.c.m $vv(tv4) top 11 5 2 tv_dlz $Wt.d.tt "" "$ml" tvmsel "" tvWtae

# Logfile-Analyse
if ![info exists tvsep3] {set tvsep3 [getsep loganalyze.vst]}
CreateLSBox $Wt.c.l $vv(tvc1ll) top 24 5 2 tv_loganlyz $Wt.d.tt \
	$tvsep3 [vst2list loganalyze.vst 1 $tvsep3 "$texlogatext" tvLSel_v] tvLSel "" tvWtae

# Hyphenation_Show after TeX run
if ![info exists tvsep4] {set tvsep4 [getsep hyphen.vst]}
CreateLSBox $Wt.c.h $vv(tvch) top 8 5 2 tv_texposth $Wt.d.tt \
	$tvsep4 [vst2list hyphen.vst 1 $tvsep4 "$hyphentext" tvHSel_v] tvHSel "" tvWtae


# Bereich fr Overfull/Underfull/MaxLines
frame $Wt.co; frame $Wt.cu; frame $Wt.cm
pack configure $Wt.co $Wt.cu $Wt.cm -anchor nw -side top

label $Wt.co.l1 -text $vv(tlco1)
Bind3HF $Wt.co.l1 tv_overfull $Wt.d.tt
entry $Wt.co.e -textvariable tlOfull -width 10 -relief sunken
bind $Wt.co.e <Button-1> {tvfocus $Wt.co.e; set tlOfull ""; set tvFoc 1}
Bind3HF $Wt.co.e tv_overfull $Wt.d.tt
bind $Wt.co.e <Return> {tvEOfull; tvfocus $Wt.d.tt}
label $Wt.co.l2 -text $vv(tlco2)
Bind3HF $Wt.co.l2 tv_overfull $Wt.d.tt
pack configure $Wt.co.l1 $Wt.co.e $Wt.co.l2 -anchor w -side left

label $Wt.cu.l1 -text $vv(tlcu1)
Bind3HF $Wt.cu.l1 tv_undrfull $Wt.d.tt
entry $Wt.cu.e -textvariable tlHBad -width 8 -relief sunken
bind $Wt.cu.e <Button-1> {tvfocus $Wt.cu.e; set tlHBad ""; set tvFoc 2}
Bind3HF $Wt.cu.e tv_undrfull $Wt.d.tt
bind $Wt.cu.e <Return> {tvEUfull; tvfocus $Wt.d.tt}
label $Wt.cu.l2 -text $vv(tlcu2)
Bind3HF $Wt.cu.l2 tv_undrfull $Wt.d.tt
pack configure $Wt.cu.l1 $Wt.cu.e $Wt.cu.l2 -anchor w -side left

label $Wt.cm.l1 -text $vv(tlcm1)
Bind3HF $Wt.cm.l1 tv_maxlines $Wt.d.tt
entry $Wt.cm.e -textvariable tlMaxL -width 8 -relief sunken
bind $Wt.cm.e <Button-1> {tvfocus $Wt.cm.e; set tlMaxL ""; set tvFoc 3}
Bind3HF $Wt.cm.e tv_maxlines $Wt.d.tt
bind $Wt.cm.e <Return> {tvEMaxL; tvfocus $Wt.d.tt}
label $Wt.cm.l2 -text "$vv(tlcm2) ([alternative $main_file "*" "$main_file"].log) $vv(tlcm3)"
Bind3HF $Wt.cm.l2 tv_maxlines $Wt.d.tt
pack configure $Wt.cm.l1 $Wt.cm.e $Wt.cm.l2 -anchor w -side left


InsertTextFrame $Wt $tyh "" "" ""
set tvFoc 0
}
