unit Edit;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ComCtrls, Menus, ShellApi, Clipbrd, RichEdit, Buttons,
  extctrls, IspellInterface, Math;
const
  LF: string = #13#10;
  //EOF: string = #0#0;
  CR = #13;
  NL = #10;
  APO = #27; // apostroph
  TAB = #9;  // tabulator

  MAXCOMMAND = 255;
  MAXPATH = 255;
  BUFFERINCREMENT = 100000; // Edit buffer = file size + BUFFERINCREMENT
  strSave    = 'Save changes to "%s"?';

  // *DS* file filters
  TEX_FORMAT = 1;  // old default format, ANSI
  UTF8_FORMAT = 2;
  DOS_FORMAT = 3;
  UNIX_FORMAT = 4;
  STYLE_FORMAT = 5;
  ALL_FORMATS = 6;


type
  //*DS* used with EM_STREAMIN to load Unicode
  ReadBuffer = record
    pMemory: PBYTE;
    cRead: integer;
    size: integer;
  end;

  TEditForm = class(TForm)
    RichEdit: TRichEdit;
    PopupMenu1: TPopupMenu;
    Cut1: TMenuItem;
    Copy2: TMenuItem;
    Paste2: TMenuItem;
    Commentout1: TMenuItem;
    N4: TMenuItem;
    N5: TMenuItem;
    Open2: TMenuItem;
    Execute1: TMenuItem;
    Bold1: TMenuItem;
    Emphasis1: TMenuItem;
    PMPanel: TPopupMenu;
    Save1: TMenuItem;
    Saveas1: TMenuItem;
    Close1: TMenuItem;
    N1: TMenuItem;
    Setasmainfile1: TMenuItem;
    SaveDialog: TSaveDialog;
    N3: TMenuItem;
    UpdateSelection1: TMenuItem;
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormCreate(Sender: TObject);
    procedure WordWrapClick(Sender: TObject);
    procedure BoldClick(Sender: TObject);
    procedure Open2Click(Sender: TObject);
    procedure Execute1Click(Sender: TObject);
    procedure FindDialog1Find(Sender: TObject);
    procedure ReplaceDialog1Find(Sender: TObject);
    procedure ReplaceDialog1Replace(Sender: TObject);
    procedure Find2Click(Sender: TObject);
    procedure RichEditKeyUp(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure GoToLine1Click(Sender: TObject);
    procedure RichEditMouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure FormActivate(Sender: TObject);
    procedure FormMouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure FormKeyUp(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure RichEditMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure UpdateMenus(Sender: TObject);
    procedure Emphasis1Click(Sender: TObject);
    procedure RichEditKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure RichEditKeyPress(Sender: TObject; var Key: Char);
    procedure RichEditChange(Sender: TObject);
    procedure FormDeactivate(Sender: TObject);
    //procedure FormResize(Sender: TObject);
    procedure Close1Click(Sender: TObject);
    procedure Save1Click(Sender: TObject);
    procedure Saveas1Click(Sender: TObject);
    procedure Setasmainfile1Click(Sender: TObject);
    procedure UpdateSelection1Click(Sender: TObject);
    procedure Cut1Click(Sender: TObject);
    procedure Copy2Click(Sender: TObject);
    procedure Paste2Click(Sender: TObject); //*PN*
    procedure DoWinPanelPopup(Sender: TObject;
      Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
    procedure Commentout1Click(Sender: TObject);
  private
    endOfDocReached: boolean; // used by the Replace Dialog
    pFormat:   ^TCharFormat; { the active syntax Format }
    pStandardFormat:   ^TCharFormat;
    pTexCommandFormat: ^TCharFormat;
    pParenthesisFormat: ^TCharFormat;
    pSquareBracketFormat: ^TCharFormat;
    pRoundBracketFormat: ^TCharFormat;
    pDollarFormat:       ^TCharFormat;
    pCommentFormat:      ^TCharFormat;
    ToFind: string;        {aufzufindender String}
//    FindIn: string;        {zu durchsuchender String}
    Found: integer;        {Positionsmerker fr gefundenen String}
//    Index: integer;        {Startposition des gefundenen Textes}
    FoundLen: integer;     {Lnge des gefundenen Textes}
//    FoundText: string;     {zu ersetzender String}
//    DidFind: boolean;      {Merker: Suchen fand vor dem Ersetzen statt}
//    procedure InsertLineSpecials;
//    procedure RemoveLineSpecials;

    //*DS* Unicode support
    isUnicode: boolean;

    procedure SetFilename(newfilename: string);
    // convert TeX text to rtf format for syntax highlighting
    procedure TexToRtf (input: TMemoryStream; output: TMemoryStream; format: integer);
    procedure SetFont(theFont: TFont);
    procedure SaveOEM (const aFileName: string);

    //*DS* Unicode support
    procedure SaveUtf8ToFile( const aFileName: string );
    procedure SaveUtf8ToStream( outStream: TStream );
    procedure LoadUtf8FromStream( source: TMemoryStream );

  public
    syntaxColorIsValid: boolean;
    txxIsValid: boolean;  // does valid .txx file exist?
    theFileName : string; //*PN*
    shortFileName : string[255];
    theWinPanel : TSpeedButton; //*PN* link to Panel in WindowBar
    property fileName : string read theFilename write SetFilename; //*PN*
    procedure Open(const aFileName: string; fileFormat: integer; ConvertLF: boolean);
    {Insert part1 and part2 at the beginning and the end of the selected text}
    procedure Template (const part1: string; const part2: string);
    procedure GoToLine (line: integer);
    procedure GoToColumn (column: integer);
    function GetLineNumber: integer;
    function GetColumnNumber: integer;
    procedure MarkLine;
    procedure SaveWithLineSpecials (const filename: string);
    procedure UpdateSyntaxColoring;
    procedure UpdateSelection; { updates syntax coloring of selection }
    procedure UpdateSyntaxColoringRange( start: integer; length: integer );
    //procedure UpdateSyntaxColoringBuffer( pBuffer: PWChar; start:  integer; length: integer );

//    procedure SetFormat (format: TCharFormat); { set whole Text to this format }
    function  GetFormat: Pointer; { get active syntax format ^TCharFormat}
    procedure WinPanelClick(Sender: TObject);  //*PN*
    procedure ShowLine; // Shows line and colum position
    procedure SizeWinPanel;
    procedure SetToStandard;
    procedure Save;
    Procedure SaveAs;

    //*DS* start spell checking from caret position or end of current selection
    // Sender should be a spell check dialog
    procedure SpellCheck(Sender: TObject);
  end;

var
  EditForm: TEditForm;

implementation

uses Frame, TemplateDlg, DocumentDlg, SymbolDlg, MathDlg,
     SpellCheckDlg;

{$R *.DFM}

//*PN* used for UpdateSyntaxColoringRange and TeXtoRTF
const KeyChars = ['a'..'z', 'A'..'Z', '0'..'9', '@', #128..#255];
      Specials = ['\', '{', '}', '[', ']', '(', ')', '%', '$'];
      EscChars = ['%', '{', '}', '$', '&', '#', '_'];

//*PN*

procedure TEditForm.DoWinPanelPopup(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
var Origin: TPoint;
begin
  Origin := theWinPanel.ClientOrigin;
  if Button = mbRight then PMPanel.Popup(Origin.x + x, Origin.y + y);
end;

procedure TEditForm.WinPanelClick(Sender: TObject);
begin
  BringToFront;
end;

//*PN*
procedure TEditForm.SizeWinPanel;
var scaleBM : TBitmap; //just to calculate width...
    i,l : integer;
begin
  scaleBM := TBitmap.Create;
  scaleBM.Canvas.Font := theWinPanel.Font;
  theWinPanel.Width := scaleBM.Canvas.TextWidth(theWinPanel.Caption) + 10; // adjust panel width
  l := 2 - FrameForm.ScrollBox1.HorzScrollBar.Position; //area may be scrolled!
  for i := 0 to FrameForm.ScrollBox1.ControlCount - 1 do
  begin
    if FrameForm.ScrollBox1.Controls[i] is TSpeedButton then
    begin
      FrameForm.ScrollBox1.Controls[i].Left := l;
      INC(l, FrameForm.ScrollBox1.Controls[i].Width + 2);
    end;
  end;
  FrameForm.CheckWinBarScroll;
  scaleBM.Free;
end;

//*PN*
procedure TEditForm.SetFilename(newfilename: string);
begin
  theFileName := newFileName;
  theWinPanel.Hint := theFileName;
  theWinPanel.Caption := ExtractFileName(thefilename);
  SizeWinPanel; // adjust panel width
end;

procedure TEditForm.Template (const part1: string; const part2: string);
var position : integer;
    SelLen: integer;
begin
  while (RichEdit.SelLength > 0) and (RichEdit.SelText[RichEdit.SelLength] = #0) do
    RichEdit.SelLength := RichEdit.SelLength - 1;
  position := RichEdit.SelStart;
  SelLen := RichEdit.SelLength;
  RichEdit.SelText := part1 + RichEdit.SelText + part2;
  if FrameForm.syntaxColoring then
    UpdateSyntaxColoringRange (position, length(part1) + SelLen + length(part2));
  //now restore old selection
  RichEdit.SelStart := position + length(part1);
  RichEdit.SelLength := SelLen;
  ShowLine;
end;

procedure TEditForm.Open(const aFileName: string; fileFormat: integer; ConvertLF: boolean);
var srcStream:   TMemoryStream;
    destStream:  TMemoryStream;
    stringStream:   TStringStream;
    txxFileName: string;
begin
  Screen.Cursor := crHourglass;
  fileName := aFileName;

  if fileFormat = UTF8_FORMAT then isUnicode := true
  else isUnicode := false;

  // *DS* TeX sometimes returnes file names without extension
  if not FileExists(fileName) then
  begin
    fileName := ChangeFileExt(fileName, '.tex');
  end;

  shortFileName := ExtractFilename (fileName);
  RichEdit.PlainText := true;
  try //reduce flickering and speed up by doing linebreak conversion with streams (backstep)
    srcStream := TMemoryStream.Create;
    srcStream.LoadFromFile (fileName);
    srcStream.Seek (0, soFromBeginning);
    if ConvertLF then begin
      // first do Linefeed conversion
      stringStream := TStringStream.Create('');
      stringStream.CopyFrom (srcStream, 0);
      stringStream.Seek (0, soFromBeginning);
      StringStream.WriteString(AdjustLineBreaks(stringStream.DataString));
      srcStream.Seek (0, soFromBeginning);
      srcStream.CopyFrom(stringStream, 0); //because size can't be less, this is ok
      stringStream.Free;
      srcStream.Seek (0, soFromBeginning);
    end;

    if fileFormat = DOS_FORMAT then begin
      OemToCharBuff (srcstream.Memory, srcstream.Memory, srcstream.size);
      srcStream.Seek(0, soFromBeginning);
    end;

    RichEdit.MaxLength := srcStream.size + BUFFERINCREMENT;

    if frameForm.syntaxColoring then
    begin
        destStream := TMemoryStream.Create;
        //TeXToRTF( srcStream, destStream, FrameForm.defaultFileFormat );
        TeXToRTF( srcStream, destStream, fileFormat );
        srcStream.Free;
        destStream.Seek(0, soFromBeginning);
        RichEdit.PlainText := false;
        RichEdit.Lines.LoadFromStream(destStream);
        RichEdit.PlainText := true;
        destStream.Free;
    end
    else
    begin
      //if FrameForm.defaultFileFormat = UTF8_FORMAT then
      if fileFormat = UTF8_FORMAT then
      begin
        LoadUtf8FromStream( srcStream );
      end
      else
      begin
        RichEdit.Lines.LoadFromStream(srcStream);
      end;
      srcStream.Free;
    end;
  except
    MessageDlg('Could not open file!', mtWarning, [mbOK], 0);
  end;
  // Test if valid txx file exists
  if (ExtractFileExt(fileName)='.tex') then
  begin
    txxFileName := fileName;
    ChangeFileExt (txxFileName, '.txx');
    //*PN* this is save because of shortcut evalution:
    //     part behind AND is only evaluated if file exists
    txxIsValid := FileExists(txxFileName) and
                  ( FileDateToDateTime(FileAge(fileName))
                    <= FileDateToDateTime(FileAge(txxfileName)) );
  end
  else
    txxIsValid := true; //*PN* never save .txx for files other than .tex!!!

  RichEdit.SelStart := 0;
  Caption := shortFileName;
  ShowLine;
  RichEdit.Modified := false;
  Screen.Cursor := crDefault;
  theWinPanel.Font.Style := [];
  SizeWinPanel;
  if fileFormat = DOS_FORMAT then
  begin
    RichEditChange(self); //if OEM: file IS changed because of conversion!!!
    RichEdit.Modified := true;
  end;
end;

procedure TEditForm.Save;
var backupFile: string;
    specialFile: string;
    extension: string;
begin
  if fileName = '' then
    SaveAs
  else
  begin
    extension := ExtractFileExt (fileName);
    if FrameForm.createBackup then
    begin
      backupFile := fileName + '.bak';
      DeleteFile (backupFile);
      RenameFile (fileName, backupFile);
    end;

    //if SaveDialog.FilterIndex = UTF8_FORMAT then
    if isUnicode = true then
    begin
        SaveUtf8ToFile( fileName );
    end
    else
    begin
        RichEdit.Lines.SaveToFile( fileName );
    end;

    if FrameForm.handleLineSpecials and (extension = '.tex') then
    begin
      specialFile := ChangeFileExt( fileName, '.txx' );
      SaveWithLineSpecials( specialFile );
    end;
    RichEdit.Modified := false;
    theWinPanel.Font.Style := [];  //*PN*
    SizeWinPanel;
  end;
end;

// *DS*
// This is called by Windows
function EditStreamCallbackWrite( dwCookie: DWORD;
                                  pbBuff  : PBYTE;
                                  cb      : Integer;
                                  pcb     : PInteger): DWORD; stdcall;
var pOutStream: ^TStream;
begin
    pOutStream := Pointer(dwCookie);
    pOutStream^.Write( pbBuff^, cb );
    pcb^ := cb;
    Result := 0;
end;



// *DS*
// This is called by Windows as a reaction to SaveUtf8
function EditStreamCallbackWriteUtf8( dwCookie: DWORD;
                                      pbBuff  : PBYTE;
                                      cb      : Integer;
                                      pcb     : PInteger): DWORD; stdcall;
var transferred: integer;
    cChars : integer;
    bufferSize: integer;
    pUtf8Buffer : PBYTE;
    utf8Size: integer;
    pOutStream: ^TStream;
begin
    pOutStream := Pointer(dwCookie);
    cChars := Floor(cb/2);
    bufferSize := cChars * 3;
    GetMem( pUtf8Buffer, bufferSize );
    // convert bytes in buffer to utf8
    utf8Size := WideCharToMultiByte( CP_UTF8, 0, LPCWSTR(pbBuff), cChars, LPSTR(pUtf8Buffer), bufferSize, nil, nil );

    // write utf8 to file
    transferred := pOutStream^.Write( pUtf8Buffer^, utf8Size );

    FreeMem( pUtf8Buffer );

    pcb^ := cb;
    Result := 0;
end;

// *DS*
// Saves the contents of the editor in UTF8 format
procedure TEditForm.SaveUtf8ToFile( const aFileName: string );
var fileOutStream: TFileStream;
begin
  try
    fileOutStream := TFileStream.create( aFileName, fmCreate );
    SaveUtf8ToStream( fileOutStream );
  except
    MessageDlg('Could not write to File!', mtWarning, [mbOK], 0);
  end;
  fileOutStream.Free;
end;


// *DS*
// Saves the contents of the editor in UTF8 format
procedure TEditForm.SaveUtf8ToStream( outStream: TStream );
var  eStream: EDITSTREAM;
begin
    with eStream do
    begin
      dwCookie := longint(@outStream);
      dwError := 0;
      pfnCallback := @EditStreamCallbackWriteUtf8;
    end;
    SendMessage( RichEdit.Handle, EM_STREAMOUT, SF_UNICODE or SF_TEXT, longint(@eStream) );

    if eStream.dwError <> 0 then
    begin
      MessageDlg('Write Error in Method: SaveUtf8ToStream', mtWarning, [mbOK], 0);
    end;
end;



// *DS*
// This is called by Windows as a reaction to LoadUnicodeFromStream
function EditStreamCallbackRead( dwCookie: DWORD;
                                 pbBuff  : PBYTE;
                                 cb      : Integer;
                                 pcb     : PInteger): DWORD; stdcall;
var
  pBuffer: ^ReadBuffer;
  pSrcBuffer: PBYTE;
  unread: integer;
  size: integer;
begin
  pBuffer := Pointer(dwCookie);
  unread := pBuffer^.size - pBuffer^.cRead;

  if unread > cb then size := cb
  else size := unread;

  pSrcBuffer := pBuffer^.pMemory;
  Inc( pSrcBuffer, pBuffer^.cRead );
  CopyMemory( pbBuff, pSrcBuffer, size );
  pcB^ := size;

  pBuffer.cRead := pBuffer^.cRead + size;

  Result := 0;
end;


//*DS*
procedure TEditForm.LoadUtf8FromStream( source: TMemoryStream );
var  eStream: EDITSTREAM;
     buffer: ReadBuffer;
     nBytes: integer;
     nChars: integer;
begin
  nChars := MultiByteToWideChar( CP_UTF8, 0, LPCSTR(source.Memory), source.Size, nil, 0 );
  nBytes := nChars * 2;
  GetMem( buffer.pMemory, nBytes );
  with buffer do
  begin
    cRead := 0;
    size :=  nBytes;
  end;

  MultiByteToWideChar( CP_UTF8, 0, LPCSTR(source.Memory), source.Size, LPWSTR(buffer.pMemory), nBytes );

  with eStream do
  begin
    dwCookie := longint(@buffer);
    dwError := 0;
    pfnCallback := @EditStreamCallbackRead;
  end;

  SendMessage( RichEdit.Handle, EM_STREAMIN, SF_UNICODE or SF_TEXT, longint(@eStream) );
  FreeMem( buffer.pMemory );

  if eStream.dwError <> 0 then
  begin
    MessageDlg('Write Error in Method: LoadUtf8FromStream', mtWarning, [mbOK], 0);
  end;
end;


procedure TEditForm.SaveAs;
begin
  SaveDialog.FileName := fileName;
  if SaveDialog.Execute then
  begin
    FrameForm.AddToRecent(fileName); //*PN* bring entry to Top
    case SaveDialog.FilterIndex of
    TEX_FORMAT:
       begin
         //FrameForm.defaultFileFormat := TEX_FORMAT;
         isUnicode := false;
         fileName := ExpandFileName(SaveDialog.FileName);
         if ExtractFileExt(fileName) = '' then fileName := fileName + '.tex';
         shortFileName := ExtractFilename (fileName);
         Caption := shortFileName;
         Save;
       end;
    UTF8_FORMAT:
       begin
         //FrameForm.defaultFileFormat := UTF8_FORMAT;
         isUnicode := true;
         fileName := ExpandFileName(SaveDialog.FileName);
         if ExtractFileExt(fileName) = '' then fileName := fileName + '.tex';
         shortFileName := ExtractFilename (fileName);
         Caption := shortFileName;
         SaveUtf8ToFile( fileName );
       end;
    DOS_FORMAT:
       begin
         isUnicode := false;
         if ExtractFileExt(SaveDialog.FileName) = '' then
           SaveDialog.FileName := SaveDialog.FileName + '.tex';
         SaveOEM(SaveDialog.FileName);
         SaveDialog.FilterIndex := TEX_FORMAT;
       end;
    end;
    FrameForm.recentFiles[0] := fileName;   //*PN*    now set new values
    FrameForm.Recent1[0].Caption := '&0 '+fileName;  //*PN*
  end;
end;

procedure TEditForm.SaveOEM (const aFileName: string);
var stream: TMemoryStream;
begin
  try
    stream := TMemoryStream.Create;
    try
      RichEdit.Lines.SaveToStream (stream);
      stream.Seek (0, soFromBeginning);
      CharToOemBuff (stream.Memory, stream.Memory, stream.size);
      stream.SaveToFile (aFileName);
    except
    end;
    stream.Free;
  except
    MessageDlg('Unable to save file!', mtWarning, [mbOk], 0);
  end;
end;

procedure TEditForm.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  Action := caFree;
  //*PN*
  FrameForm.ScrollBox1.RemoveControl(theWinPanel);
  FrameForm.AddToRecent(fileName); //*KL*
  SizeWinPanel; // move all buttons to correct locations
//  theWinPanel.Destroy;
  if FrameForm.MDIChildCount = 1 then
  begin
    FrameForm.Save1.Enabled := false;
    FrameForm.Saveas1.Enabled := false;
    FrameForm.Templates1.Visible := false;
    FrameForm.Edit1.Visible := false;
    FrameForm.Window1.Visible := false;
  end;
  //*PN* end
end;

procedure TEditForm.FormCreate(Sender: TObject);
var i,l : integer;
begin
  theWinPanel := TSpeedButton.Create(EditForm);
  RichEdit.PlainText := true;
  RichEdit.WordWrap := FrameForm.wordWrap;
  RichEdit.Color := FrameForm.backgroundColor;
  RichEdit.Font := FrameForm.standardFont;
  syntaxColorIsValid := true;
  pStandardFormat      := @FrameForm.standardFormat;
  pTexCommandFormat    := @FrameForm.teXCommandFormat;
  pParenthesisFormat   := @FrameForm.parenthesisFormat;
  pSquareBracketFormat := @FrameForm.squareBracketFormat;
  pRoundBracketFormat  := @FrameForm.roundBracketFormat;
  pDollarFormat        := @FrameForm.dollarFormat;
  pCommentFormat       := @FrameForm.commentFormat;

  //*PN* create Panel in WindowBar
  theWinPanel.Width := 90;
  theWinPanel.Height := FrameForm.ToolBar1.Height - 5;
  theWinPanel.ShowHint := true;
  theWinPanel.Hint := '';
  theWinPanel.OnClick := WinPanelClick;
  theWinPanel.Font.Style := [];
  theWinPanel.GroupIndex := 1;
  theWinPanel.Top := 2;
  theWinPanel.OnMouseUp := DoWinPanelPopup;
//  theWinPanel.PopupMenu := PMPanel;
  l := 2;
  for i := 0 to FrameForm.ScrollBox1.ControlCount - 1 do
  begin
    if FrameForm.ScrollBox1.Controls[i] is TSpeedButton then
      INC(l, FrameForm.ScrollBox1.Controls[i].Width);
  end;
  theWinPanel.Left := l;
  FrameForm.ScrollBox1.InsertControl(theWinPanel);
  FrameForm.CheckWinBarScroll;

  FrameForm.Save1.Enabled := true;
  FrameForm.Saveas1.Enabled := true;
  FrameForm.Templates1.Visible := true;
  FrameForm.Edit1.Visible := true;
  FrameForm.Window1.Visible := true;
  //*PN* end

  if FrameForm.defaultFileFormat = UTF8_FORMAT then isUnicode := true
  else isUnicode := false;

  //*DS* Unicode: adjust file dialog to format.
  if (SaveDialog.FilterIndex = TEX_FORMAT)
  or (SaveDialog.FilterIndex = UTF8_FORMAT) then
  begin
    SaveDialog.FilterIndex := FrameForm.defaultFileFormat;
  end;
end;

procedure TEditForm.WordWrapClick(Sender: TObject);
begin
  RichEdit.WordWrap := FrameForm.wordWrap;
  if FrameForm.wordWrap then
     RichEdit.ScrollBars := ssVertical
  else
    RichEdit.ScrollBars := ssBoth;
end;

procedure TEditForm.BoldClick(Sender: TObject);
begin
  Template ('\textbf{', '}');
end;

procedure TEditForm.Open2Click(Sender: TObject);
var strSelection: string;
//    pCharSelection: array [0..MAXCOMMAND] of char;
//    success: UINT;
    extension: string;
    count: integer;
    i: integer;
    mainDirectory: string;
begin
  { switch to main files directory if selected }
  if FrameForm.mainFileSelected then
    mainDirectory := ExtractFileDir (FrameForm.strMainFile)
  else
    mainDirectory := ExtractFileDir (Application.ExeName);
  SetCurrentDir (mainDirectory);

  if RichEdit.SelLength > 0 then
  begin
    { use selextion as filename }
    strSelection := RichEdit.SelText;
    strSelection := Trim (strSelection);
  end
  else
  begin
    { parse text at caret for filename }
    count := 0;

    { search left }
    for i := RichEdit.SelStart downto 1 do
    begin
      Inc (count);
      if count > MAXPATH then break;
      case RichEdit.Text[i] of
      ' ', '{', '}', TAB,      
      '(', ')',  '[', ']',
      '<', '>',  '?', '*',
      ',', ';',	 CR, NL: begin
                           RichEdit.SelStart := i;
                           break;
                         end;
      end;
    end;

    { search right } //*PN* start search at old pos: offset count from SelStart
    for i := RichEdit.SelStart + count to Length (RichEdit.Text) do
    begin
      Inc (count);
      if count > MAXPATH then break;
      case RichEdit.Text[i] of
      ' ', '{', '}', TAB, 
      '(', ')',  '[', ']',
      '<', '>',  '?', '*',
      ',', ';',	 CR, NL: begin
                           RichEdit.SelLength := i - 1 - RichEdit.SelStart;
                           break;
                         end;
      end;
    end;
    strSelection := RichEdit.SelText;
  end;

  { handle unix like file paths }
  for i := 1 to Length (strSelection) do
  begin
    if strSelection[i] = '/' then strSelection[i] := '\';
  end;

  extension := ExtractFileExt(strSelection);
  if  extension = '' then
  begin
    strSelection := strSelection + '.tex';
    extension := '.tex';
  end;

  { map files with .txx ending to .tex ending }
  if FrameForm.handleLineSpecials and (extension = '.txx') then
  begin
    strSelection := ChangeFileExt (strSelection, '.tex');
    extension := '.tex';
  end;

  strSelection := ExpandFileName (strSelection);
  if FileExists (strSelection) then
  begin
    if extension = '.tex' then
      FrameForm.Open (strSelection, 1, -1)
    else
      FrameForm.ExecProg(strSelection, mainDirectory);
  end
  else
    MessageDlg('Unable to find file: ' + strSelection, mtError, [mbOk], 0);
end;


procedure TEditForm.Execute1Click(Sender: TObject);
var strSelection: string;
    count: integer;
    i: integer;
begin
  if RichEdit.SelLength > 0 then
  begin
    { use selection as filename }
    strSelection := RichEdit.SelText;
  end
  else
  begin
    { parse text at caret for a command }
    count := 0;

    { search left }
    for i := RichEdit.SelStart downto 1 do
    begin
      Inc (count);
      if count > MAXPATH then break;
      case RichEdit.Text[i] of
      '%', ';', CR, NL: begin
                          RichEdit.SelStart := i;
                          break;
                        end;
      end;
    end;

    { search right }
    for i := RichEdit.SelStart + 1 to Length (RichEdit.Text) do
    begin
      Inc (count);
      if count > MAXPATH then break;
      case RichEdit.Text[i] of
      '%', ';', CR, NL: begin
                          RichEdit.SelLength := i -1 - RichEdit.SelStart;
                          break;
                        end;
      end;
    end;
    strSelection := RichEdit.SelText;
  end;

  strSelection := Trim (strSelection);
  if Length (strSelection) <= MAXCOMMAND then
  begin
    //*PN*
    FrameForm.ExecProg(strSelection, '');
  end
  else
    MessageDlg('String to long', mtWarning, [mbOk], 0);
end;

procedure TEditForm.FindDialog1Find(Sender: TObject);
var findText: TFindText;
    pCharToFind: array [0..255] of char;
    flags: uint;
    matchCase: uint;
    wholeWord: uint;
    range: CHARRANGE;
begin
  ToFind := FrameForm.FindDialog1.FindText; // needed to repeat search without dialog
  FoundLen := Length (ToFind);

  matchCase := 0;
  wholeWord := 0;
  flags := uint(frDown);
  if FrameForm.FindDialog1.Options * [frMatchCase] = [frMatchCase] then matchCase := uint(frMatchCase);
  if FrameForm.FindDialog1.Options * [frWholeWord] = [frWholeWord] then wholeWord := uint(frWholeWord);
  flags := flags or matchCase or wholeWord;

  StrPCopy (pCharToFind, FrameForm.FindDialog1.FindText);
  findText.chrg.cpMin := RichEdit.SelStart + RichEdit.SelLength;
  findText.chrg.cpMax := -1;
  findText.lpstrText := pCharToFind;

  Found := SendMessage (RichEdit.Handle, EM_FINDTEXT, wParam(flags), lParam(@findText));

  if Found <> -1 then
  begin
    SendMessage (RichEdit.Handle, WM_SETFOCUS, 0, 0);

    range.cpMin := Found;
    range.cpMax := Found + FoundLen;
    SendMessage( RichEdit.Handle, EM_HIDESELECTION, 0, 0 );
    SendMessage (RichEdit.Handle, EM_EXSETSEL, 0, lParam(@range));

    //RichEdit.SelStart:= Found;
    //RichEdit.SelLength := FoundLen;
   end
  else
  begin
    MessageDlg('Text not found', mtInformation, [mbOK], 0);
  end;
end;


procedure TEditForm.ReplaceDialog1Find(Sender: TObject);
var findText: TFindText;
    pCharToFind: array [0..255] of char;
    flags: uint;
    matchCase: uint;
    wholeWord: uint;
begin
  endOfDocReached := false;
  ToFind := FrameForm.ReplaceDialog1.FindText;
  FoundLen := Length (ToFind);

  matchCase := 0;
  wholeWord := 0;
  flags := uint(frDown);
  if FrameForm.ReplaceDialog1.Options * [frMatchCase] = [frMatchCase] then matchCase := uint(frMatchCase);
  if FrameForm.ReplaceDialog1.Options * [frWholeWord] = [frWholeWord] then wholeWord := uint(frWholeWord);
  flags := flags or matchCase or wholeWord;

  StrPCopy (pCharToFind, FrameForm.ReplaceDialog1.FindText);
  findText.chrg.cpMin := RichEdit.SelStart + RichEdit.SelLength;
  findText.chrg.cpMax := -1;
  findText.lpstrText := pCharToFind;

  Found := SendMessage (RichEdit.Handle, EM_FINDTEXT, wParam(flags), lParam(@findText));

  if Found <> -1 then
  begin
    SendMessage (RichEdit.Handle, WM_SETFOCUS, 0, 0);
    RichEdit.SelStart:= Found;
    RichEdit.SelLength := FoundLen;
   end
  else
  begin
    MessageDlg('End of document reached!', mtInformation, [mbOK], 0);
    endOfDocReached := true;
  end;
end;


procedure TEditForm.ReplaceDialog1Replace(Sender: TObject);
var mayReplace: integer;
begin
  endOfDocReached := false;

  { look if text to replace is allready selected }
  if FrameForm.ReplaceDialog1.Options * [frMatchCase] = [frMatchCase] then
  begin
    mayReplace := CompareStr (RichEdit.SelText, FrameForm.ReplaceDialog1.FindText);
    if mayReplace = 0 then RichEdit.SelText := FrameForm.ReplaceDialog1.ReplaceText;
  end
  else
  begin
    mayReplace := CompareText (RichEdit.SelText, FrameForm.ReplaceDialog1.FindText);
    if mayReplace = 0 then RichEdit.SelText := FrameForm.ReplaceDialog1.ReplaceText;
  end;

  // changes endOfDocReached!
  ReplaceDialog1Find(Sender);

  if  (FrameForm.ReplaceDialog1.Options*[frReplaceAll] = [frReplaceAll])
  and (endOfDocReached = false) then
    ReplaceDialog1Replace (Sender);
end;


procedure TEditForm.Find2Click(Sender: TObject);
var position: integer;
    i     : integer;
    cLeft : integer;
    cRight: integer;
    success: boolean;
begin
  success := false;
  cLeft  := 0;
  cRight := 0;
  position := 0;
  RichEdit.SelLength := 1;
  if RichEdit.SelText = '{' then
  begin {search upwards}
    for i := RichEdit.SelStart + 1 to Length (RichEdit.Text) do
    begin //*PN* don't count \{ or \}
      if (RichEdit.Text[i] = '{') and (RichEdit.Text[i-1] <> '\') then Inc (cLeft);
      if (RichEdit.Text[i] = '}') and (RichEdit.Text[i-1] <> '\') then Inc (cRight);
      if cLeft = cRight then
      begin
        success := true;
        position := i - 1;
        Break;
      end
    end
  end;

  if RichEdit.SelText = '}' then
  begin {search downwards}
    for i := RichEdit.SelStart + 1 downto 1 do
    begin  //*PN* don't count \{ or \}
      if (RichEdit.Text[i] = '{') and
         (((i>1) and (RichEdit.Text[i-1] <> '\')) or (i=1)) then Inc (cLeft);
      if (RichEdit.Text[i] = '}') and
         (((i>1) and (RichEdit.Text[i-1] <> '\')) or (i=1)) then Inc (cRight);
      if cLeft = cRight then
      begin
        success := true;
        position := i - 1;
        Break;
      end
    end
  end;

  if success then
  begin
    RichEdit.SelStart := position;
    RichEdit.SelLength := 1;
  end
  else
  begin
    RichEdit.SelLength := 0;
    MessageDlg('Did not found parenthesis', mtInformation, [mbOK], 0);
  end

end;

procedure TEditForm.RichEditKeyUp(Sender: TObject; var Key: Word;
  Shift: TShiftState);
var line, colum, ppos, i, oldSelStart : integer;
    zeile : string;
begin
  ShowLine;
  if FrameForm.syntaxColoring then
  begin
    if   (Key = VK_UP)
      or (Key = VK_DOWN)
      or (Key = VK_LEFT)
      or (Key = VK_RIGHT)
      or (Key = VK_PRIOR)  //*PN* additional movement keys added
      or (Key = VK_NEXT)
      or (Key = VK_END)
      or (Key = VK_HOME)
    then
      syntaxColorIsValid := false;
  end;
// ************************************************
// Auto linebreak stuff: experimental

  //line := SendMessage (RichEdit.Handle, EM_LINEFROMCHAR, RichEdit.SelStart,0);
  line := SendMessage( RichEdit.Handle, EM_EXLINEFROMCHAR, 0, RichEdit.SelStart );
  colum := SendMessage (RichEdit.Handle, EM_LINEINDEX, line,0);
  zeile := RichEdit.Lines[line];
  if FrameForm.linelength = 0 then exit;
  if length(zeile) > FrameForm.linelength then
  begin
    for ppos := 1 to length(zeile) do
    begin
      if zeile[ppos] = '%' then
        if (ppos = 1) or (zeile[ppos-1] <> '\') then
          exit;  //comment found: no break
    end;
    i := FrameForm.linelength;
    while not (zeile[i] in [' ', TAB]) and (i > 0) do dec(i);
    if i > 0 then begin
      oldSelStart := RichEdit.SelStart;
      if (line < RichEdit.Lines.Count - 1) then
      begin
        ppos := length(RichEdit.Lines[line+1]);
        if (ppos > 0) and (ppos + (length(zeile) - i) < FrameForm.linelength) then
        begin
          RichEdit.SelStart := colum + length(zeile);
          RichEdit.SelLength := 2;
          RichEdit.SelText := '';
        end
      end;
      RichEdit.SelStart := colum + i;
      RichEdit.SelText := #13#10;
      if (oldSelStart - colum) >= i then
        RichEdit.SelStart := oldSelStart + 2 //add 2 because of the two char #13#10
      else
        RichEdit.SelStart := oldSelStart;
    end;
  end;
end;

procedure TEditForm.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
var dlgReturn: integer;
    fileName: string;
begin
  if RichEdit.Modified then
  begin
    fileName := Caption;
    dlgReturn := MessageDlg (Format (strSave, [fileName]),
                             mtConfirmation,
                             [mbYes, mbNo, mbCancel],0);
    case dlgReturn of
      idYes:    Save;
      idCancel: CanClose := false;
    end;
  end
end;

procedure TEditForm.GoToLine1Click(Sender: TObject);
var line: integer;
    strLine: string;
begin
  strLine := InputBox ('Go To Line', 'Line', '');
  if strLine <> '' then
  begin
    line := StrToInt (strLine);
    GoToLine (line);
  end
end;

procedure TEditForm.GoToLine (line: integer);
var position: integer;
    range: CHARRANGE;
begin
  position := SendMessage (RichEdit.Handle, EM_LINEINDEX, line-1,0);
  if line < 1 then exit;


  range.cpMin := position;
  range.cpMax := position;
  SendMessage( RichEdit.Handle, EM_HIDESELECTION, 0, 0 );
  SendMessage (RichEdit.Handle, EM_EXSETSEL, 0, lParam(@range));

//  RichEdit.SelLength := 0;
//  RichEdit.SelStart := position;
  MarkLine;
  ShowLine;
end;

procedure TEditForm.GoToColumn (column: integer);
var lineBegin: integer;
    line: integer;
begin
  //line := SendMessage (RichEdit.Handle, EM_LINEFROMCHAR, RichEdit.SelStart,0);
  line := SendMessage( RichEdit.Handle, EM_EXLINEFROMCHAR, 0, RichEdit.SelStart );
  lineBegin := SendMessage (RichEdit.Handle, EM_LINEINDEX, line, 0);
  if line < 0 then exit;
  RichEdit.SelLength := 0;
  RichEdit.SelStart := lineBegin + column;
  ShowLine;
end;



function TEditForm.GetLineNumber: integer;
begin
  //Result := SendMessage (RichEdit.Handle, EM_LINEFROMCHAR, RichEdit.SelStart,0) + 1;
  //Result := RichEdit.CaretPos.y + 1;
  Result := SendMessage( RichEdit.Handle, EM_EXLINEFROMCHAR, 0, RichEdit.SelStart ) + 1;
end;


function TEditForm.GetColumnNumber: integer;
var line: integer;
    lineBegin: integer;
begin
  {Display information about line and position}
  //line  := SendMessage (RichEdit.Handle, EM_LINEFROMCHAR, RichEdit.SelStart,0);
  //lineBegin := SendMessage (RichEdit.Handle, EM_LINEINDEX, line,0);
  //Result := RichEdit.SelStart - lineBegin;

  // *DS* Possibly unsafe
  //Result := RichEdit.CaretPos.x + 1;

  line  := SendMessage( RichEdit.Handle, EM_EXLINEFROMCHAR, 0, RichEdit.SelStart );
  lineBegin := SendMessage( RichEdit.Handle, EM_LINEINDEX, line, 0 );
  Result := RichEdit.SelStart - lineBegin + 1;
end;


procedure TEditForm.ShowLine;
var line: integer;
    colum: integer;
begin
  {Display information about line and position}
  line := GetLineNumber;
  colum := GetColumnNumber;
  FrameForm.StatusBar1.Panels[0].Text := IntToStr(line) + ':' + IntToStr(colum);
end;


procedure TEditForm.RichEditMouseUp(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
  ShowLine;
end;

procedure TEditForm.FormActivate(Sender: TObject);
begin
  ShowLine;
  //*PN*
  theWinPanel.Down := true;
  UpdateMenus(Sender);
end;

procedure TEditForm.FormMouseUp(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
  ShowLine;
end;

procedure TEditForm.FormKeyUp(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  ShowLine;
end;

procedure TEditForm.RichEditMouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  ShowLine;
  pFormat := GetFormat;
end;

procedure TEditForm.UpdateMenus(Sender: TObject);
var hasSelection: boolean;
begin
  hasSelection := RichEdit.SelLength <> 0;
  Cut1.Enabled := hasSelection;
  Copy2.Enabled := hasSelection;
  Paste2.Enabled := Clipboard.HasFormat (CF_TEXT);
  UpdateSelection1.Enabled := FrameForm.syntaxColoring and hasSelection;
end;

procedure TEditForm.Emphasis1Click(Sender: TObject);
begin
  Template ('\emph{', '}');
end;

procedure TEditForm.MarkLine;
var //position: integer;
    line: integer;
begin
  { find beginning of line }
  //line := SendMessage(RichEdit.Handle,EM_LINEFROMCHAR,RichEdit.SelStart,0);
  line := SendMessage( RichEdit.Handle, EM_EXLINEFROMCHAR, 0, RichEdit.SelStart );
  SendMessage (RichEdit.Handle, EM_LINEINDEX, line,0);
  { mark line }
  RichEdit.SelLength := SendMessage(RichEdit.Handle,EM_LINELENGTH,RichEdit.SelStart,0);
end;

procedure TEditForm.SaveWithLineSpecials (const filename: string);
var i: integer;
    special: string;
    f: TextFile;
    insertSpecial: boolean;
begin
  try
    insertSpecial := false;
    AssignFile (f, filename);
    Rewrite (f);
    for i := 0 to RichEdit.Lines.Count-1 do
    begin
      if Length(RichEdit.Lines[i]) = 0 then
      begin
        insertSpecial := true;
      end;
      if (Length(RichEdit.Lines[i]) > 0) and insertSpecial then
      begin
        special := '\special{src: ' + IntToStr(i+1) + ' ' + shortFileName + '}';
        WriteLn (f, special + RichEdit.Lines[i]);
        insertSpecial := false;
      end
      else
      WriteLn (f, RichEdit.Lines[i]);
    end;
    //WriteLn (f);
  finally
    CloseFile (f);
  end;
end;

procedure TEditForm.RichEditKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  if FrameForm.syntaxColoring then
  begin
    if (Key = VK_SPACE) and (pFormat <> Pointer(pCommentFormat)) then
    begin
      SendMessage (RichEdit.Handle, EM_SETCHARFORMAT, SCF_SELECTION, longint(pStandardFormat));
      pFormat := Pointer(pStandardFormat);
    end;
    if (Key = VK_RETURN) then
    begin
      SendMessage (RichEdit.Handle, EM_SETCHARFORMAT, SCF_SELECTION, longint(pStandardFormat));
      pFormat := Pointer(pStandardFormat);
    end;
  end;
end;

procedure TEditForm.RichEditKeyPress(Sender: TObject; var Key: Char);

  function CheckForEscChars : boolean;
  begin
    result := false;
    if pFormat <> Pointer(pTeXCommandFormat) then exit; //nothing special to examine
    // we are in Command: maybe it's no command but one of \{ etc.
    if RichEdit.Text[RichEdit.SelStart] = '\' then
    begin
      RichEdit.SelStart := RichEdit.SelStart - 1;
      RichEdit.SelLength := 1;
      SetFont(FrameForm.standardFont);
      RichEdit.SelLength := 0;
      RichEdit.SelStart := RichEdit.SelStart + 1;
      SendMessage (RichEdit.Handle, EM_SETCHARFORMAT, SCF_SELECTION, longint(pStandardFormat));
      result := true;
    end;
  end;

begin
  if FrameForm.syntaxColoring then
  begin
    // normaly syntax color is valid but if the user presses the
    // arrow keys it gets invalid, so format has to be determined
    if syntaxColorIsValid = false then
    begin
      pFormat := GetFormat;
      syntaxColorIsValid := true;
    end;

    { dirty trick: if previous mode is parenthesis format is switched back to normal }
    if   (pFormat = Pointer(pParenthesisFormat))
      or (pFormat = Pointer(pStandardFormat)) then
      SendMessage (RichEdit.Handle, EM_SETCHARFORMAT, SCF_SELECTION, longint(pStandardFormat));

    if pFormat <> Pointer(pCommentFormat) then
    begin

      { handle everything else }
      case Key of
        '_', '&', '#'
        {*PR*: special characters are more:}
        , '^', '"', #39, '`': CheckForEscChars;
        '\': begin
               SendMessage (RichEdit.Handle, EM_SETCHARFORMAT, SCF_SELECTION, longint(pTexCommandFormat));;
               pFormat := Pointer(pTeXCommandFormat);
             end;
        '{', '}': begin
               if not CheckForEscChars then
               begin
                 SendMessage (RichEdit.Handle, EM_SETCHARFORMAT, SCF_SELECTION, longint(pParenthesisFormat));;
                 pFormat := Pointer(pParenthesisFormat);
               end;
             end;
        '[', ']': begin
               SendMessage (RichEdit.Handle, EM_SETCHARFORMAT, SCF_SELECTION, longint(pSquareBracketFormat));;
               pFormat := Pointer(pParenthesisFormat);
             end;
        '$': begin
               if not CheckForEscChars then
               begin
                 SendMessage (RichEdit.Handle, EM_SETCHARFORMAT, SCF_SELECTION, longint(pDollarFormat));;
                 pFormat := Pointer(pParenthesisFormat);
               end;
             end;
        '(', ')': begin
               SendMessage (RichEdit.Handle, EM_SETCHARFORMAT, SCF_SELECTION, longint(pRoundBracketFormat));;
               pFormat := Pointer(pParenthesisFormat);
             end;
        '%': begin
               if not CheckForEscChars then
               //if (pFormat <> Pointer (pTeXCommandFormat)) then // otherwise % starts comment
                                                                  // even in command...
               begin
                 SendMessage (RichEdit.Handle, EM_SETCHARFORMAT, SCF_SELECTION, longint(pCommentFormat));;
                 pFormat := Pointer(pCommentFormat);
               end;
             end;
      end; {case}

      { handle special symbols }
      if pFormat = Pointer(pTeXCommandFormat) then
      begin
        { dirty trick: if previous mode is parenthesis format is switched back to normal }
        case Key of
        '-', '=', '>', ',', '~', '', '`', #39: pFormat := Pointer(pParenthesisFormat);
        end;
      end;

    end; {if}
  end;
end;

//*DS* added format for Unicode support
// format may be TEX_FORMAT or UTF8_FORMAT
// UTF8_FORMAT will write UTF8 RTF to output and input must contain UTF8 encoding
procedure TEditForm.TexToRtf (input: TMemoryStream; output: TMemoryStream; format: integer);
var //counter: integer;
    buffer: array [0..1024] of char;
    standardStyle:      array [0..50] of char;
    texCommandStyle:    array [0..50] of char;
    parenthesisStyle:   array [0..50] of char;
    squareBracketStyle: array [0..50] of char;
    roundBracketStyle:  array [0..50] of char;
    mathStyle:          array [0..50] of char;
    commentStyle:       array [0..50] of char;
    paragraphMark:      array [0..5] of char;
    standard:      integer;
    texCommand:    integer;
    parenthesis:   integer;
    squareBracket: integer;
    roundBracket:  integer;
    math:          integer;
    comment:       integer;
    paragraph:     integer;
    position, helppos: ^char;
//    oldPosition: ^char;
//    pFormat: ^TCharFormat; // remember format mode
//    termination: integer;
    //strFontSize: string;
    //strFontStyle: string;
    strFont: string;
    strColor: string;
    pTermination: ^char;

  function BuildFormatStr(StyleStr: PChar; theFont: TFont; Idx: integer; LastChar: char):integer;
  var sbuffer: string;
  begin
    sbuffer :=  '\plain\f' + IntToStr(Idx)  // font number
              + '\cf' + IntToStr(Idx)       // color foreground
              + '\fs' + IntToStr(theFont.size * 2); // font size
    if fsBold in theFont.Style then
      sbuffer := sbuffer + '\b';
    if fsItalic in theFont.Style then
      sbuffer := sbuffer + '\i';//talic';    //*PN*
    if fsStrikeout in theFont.Style then
      sbuffer := sbuffer + '\strike';
    if fsUnderline in theFont.Style then
      sbuffer := sbuffer + '\ul';
    sbuffer := sbuffer + LastChar;
    StrPCopy(StyleStr, sbuffer);
    result := StrLen (StyleStr);
  end;

begin
  if input.Size = 0 then Exit;

  { initialize styles: fontnumber, fontcolor, fontsize, fontstyle }
  standard := BuildFormatStr(standardStyle, FrameForm.standardFont, 0, ' ');
  texCommand := BuildFormatStr(texCommandStyle, FrameForm.texCommandFont, 1, '\');
  parenthesis := BuildFormatStr(parenthesisStyle, FrameForm.parenthesisFont, 2, '\');
  squareBracket := BuildFormatStr(squareBracketStyle, FrameForm.squareBracketFont, 3, ' ');
  roundBracket := BuildFormatStr(roundBracketStyle, FrameForm.roundBracketFont, 4, ' ');
  math := BuildFormatStr(mathStyle, FrameForm.dollarFont, 5, ' ');
  comment := BuildFormatStr(commentStyle, FrameForm.commentFont, 6, ' ');

  StrCopy (paragraphMark, '\par ');
  paragraph := StrLen (paragraphMark);

  { write RTF header }

  if format = UTF8_FORMAT then
    output.Write('{\urtf8\ansi\deff0\deftab720'#13#10, 29)
  else
    output.Write('{\rtf1\ansi\deff0\deftab720'#13#10, 29);

  {
     font table
    *DS* I use the standard charset here for all fonts. This
    is a bit inconsistent with the rest, but it makes no sense
    to use an extra charset if you are only using TeX
  }
  strFont := '{\fonttbl' +
              '{\f0\fnil'
                   + '\fcharset' + IntToStr (FrameForm.standardFont.Charset)
                   + ' ' + FrameForm.standardFont.Name + ';}' +
              '{\f1\fnil'
                   + '\fcharset' + IntToStr (FrameForm.standardFont.Charset)
                   + ' ' + FrameForm.texCommandFont.Name + ';}' +
              '{\f2\fnil'
                   + '\fcharset' + IntToStr (FrameForm.standardFont.Charset)
                   + ' ' + FrameForm.parenthesisFont.Name + ';}' +
              '{\f3\fnil'
                   + '\fcharset' + IntToStr (FrameForm.standardFont.Charset)
                   + ' ' + FrameForm.squareBracketFont.Name + ';}' +
              '{\f4\fnil'
                   + '\fcharset' + IntToStr (FrameForm.standardFont.Charset)
                   + ' ' + FrameForm.roundBracketFont.Name + ';}' +
              '{\f5\fnil'
                   + '\fcharset' + IntToStr (FrameForm.standardFont.Charset)
                   + ' ' + FrameForm.dollarFont.Name + ';}' +
              '{\f6\fnil'
                   + '\fcharset' + IntToStr (FrameForm.standardFont.Charset)
                   + ' ' + FrameForm.commentFont.Name + ';}}';
  StrPCopy(buffer, strFont);
  output.Write(buffer, Length(strFont));

  { color table }
  StrLCopy (buffer, '{\colortbl', 10);
  output.write (buffer, 10);

  color := FrameForm.standardFont.Color;
  strColor :=  '\red'   + IntToStr(GetRValue(color))
             + '\green' + IntToStr(GetGValue(color))
             + '\blue'  + IntToStr(GetBValue(color)) + ';';
  StrPCopy (buffer, strColor);
  output.write (buffer, length(strColor));

  color := FrameForm.texCommandFont.Color;
  strColor :=  '\red'   + IntToStr(GetRValue(color))
             + '\green' + IntToStr(GetGValue(color))
             + '\blue'  + IntToStr(GetBValue(color)) + ';';
  StrPCopy (buffer, strColor);
  output.write (buffer, length(strColor));

  color := FrameForm.parenthesisFont.Color;
  strColor :=  '\red'   + IntToStr(GetRValue(color))
             + '\green' + IntToStr(GetGValue(color))
             + '\blue'  + IntToStr(GetBValue(color)) + ';';
  StrPCopy (buffer, strColor);
  output.write (buffer, length(strColor));

  color := FrameForm.squareBracketFont.Color;
  strColor :=  '\red'   + IntToStr(GetRValue(color))
             + '\green' + IntToStr(GetGValue(color))
             + '\blue'  + IntToStr(GetBValue(color)) + ';';
  StrPCopy (buffer, strColor);
  output.write (buffer, length(strColor));

  color := FrameForm.roundBracketFont.Color;
  strColor :=  '\red'   + IntToStr(GetRValue(color))
             + '\green' + IntToStr(GetGValue(color))
             + '\blue'  + IntToStr(GetBValue(color)) + ';';
  StrPCopy (buffer, strColor);
  output.write (buffer, length(strColor));

  color := FrameForm.dollarFont.Color;
  strColor :=  '\red'   + IntToStr(GetRValue(color))
             + '\green' + IntToStr(GetGValue(color))
             + '\blue'  + IntToStr(GetBValue(color)) + ';';
  StrPCopy (buffer, strColor);
  output.write (buffer, length(strColor));

  color := FrameForm.commentFont.Color;
  strColor :=  '\red'   + IntToStr(GetRValue(color))
             + '\green' + IntToStr(GetGValue(color))
             + '\blue'  + IntToStr(GetBValue(color)) + ';';
  StrPCopy (buffer, strColor);
  output.write (buffer, length(strColor));

  output.write ('}'#13#10, 3);

  { parse input stream and convert to RTF}
  position := input.Memory;
//  oldPosition := Pointer(position);
  output.write (standardStyle, standard);
  pFormat := Pointer (pStandardFormat);
//  termination := integer(input.Memory) + input.Size - 1;
  pTermination := Pointer(integer(position) + input.Size - 1);
  while (pTermination^ = #0) and (integer(pTermination) > integer(position)) do
  begin
//    Dec (termination);
    Dec (pTermination);
  end;

  while integer(pTermination) >= integer(position) do
  begin
    case position^ of
      #13: begin
             output.Write(paragraphMark, paragraph);
             output.Write(standardStyle, standard);
             INC(position, 2); //skip #13#10
           end;
      '%': begin
             output.Write(commentStyle, comment);
             while (position^ <> #13) and (integer(pTermination) >= integer(position)) do
             begin
               if position^ in ['\','{', '}'] then output.Write('\'#0, 1);
               output.Write(position^, 1);
               INC(position);
             end;
           end;
      '{', '}': begin
             output.Write(parenthesisStyle, parenthesis); //contains necessairy \
             output.Write(position^, 1);
             output.Write(standardStyle, standard);
             INC(position);
           end;
      '[', ']': begin
             output.Write(squareBracketStyle, squareBracket);
             output.Write(position^, 1);
             output.Write(standardStyle, standard);
             INC(position);
           end;
      '(', ')': begin
             output.Write(roundBracketStyle, roundBracket);
             output.Write(position^, 1);
             output.Write(standardStyle, standard);
             INC(position);
           end;
      '$': begin
             output.Write(mathStyle, math);
             output.Write(position^, 1);
             output.Write(standardStyle, standard);
             INC(position);
           end;
      '\': begin
             helppos := position;
             INC(helppos);
             if helppos^ in EscChars then
             begin // no format change: we are always in standardFormat
               output.Write('\\', 2); //write the \
               if Helppos^ in ['{', '}'] then output.Write('\'#0, 1);
               output.Write(helppos^, 1);
               INC(position, 2);
             end
             else
             begin
               output.Write(TeXCommandStyle, TeXCommand);
               output.Write(position^, 1);    // first write \
               INC(position);
               while (position^ in KeyChars) and (integer(pTermination) >= integer(position)) do
               begin
                 output.Write(position^, 1);
                 INC(position);
               end;
               output.Write(StandardStyle, standard);
             end;
           end;
      else begin
             output.Write(position^,1);
             INC(position);
           end;
    end;
  end; //while aktPos <= maxPos do

  { write RTF end }
  output.write ('}'#13#10#0, 4);
  output.position := 0;
end;

procedure TEditForm.UpdateSyntaxColoring;
var oldSelLength: integer;
    oldSelStart: integer;
    inStream,
    outStream: TMemoryStream;
begin
  oldSelLength := RichEdit.SelLength;
  oldSelStart := RichEdit.SelStart;
  try
    inStream := TMemoryStream.Create;
    try
      outStream:= TMemoryStream.Create;
      try
        //*DS* always use Unicode
        SaveUtf8ToStream( inStream );
        inStream.Seek(0, soFromBeginning);
        RichEdit.PlainText := false;
        TexToRtf( inStream, outStream , UTF8_FORMAT );
        RichEdit.Lines.LoadFromStream (outStream);
        (*
        RichEdit.Lines.SaveToStream (inStream);
        RichEdit.PlainText := false;
        TexToRtf (inStream, outStream);
        RichEdit.Lines.LoadFromStream (outStream);
        *)
      except
        MessageDlg('Error on updating syntax highlighting.',mtError,[mbOK],0);
      end;
      outStream.Free;
    except
      MessageDlg('Error on updating syntax highlighting.',mtError,[mbOK],0);
    end;
    inStream.Free;
  finally
    RichEdit.SelStart := oldSelStart;
    RichEdit.SelLength := oldSelLength;
    RichEdit.PlainText := true;
  end;
end;



procedure TEditForm.UpdateSyntaxColoringRange (start, length: integer);
var position: integer;
    textLength: integer;
    oldSelLength: integer;
    oldSelStart: integer;
    pFormat: ^TCharFormat;
    oldPosition: integer;
    range: CharRange;
begin
  oldSelLength := RichEdit.SelLength;
  oldSelStart := RichEdit.SelStart;
  RichEdit.SelStart := start;

  try
    RichEdit.Lines.BeginUpdate;

    textLength := start + length;

    { change to pascal notation }
    position := start + 1;
    oldPosition := start;

    { determine char format at beginning of selection }
    pFormat := GetFormat;

    if pFormat = Pointer(pCommentFormat) then
    begin
       while true do
       begin
         if (RichEdit.Text[position] = #13) or (position = textLength) then break;
         Inc(position);
       end;
       range.cpMin := oldPosition;
       range.cpMax := position;
       SendMessage( RichEdit.Handle, EM_EXSETSEL, 0, longint(@range) );
       SendMessage (RichEdit.Handle, EM_SETCHARFORMAT, SCF_SELECTION, longint(pCommentFormat));
       oldPosition := position;
       pFormat := Pointer (pStandardFormat);
    end;


    { update selection }
    while position <= textLength do
    begin
      case RichEdit.Text[position] of
        '%': begin
               if (pFormat = Pointer (pTeXCommandFormat))
               or (pFormat = Pointer (pStandardFormat)) then
               begin
                 range.cpMin := oldPosition;
                 range.cpMax := position;
                 SendMessage( RichEdit.Handle, EM_EXSETSEL, 0, longint(@range) );
                 SendMessage (RichEdit.Handle, EM_SETCHARFORMAT, SCF_SELECTION, longint(pFormat));
               end;

               if (pFormat <> Pointer (pTeXCommandFormat)) then
               begin
                 oldPosition := position-1;
                 while true do
                 begin
                   if (RichEdit.Text[position] = #13) or (position = textLength) then break;
                   Inc(position);
                 end;
                 range.cpMin := oldPosition;
                 range.cpMax := position;
                 SendMessage( RichEdit.Handle, EM_EXSETSEL, 0, longint(@range) );
                 SendMessage (RichEdit.Handle, EM_SETCHARFORMAT, SCF_SELECTION, longint(pCommentFormat));
               end;

               oldPosition := position;
               pFormat := Pointer (pStandardFormat);
             end;
        ' ': begin
               if pFormat = Pointer (pTeXCommandFormat) then
               begin
                 range.cpMin := oldPosition;
                 range.cpMax := position;
                 SendMessage( RichEdit.Handle, EM_EXSETSEL, 0, longint(@range) );
                 SendMessage (RichEdit.Handle, EM_SETCHARFORMAT, SCF_SELECTION, longint(pFormat));
                 pFormat := Pointer (pStandardFormat);
                 oldPosition := position - 1;
               end;
             end;
        #13: begin // Cursor Return
               if pFormat = Pointer (pTeXCommandFormat) then
               begin
                 range.cpMin := oldPosition;
                 range.cpMax := position;
                 SendMessage( RichEdit.Handle, EM_EXSETSEL, 0, longint(@range) );
                 SendMessage (RichEdit.Handle, EM_SETCHARFORMAT, SCF_SELECTION, longint(pTexCommandFormat));
                 pFormat := Pointer (pStandardFormat);
                 oldPosition := position - 1;
               end;
             end;
        '\': begin
               if (pFormat = Pointer (pTeXCommandFormat))
               or (pFormat = Pointer (pStandardFormat)) then
               begin
                 range.cpMin := oldPosition;
                 range.cpMax := position;
                 SendMessage( RichEdit.Handle, EM_EXSETSEL, 0, longint(@range) );
                 SendMessage (RichEdit.Handle, EM_SETCHARFORMAT, SCF_SELECTION, longint(pFormat));
               end;
               oldPosition := position - 1;
               pFormat := Pointer (pTexCommandFormat);
             end;
        '{', '}': begin
               if (pFormat = Pointer (pTeXCommandFormat))
               or (pFormat = Pointer (pStandardFormat)) then
               begin
                 range.cpMin := oldPosition;
                 range.cpMax := position;
                 SendMessage( RichEdit.Handle, EM_EXSETSEL, 0, longint(@range) );
                 SendMessage (RichEdit.Handle, EM_SETCHARFORMAT, SCF_SELECTION, longint(pFormat));
               end;
               range.cpMin := position - 1;
               range.cpMax := position;
               SendMessage( RichEdit.Handle, EM_EXSETSEL, 0, longint(@range) );
               SendMessage (RichEdit.Handle, EM_SETCHARFORMAT, SCF_SELECTION, longint(pParenthesisFormat));
               oldPosition := position;
               pFormat := Pointer (pStandardFormat);
             end;
        '[', ']': begin
               if (pFormat = Pointer (pTeXCommandFormat))
               or (pFormat = Pointer (pStandardFormat)) then
               begin
                 range.cpMin := oldPosition;
                 range.cpMax := position;
                 SendMessage( RichEdit.Handle, EM_EXSETSEL, 0, longint(@range) );
                 SendMessage (RichEdit.Handle, EM_SETCHARFORMAT, SCF_SELECTION, longint(pFormat));
               end;
               range.cpMin := position - 1;
               range.cpMax := position;
               SendMessage( RichEdit.Handle, EM_EXSETSEL, 0, longint(@range) );
               SendMessage (RichEdit.Handle, EM_SETCHARFORMAT, SCF_SELECTION, longint(pSquareBracketFormat));
               oldPosition := position;
               pFormat := Pointer (pStandardFormat);
             end;
        '$': begin
               if (pFormat = Pointer (pTeXCommandFormat))
               or (pFormat = Pointer (pStandardFormat)) then
               begin
                 range.cpMin := oldPosition;
                 range.cpMax := position;
                 SendMessage( RichEdit.Handle, EM_EXSETSEL, 0, longint(@range) );
                 SendMessage (RichEdit.Handle, EM_SETCHARFORMAT, SCF_SELECTION, longint(pFormat));
               end;
               range.cpMin := position - 1;
               range.cpMax := position;
               SendMessage( RichEdit.Handle, EM_EXSETSEL, 0, longint(@range) );
               SendMessage (RichEdit.Handle, EM_SETCHARFORMAT, SCF_SELECTION, longint(pDollarFormat));
               oldPosition := position;
               pFormat := Pointer (pStandardFormat);
             end;
        '(', ')': begin
               if (pFormat = Pointer (pTeXCommandFormat))
               or (pFormat = Pointer (pStandardFormat)) then
               begin
                 range.cpMin := oldPosition;
                 range.cpMax := position;
                 SendMessage( RichEdit.Handle, EM_EXSETSEL, 0, longint(@range) );
                 SendMessage (RichEdit.Handle, EM_SETCHARFORMAT, SCF_SELECTION, longint(pFormat));
               end;
               range.cpMin := position - 1;
               range.cpMax := position;
               SendMessage( RichEdit.Handle, EM_EXSETSEL, 0, longint(@range) );
               SendMessage (RichEdit.Handle, EM_SETCHARFORMAT, SCF_SELECTION, longint(pRoundBracketFormat));
               oldPosition := position;
               pFormat := Pointer (pStandardFormat);
             end;
        '-', '=', '>', ',', '~', '', '`', #39, TAB: begin
               if pFormat = Pointer (pTeXCommandFormat) then
               begin
                 range.cpMin := oldPosition;
                 range.cpMax := position;
                 SendMessage( RichEdit.Handle, EM_EXSETSEL, 0, longint(@range) );
                 SendMessage (RichEdit.Handle, EM_SETCHARFORMAT, SCF_SELECTION, longint(pTexCommandFormat));
                 oldPosition := position - 1;
                 pFormat := Pointer (pStandardFormat);
               end;
             end;
      end; {case}
      Inc(position);
    end;
    range.cpMin := oldPosition;
    range.cpMax := position - 1;
    SendMessage( RichEdit.Handle, EM_EXSETSEL, 0, longint(@range) );
    SendMessage (RichEdit.Handle, EM_SETCHARFORMAT, SCF_SELECTION, longint(pFormat));
    RichEdit.SelStart := oldSelStart;
    RichEdit.SelLength := oldSelLength;
  finally
    RichEdit.Lines.EndUpdate;
  end;
end;


//*DS*  Don't delete this.
// Replacement for the old UpdateSyntaxColoringRange
// It does not work, because Windows Rich Text controls don't
// use double bytes for all characters.
// However this method may become usefull in the future.
(*
procedure TEditForm.UpdateSyntaxColoringRange( start: integer; length: integer );
var mirror: TMemoryStream;
    eStream: EDITSTREAM;
    success: LRESULT;
begin
  // stream contents of editor into mirror
  mirror := TMemoryStream.Create;
  with eStream do
  begin
    dwCookie := longint(@mirror);
    dwError := 0;
    pfnCallback := @EditStreamCallbackWrite;
  end;
  success := SendMessage( RichEdit.Handle, EM_STREAMOUT, SF_UNICODE or SF_TEXT, longint(@eStream) );
  //success := SendMessage( RichEdit.Handle, EM_STREAMOUT, SF_TEXT, longint(@eStream) );

  UpdateSyntaxColoringBuffer( mirror.Memory, start, length );

  mirror.Free;
end;
*)

//*DS*  Don't delete this.
// This is a new fast and short method for syntax coloring.
// It does not work, because Windows Rich Text controls don't
// use double bytes for all characters.
// However this method may become usefull in the future.
(*
procedure TEditForm.UpdateSyntaxColoringBuffer( pBuffer: PWChar;
                                                start:  integer;
                                                length: integer );
var oldSelLength: integer;
    oldSelStart: integer;
    startPosition: integer;
    endPosition: integer;
    oldPosition: integer;
    position: integer;
    eventMask: integer;
    range: CharRange;
    line: integer;
    pivot: PWChar;

    //tempStream: TFileStream;
begin

  oldSelLength := RichEdit.SelLength;
  oldSelStart := RichEdit.SelStart;
  try
    eventMask := SendMessage( RichEdit.Handle, EM_SETEVENTMASK, 0, 0 );
    SendMessage( RichEdit.Handle, WM_SETREDRAW, 0, 0 );

    // start with beginning of line instead of the start parameter
    // This simplifies the method and should speed up things a bit,
    // because GetFormat is no longer needed.
    line := SendMessage (RichEdit.Handle, EM_LINEFROMCHAR, start,0);
    startPosition := SendMessage (RichEdit.Handle, EM_LINEINDEX, line, 0);

    // last position is one beyound the last character
    endPosition := start + length ;

    position := start;
    oldPosition := start;
    pivot := pbuffer + position;

    // set whole range to default format
    range.cpMin := startPosition;
    range.cpMax := endPosition;
    SendMessage( RichEdit.Handle, EM_EXSETSEL, 0, longint(@range) );
    SendMessage( RichEdit.Handle, EM_SETCHARFORMAT, SCF_SELECTION, longint(pStandardFormat) );


    while position < endPosition do
    begin
      case pivot^ of

      // TeX command
      '\': begin
             oldPosition := position;
             // find end of command
             while true do
             begin
               Inc(position);
               Inc(pivot);
               if ( position = endPosition ) then break;
               case pivot^ of
                 ' ',  #13,  '-',  '=',  '>',  ',',  '~',
                 '',  '`',  #39,  TAB,  '{',  '}',  '[',
                 ']',  '$',  '(',  ')'  :
                 begin
                   break;
                 end;
               end;
             end;
             // set TeX command format
             range.cpMin := oldPosition;
             range.cpMax := position;
             SendMessage (RichEdit.Handle, EM_EXSETSEL, 0, longint(@range) );
             SendMessage (RichEdit.Handle, EM_SETCHARFORMAT, SCF_SELECTION, longint(pTeXCommandFormat));
           end;

      // comment
      '%': begin
             oldPosition := position;
             // find end of comment
             while true do
             begin
               Inc(position);
               Inc(pivot);
               if ( position = endPosition )
               or ( pivot^ =  #13 )
               then break;
             end;
             // set comment format
             range.cpMin := oldPosition;
             range.cpMax := position;
             SendMessage (RichEdit.Handle, EM_EXSETSEL, 0, longint(@range) );
             SendMessage (RichEdit.Handle, EM_SETCHARFORMAT, SCF_SELECTION, longint(pCommentFormat));
             Inc(position);
             Inc(pivot);
           end;

      // single characters
      '$': begin
             range.cpMin := position;
             Inc(position);
             range.cpMax := position;
             SendMessage( RichEdit.Handle, EM_EXSETSEL, 0, longint(@range) );
             SendMessage(RichEdit.Handle, EM_SETCHARFORMAT, SCF_SELECTION, longint(pDollarFormat));
             Inc(pivot);
           end;
      '{', '}':
           begin
             range.cpMin := position;
             Inc(position);
             range.cpMax := position;
             SendMessage( RichEdit.Handle, EM_EXSETSEL, 0, longint(@range) );
             SendMessage(RichEdit.Handle, EM_SETCHARFORMAT, SCF_SELECTION, longint(pParenthesisFormat));
             Inc(pivot);
           end;
      '[', ']':
           begin
             range.cpMin := position;
             Inc(position);
             range.cpMax := position;
             SendMessage( RichEdit.Handle, EM_EXSETSEL, 0, longint(@range) );
             SendMessage(RichEdit.Handle, EM_SETCHARFORMAT, SCF_SELECTION, longint(pSquareBracketFormat));
             Inc(pivot);
           end;
      '(', ')':
           begin
             range.cpMin := position;
             Inc(position);
             range.cpMax := position;
             SendMessage( RichEdit.Handle, EM_EXSETSEL, 0, longint(@range) );
             SendMessage(RichEdit.Handle, EM_SETCHARFORMAT, SCF_SELECTION, longint(pRoundBracketFormat));
             Inc(pivot);
           end;
      else
           begin
             Inc(position);
             Inc(pivot);
           end;
      end; // case
    end; // while

    RichEdit.SelStart := oldSelStart;
    RichEdit.SelLength := oldSelLength;
  finally
    SendMessage(RichEdit.Handle, EM_SETEVENTMASK, 0, eventMask );
    SendMessage( RichEdit.Handle, WM_SETREDRAW, 1, 0 );
    InvalidateRect( RichEdit.Handle, 0, true );
  end;
end;
*)


procedure TEditForm.SetFont(theFont: TFont);
begin
  with RichEdit.SelAttributes do
  begin
    Color  := theFont.Color;
    Size   := theFont.Size;
    Name   := theFont.Name;
    Style  := theFont.Style;
    Charset := theFont.Charset;
  end;
end;


function TEditForm.GetFormat: Pointer ;
var position: integer;
    endPosition: integer;
    line: integer;
    size: integer;
begin
  result := Pointer (pStandardFormat);
  endPosition := RichEdit.SelStart;
  //line := SendMessage (RichEdit.Handle, EM_LINEFROMCHAR, RichEdit.SelStart,0);
  line := SendMessage( RichEdit.Handle, EM_EXLINEFROMCHAR, 0, RichEdit.SelStart );
  position := SendMessage (RichEdit.Handle, EM_LINEINDEX, line, 0);
  size := SendMessage (RichEdit.Handle, WM_GETTEXTLENGTH, 0, 0);
  if position = -1 then exit;
  if size = 0 then exit;

  { change position to pascal format }
  Inc (endPosition);
  Inc (position);

  { update selection }
  while position < endPosition do
  begin
    case RichEdit.Text[position] of
      ' ': begin
             result := Pointer (pStandardFormat);
           end;
      #13: begin // Cursor Return
             result := Pointer (pStandardFormat);
           end;
      '\': begin
             result := Pointer (pTexCommandFormat);
           end;
      '{', '}': begin
             result := Pointer (pStandardFormat);
           end;
      '[', ']': begin
             result := Pointer (pStandardFormat);
           end;
      '$': begin
             result := Pointer (pStandardFormat);
           end;
      '(', ')': begin
             result := Pointer (pStandardFormat);
           end;
      '%': begin
             if (result <> Pointer (pTeXCommandFormat)) then
             begin
               result := Pointer (pCommentFormat);
               break;
             end;
           end;
      '-', '=', '>', ',', '~', '', '`', #39:
            begin
              result := Pointer (pStandardFormat);
            end;
    end; {case}
    Inc(position);
  end;
end;


procedure TEditForm.UpdateSelection;
var oldState: boolean;
begin
  oldState := RichEdit.Modified;
  UpdateSyntaxColoringRange (RichEdit.SelStart, RichEdit.SelLength);
  if not oldState then //was not modified
  begin
    RichEdit.Modified := oldState;
    theWinpanel.Font.Style := [];
    SizeWinPanel;
  end;
end;


{ set whole Text to this format }
procedure TEditForm.SetToStandard;
var oldSelLength: integer;
    oldSelStart: integer;
//    size: integer;
begin
  RichEdit.Lines.BeginUpdate;
  oldSelLength := RichEdit.SelLength;
  oldSelStart := RichEdit.SelStart;

//  size := SendMessage (RichEdit.Handle, WM_GETTEXTLENGTH, 0, 0);
//  SendMessage (RichEdit.Handle, EM_SETSEL, 0, size);
//  SendMessage (RichEdit.Handle, EM_SETCHARFORMAT, SCF_SELECTION, lParam(@format));
  RichEdit.SelStart := 0;
  RichEdit.SelLength := RichEdit.GetTextLen;
  SetFont(FrameForm.standardFont);

  RichEdit.SelLength := oldSelLength;
  RichEdit.SelStart := oldSelStart;
  RichEdit.Lines.EndUpdate;
end;

//*PN*
procedure TEditForm.RichEditChange(Sender: TObject);
begin
  if not (fsBold in theWinPanel.Font.Style) then
  begin
    theWinPanel.Font.Style := theWinPanel.Font.Style + [fsBold];
    SizeWinPanel;
  end;
end;

//*PN*
procedure TEditForm.FormDeactivate(Sender: TObject);
begin
  theWinPanel.Down := false;
end;

(* *DS* Should work without this refresh when compiled with Delphi 5
procedure TEditForm.FormResize(Sender: TObject);
begin
  RichEdit.Refresh;
end;
*)

procedure TEditForm.Close1Click(Sender: TObject);
begin
  Close;
end;

procedure TEditForm.Save1Click(Sender: TObject);
begin
  Save;
end;

procedure TEditForm.Saveas1Click(Sender: TObject);
begin
  SaveAs;
end;

procedure TEditForm.Setasmainfile1Click(Sender: TObject);
begin
  FrameForm.strMainFile := fileName;
  FrameForm.StatusBar1.Panels[1].Text := 'Main file: ' + FrameForm.strMainFile;
  SetCurrentDir (ExtractFileDir (FrameForm.strMainFile));
  FrameForm.mainFileSelected := true;
end;

procedure TEditForm.UpdateSelection1Click(Sender: TObject);
begin
  UpdateSelection;
end;

procedure TEditForm.Cut1Click(Sender: TObject);
begin
  Richedit.CutToClipboard;
end;

procedure TEditForm.Copy2Click(Sender: TObject);
begin
  RichEdit.CopyToClipboard;
end;

procedure TEditForm.Paste2Click(Sender: TObject);
begin
  RichEdit.PasteFromClipboard;
end;


//*DS* start spell checking from caret position or end of current selection
// Sender should be a spell check dialog
procedure TEditForm.SpellCheck(Sender: TObject);
var
  line: integer;
  column: integer;
  lineBegin: integer;
  foundMisspelled: boolean;
  spellResult: IspellFirst;
  strToCheck: String;
  selection: CHARRANGE;
begin
  // get current line and position at end of selection
  //line := SendMessage (RichEdit.Handle, EM_LINEFROMCHAR, RichEdit.SelStart + RichEdit.SelLength,0);
  //lineBegin := SendMessage (RichEdit.Handle, EM_LINEINDEX, line, 0);
  //column := RichEdit.SelStart + RichEdit.SelLength - lineBegin;

  SendMessage( RichEdit.Handle, EM_EXGETSEL, 0, lParam(@selection) );
  line := SendMessage( RichEdit.Handle, EM_EXLINEFROMCHAR, 0, selection.cpMax );
  lineBegin := SendMessage( RichEdit.Handle, EM_LINEINDEX, line, 0 );
  column := selection.cpMax - lineBegin;


  while line < RichEdit.Lines.Count do
  begin
    // spell check line from end of selection until an error is found
    strToCheck := RichEdit.Lines[line];
    Delete (strToCheck, 1, column);
    foundMisspelled := (Sender as TSpellCheckDialog).FindFirst (self, strToCheck, spellResult);

    if foundMisspelled = true then
    begin
      // mark misspelled word and exit
      (*
      RichEdit.SelStart := SendMessage (RichEdit.Handle, EM_LINEINDEX, line, 0) + spellResult.pos + column;
      RichEdit.SelLength := spellResult.len;
      (Sender as TSpellCheckDialog).CheckWord (self, RichEdit.SelText);
      SendMessage (RichEdit.Handle, WM_SETFOCUS, 0, 0);
      Exit;
      *)
      selection.cpMin := SendMessage( RichEdit.Handle, EM_LINEINDEX, line, 0 ) + spellResult.pos + column;
      selection.cpMax := selection.cpMin + spellResult.len;
      SendMessage( RichEdit.Handle, EM_EXSETSEL, 0, lParam(@selection) );
      SendMessage( RichEdit.Handle, EM_HIDESELECTION, 0, 0 );
      (Sender as TSpellCheckDialog).CheckWord (self, RichEdit.SelText);
      SendMessage (RichEdit.Handle, WM_SETFOCUS, 0, 0);
      Exit;
    end
    else
    begin
      // move to next line
      Inc(line);
      column := 0;
    end;
  end;

  MessageDlg('End of file reached', mtInformation, [mbOK], 0);
end;


//*KL*
procedure TEditForm.Commentout1Click(Sender: TObject);
var
  LineStart, LineEnd, ColumnNext, ColumnLast, i : integer;
  SaveStart, SaveLength : integer;
  Pos : TPoint;
begin
//Pos := RichEdit.CaretPos;
  if {(Pos.x = 0) and  works not correct and is not really necessary}
    (RichEdit.SelLength <> 0) then //if on first position on the "next line"
  begin
    RichEdit.SelLength := RichEdit.SelLength - 1 //avoid to comment out this "next line"
  end;
  //LineStart := SendMessage (RichEdit.Handle, EM_LINEFROMCHAR, RichEdit.SelStart, 0);
  //LineEnd := SendMessage (RichEdit.Handle, EM_LINEFROMCHAR,
  //  RichEdit.SelStart + RichEdit.SelLength, 0);

  LineStart := SendMessage( RichEdit.Handle, EM_EXLINEFROMCHAR, 0, RichEdit.SelStart );
  LineEnd := SendMessage( RichEdit.Handle, EM_EXLINEFROMCHAR, 0, RichEdit.SelStart + RichEdit.SelLength );

  ColumnNext := SendMessage (RichEdit.Handle, EM_LINEINDEX, LineStart + 1, 0);
  ColumnLast := SendMessage (RichEdit.Handle, EM_LINEINDEX, LineEnd + 1, 0);
  if ColumnLast = -1 then //last line marked
  begin
    ColumnLast := SendMessage (RichEdit.Handle, EM_LINEINDEX, LineEnd, 0) +
      SendMessage (RichEdit.Handle, EM_LINELENGTH, LineEnd, 0);;
  end;
  SaveStart := RichEdit.SelStart;
  SaveLength := ColumnLast - RichEdit.SelStart;

  if RichEdit.SelLength = 0 then
  begin
    RichEdit.SelLength := 1;
    if RichEdit.SelText = '%' then
    begin
      //comment in
      RichEdit.SelText := '';
    end else
    begin
      //comment out
      RichEdit.SelLength := 0;
      RichEdit.SelText := '%';
      RichEdit.SelStart := RichEdit.SelStart - 1;
    end;
    RichEdit.SelLength := columnNext - RichEdit.SelStart;
    if ColumnNext <> -1 then
    begin
      UpdateSelection;
    end;
    RichEdit.SelLength := 0;
  end else
  begin //if text marked
    RichEdit.SelLength := 1;
    if RichEdit.SelText = '%' then
    begin
      //comment in
      RichEdit.SelText := '';
      for i := LineStart + 1 to LineEnd do
      begin
        ColumnNext := SendMessage (RichEdit.Handle, EM_LINEINDEX, i, 0);
        RichEdit.SelStart := ColumnNext;
        RichEdit.SelLength := 1;
        if RichEdit.SelText = '%' then
        begin
          RichEdit.SelText := '';
        end;
      end;
      RichEdit.SelStart := SaveStart;
      RichEdit.SelLength := SaveLength - LineEnd + LineStart - 1;//old Length minus number of removed %
    end else
    begin
      //comment out
      RichEdit.SelLength := 0;
      RichEdit.SelText := '%';
      for i := LineStart + 1 to LineEnd do
      begin
        ColumnNext := SendMessage (RichEdit.Handle, EM_LINEINDEX, i, 0);
        RichEdit.SelStart := ColumnNext;
        RichEdit.SelText := '%';
      end;
      RichEdit.SelStart := SaveStart;
      RichEdit.SelLength := SaveLength + LineEnd - LineStart + 1;//old Length plus number of inserted %
    end;
    UpdateSelection;
  end;
end;

end.


