/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.openwire.v5;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.DataStructure;
import org.apache.activemq.command.JournalTopicAck;
import org.apache.activemq.command.MessageId;
import org.apache.activemq.command.TransactionId;
import org.apache.activemq.openwire.BooleanStream;
import org.apache.activemq.openwire.OpenWireFormat;
import org.apache.activemq.openwire.v5.BaseDataStreamMarshaller;

public class JournalTopicAckMarshaller
extends BaseDataStreamMarshaller {
    @Override
    public byte getDataStructureType() {
        return 50;
    }

    @Override
    public DataStructure createObject() {
        return new JournalTopicAck();
    }

    @Override
    public void tightUnmarshal(OpenWireFormat wireFormat, Object o, DataInput dataIn, BooleanStream bs) throws IOException {
        super.tightUnmarshal(wireFormat, o, dataIn, bs);
        JournalTopicAck info = (JournalTopicAck)o;
        info.setDestination((ActiveMQDestination)this.tightUnmarsalNestedObject(wireFormat, dataIn, bs));
        info.setMessageId((MessageId)this.tightUnmarsalNestedObject(wireFormat, dataIn, bs));
        info.setMessageSequenceId(this.tightUnmarshalLong(wireFormat, dataIn, bs));
        info.setSubscritionName(this.tightUnmarshalString(dataIn, bs));
        info.setClientId(this.tightUnmarshalString(dataIn, bs));
        info.setTransactionId((TransactionId)this.tightUnmarsalNestedObject(wireFormat, dataIn, bs));
    }

    @Override
    public int tightMarshal1(OpenWireFormat wireFormat, Object o, BooleanStream bs) throws IOException {
        JournalTopicAck info = (JournalTopicAck)o;
        int rc = super.tightMarshal1(wireFormat, o, bs);
        rc += this.tightMarshalNestedObject1(wireFormat, (DataStructure)info.getDestination(), bs);
        rc += this.tightMarshalNestedObject1(wireFormat, (DataStructure)info.getMessageId(), bs);
        rc += this.tightMarshalLong1(wireFormat, info.getMessageSequenceId(), bs);
        rc += this.tightMarshalString1(info.getSubscritionName(), bs);
        rc += this.tightMarshalString1(info.getClientId(), bs);
        return (rc += this.tightMarshalNestedObject1(wireFormat, (DataStructure)info.getTransactionId(), bs)) + 0;
    }

    @Override
    public void tightMarshal2(OpenWireFormat wireFormat, Object o, DataOutput dataOut, BooleanStream bs) throws IOException {
        super.tightMarshal2(wireFormat, o, dataOut, bs);
        JournalTopicAck info = (JournalTopicAck)o;
        this.tightMarshalNestedObject2(wireFormat, (DataStructure)info.getDestination(), dataOut, bs);
        this.tightMarshalNestedObject2(wireFormat, (DataStructure)info.getMessageId(), dataOut, bs);
        this.tightMarshalLong2(wireFormat, info.getMessageSequenceId(), dataOut, bs);
        this.tightMarshalString2(info.getSubscritionName(), dataOut, bs);
        this.tightMarshalString2(info.getClientId(), dataOut, bs);
        this.tightMarshalNestedObject2(wireFormat, (DataStructure)info.getTransactionId(), dataOut, bs);
    }

    @Override
    public void looseUnmarshal(OpenWireFormat wireFormat, Object o, DataInput dataIn) throws IOException {
        super.looseUnmarshal(wireFormat, o, dataIn);
        JournalTopicAck info = (JournalTopicAck)o;
        info.setDestination((ActiveMQDestination)this.looseUnmarsalNestedObject(wireFormat, dataIn));
        info.setMessageId((MessageId)this.looseUnmarsalNestedObject(wireFormat, dataIn));
        info.setMessageSequenceId(this.looseUnmarshalLong(wireFormat, dataIn));
        info.setSubscritionName(this.looseUnmarshalString(dataIn));
        info.setClientId(this.looseUnmarshalString(dataIn));
        info.setTransactionId((TransactionId)this.looseUnmarsalNestedObject(wireFormat, dataIn));
    }

    @Override
    public void looseMarshal(OpenWireFormat wireFormat, Object o, DataOutput dataOut) throws IOException {
        JournalTopicAck info = (JournalTopicAck)o;
        super.looseMarshal(wireFormat, o, dataOut);
        this.looseMarshalNestedObject(wireFormat, (DataStructure)info.getDestination(), dataOut);
        this.looseMarshalNestedObject(wireFormat, (DataStructure)info.getMessageId(), dataOut);
        this.looseMarshalLong(wireFormat, info.getMessageSequenceId(), dataOut);
        this.looseMarshalString(info.getSubscritionName(), dataOut);
        this.looseMarshalString(info.getClientId(), dataOut);
        this.looseMarshalNestedObject(wireFormat, (DataStructure)info.getTransactionId(), dataOut);
    }
}

