/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.engine;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.camel.NamedNode;
import org.apache.camel.spi.NodeIdFactory;

public class DefaultNodeIdFactory
implements NodeIdFactory {
    protected static final Map<String, AtomicInteger> NODE_COUNTERS = new ConcurrentHashMap<String, AtomicInteger>();

    public String createId(NamedNode definition) {
        String key = definition.getShortName();
        return key + DefaultNodeIdFactory.getNodeCounter(key).incrementAndGet();
    }

    protected static AtomicInteger getNodeCounter(String key) {
        return NODE_COUNTERS.computeIfAbsent(key, k -> new AtomicInteger());
    }

    protected static void resetAllCounters() {
        for (AtomicInteger counter : NODE_COUNTERS.values()) {
            counter.set(0);
        }
    }
}

