/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ant.dotnet;

import java.io.File;
import org.apache.ant.dotnet.NetCommand;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.util.FileUtils;

public class ImportTypelib
extends Task {
    private static final FileUtils FILE_UTILS = FileUtils.getFileUtils();
    private File srcFile;
    private File destFile;
    private String namespace;
    private boolean useSysArray = false;
    private boolean unsafe = false;
    private String extraOptions = null;

    public void setDestFile(File destFile) {
        this.destFile = destFile;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setSrcFile(File srcFile) {
        this.srcFile = srcFile;
    }

    public void setUnsafe(boolean unsafe) {
        this.unsafe = unsafe;
    }

    public void setUseSysArray(boolean useSysArray) {
        this.useSysArray = useSysArray;
    }

    public void setExtraOptions(String extraOptions) {
        this.extraOptions = extraOptions;
    }

    protected void validate() throws BuildException {
        if (this.destFile == null) {
            throw new BuildException("destination file must be specified");
        }
        if (this.destFile.isDirectory()) {
            throw new BuildException("destination file is a directory");
        }
        if (this.srcFile == null || !this.srcFile.exists()) {
            throw new BuildException("source file does not exist");
        }
        if (this.srcFile.isDirectory()) {
            throw new BuildException("source file is a directory");
        }
        if (this.namespace == null) {
            throw new BuildException("No namespace");
        }
    }

    private boolean isExecuteNeeded() {
        long destTime;
        if (!this.destFile.exists()) {
            this.log("Destination file does not exist: a build is required", 3);
            return true;
        }
        long sourceTime = this.srcFile.lastModified();
        if (sourceTime > (destTime = this.destFile.lastModified()) + FILE_UTILS.getFileTimestampGranularity()) {
            this.log("Source file is newer than the dest file: a rebuild is required", 3);
            return true;
        }
        this.log("The output file is up to date", 3);
        return false;
    }

    public void execute() throws BuildException {
        this.validate();
        this.log("Importing typelib " + this.srcFile + " to assembly " + this.destFile + " in namespace " + this.namespace, 3);
        if (!this.isExecuteNeeded()) {
            return;
        }
        NetCommand command = new NetCommand(this, "ImportTypelib", "tlbimp");
        command.setFailOnError(true);
        command.addArgument(this.srcFile.toString());
        command.addArgument("/nologo");
        command.addArgument("/out:" + this.destFile);
        command.addArgument("/namespace:", this.namespace);
        if (this.useSysArray) {
            command.addArgument("/sysarray");
        }
        if (this.unsafe) {
            command.addArgument("/unsafe");
        }
        command.addArgument(this.extraOptions);
        command.runCommand();
    }
}

