/*
 * Decompiled with CFR 0.152.
 */
package org.tranql.connector.jdbc;

import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Map;
import java.util.Properties;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.LazyAssociatableConnectionManager;
import javax.resource.spi.LocalTransaction;
import javax.resource.spi.ManagedConnectionFactory;
import org.tranql.connector.DissociatableConnectionHandle;
import org.tranql.connector.ManagedConnectionHandle;
import org.tranql.connector.jdbc.CallableStatementHandle;
import org.tranql.connector.jdbc.DatabaseMetaDataHandle;
import org.tranql.connector.jdbc.PreparedStatementHandle;
import org.tranql.connector.jdbc.StatementHandle;

public class ConnectionHandle
implements Connection,
DissociatableConnectionHandle<Connection, ConnectionHandle> {
    protected final LazyAssociatableConnectionManager cm;
    protected final ManagedConnectionFactory mcf;
    protected final ConnectionRequestInfo cri;
    protected ManagedConnectionHandle<Connection, ConnectionHandle> mc;
    protected boolean closed;

    public ConnectionHandle(LazyAssociatableConnectionManager cm, ManagedConnectionFactory mcf, ConnectionRequestInfo cri) {
        this.cm = cm;
        this.mcf = mcf;
        this.cri = cri;
    }

    protected ManagedConnectionHandle<Connection, ConnectionHandle> getManagedConnection() throws SQLException {
        if (this.closed) {
            throw new SQLException("Connection has been closed");
        }
        if (this.mc == null && this.cm != null) {
            try {
                this.cm.associateConnection((Object)this, this.mcf, this.cri);
            }
            catch (ResourceException e) {
                if (e.getCause() instanceof SQLException) {
                    throw (SQLException)e.getCause();
                }
                throw (SQLException)new SQLException("Failed lazy association with ManagedConnection").initCause(e);
            }
            if (this.mc == null) {
                throw new SQLException("Failed lazy association with ManagedConnection");
            }
        }
        assert (this.mc != null);
        return this.mc;
    }

    @Override
    public void setAssociation(ManagedConnectionHandle<Connection, ConnectionHandle> mc) {
        this.mc = mc;
    }

    @Override
    public ManagedConnectionHandle<Connection, ConnectionHandle> getAssociation() {
        return this.mc;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.closed;
    }

    @Override
    public void close() throws SQLException {
        if (this.closed) {
            return;
        }
        if (this.mc != null) {
            this.mc.connectionClosed(this);
        }
        this.closed = true;
    }

    void connectionError(SQLException e) {
        if (this.mc != null) {
            this.mc.connectionError(e);
        }
    }

    @Override
    public void commit() throws SQLException {
        ManagedConnectionHandle<Connection, ConnectionHandle> mc = this.getManagedConnection();
        Connection c = mc.getPhysicalConnection();
        if (c.getAutoCommit()) {
            return;
        }
        try {
            LocalTransaction tx = mc.getClientLocalTransaction();
            tx.commit();
            tx.begin();
        }
        catch (ResourceException e) {
            if (e.getCause() instanceof SQLException) {
                throw (SQLException)e.getCause();
            }
            throw (SQLException)new SQLException().initCause(e);
        }
    }

    @Override
    public void rollback() throws SQLException {
        ManagedConnectionHandle<Connection, ConnectionHandle> mc = this.getManagedConnection();
        Connection c = mc.getPhysicalConnection();
        if (c.getAutoCommit()) {
            return;
        }
        try {
            LocalTransaction tx = mc.getClientLocalTransaction();
            tx.rollback();
            tx.begin();
        }
        catch (ResourceException e) {
            if (e.getCause() instanceof SQLException) {
                throw (SQLException)e.getCause();
            }
            throw (SQLException)new SQLException().initCause(e);
        }
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        ManagedConnectionHandle<Connection, ConnectionHandle> mc = this.getManagedConnection();
        Connection c = mc.getPhysicalConnection();
        if (autoCommit == c.getAutoCommit()) {
            return;
        }
        try {
            LocalTransaction tx = mc.getClientLocalTransaction();
            if (autoCommit) {
                tx.commit();
            } else {
                tx.begin();
            }
        }
        catch (ResourceException e) {
            if (e.getCause() instanceof SQLException) {
                throw (SQLException)e.getCause();
            }
            throw (SQLException)new SQLException().initCause(e);
        }
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        ManagedConnectionHandle<Connection, ConnectionHandle> mc = this.getManagedConnection();
        try {
            return mc.getPhysicalConnection().getAutoCommit();
        }
        catch (SQLException e) {
            this.connectionError(e);
            throw e;
        }
    }

    protected Statement wrapStatement(Statement s) {
        return new StatementHandle<Statement>(this, s);
    }

    protected PreparedStatement wrapPreparedStatement(PreparedStatement ps) {
        return new PreparedStatementHandle<PreparedStatement>(this, ps);
    }

    protected CallableStatement wrapCallableStatement(CallableStatement cs) {
        return new CallableStatementHandle<CallableStatement>(this, cs);
    }

    protected DatabaseMetaData wrapMetaData(DatabaseMetaData dbmd) {
        return new DatabaseMetaDataHandle(this, dbmd);
    }

    @Override
    public Statement createStatement() throws SQLException {
        ManagedConnectionHandle<Connection, ConnectionHandle> mc = this.getManagedConnection();
        try {
            return this.wrapStatement(mc.getPhysicalConnection().createStatement());
        }
        catch (SQLException e) {
            this.connectionError(e);
            throw e;
        }
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        ManagedConnectionHandle<Connection, ConnectionHandle> mc = this.getManagedConnection();
        try {
            return this.wrapStatement(mc.getPhysicalConnection().createStatement(resultSetType, resultSetConcurrency));
        }
        catch (SQLException e) {
            this.connectionError(e);
            throw e;
        }
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        ManagedConnectionHandle<Connection, ConnectionHandle> mc = this.getManagedConnection();
        try {
            return this.wrapStatement(mc.getPhysicalConnection().createStatement(resultSetType, resultSetConcurrency, resultSetHoldability));
        }
        catch (SQLException e) {
            this.connectionError(e);
            throw e;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        ManagedConnectionHandle<Connection, ConnectionHandle> mc = this.getManagedConnection();
        try {
            return this.wrapPreparedStatement(mc.getPhysicalConnection().prepareStatement(sql));
        }
        catch (SQLException e) {
            this.connectionError(e);
            throw e;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        ManagedConnectionHandle<Connection, ConnectionHandle> mc = this.getManagedConnection();
        try {
            return this.wrapPreparedStatement(mc.getPhysicalConnection().prepareStatement(sql, autoGeneratedKeys));
        }
        catch (SQLException e) {
            this.connectionError(e);
            throw e;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        ManagedConnectionHandle<Connection, ConnectionHandle> mc = this.getManagedConnection();
        try {
            return this.wrapPreparedStatement(mc.getPhysicalConnection().prepareStatement(sql, columnIndexes));
        }
        catch (SQLException e) {
            this.connectionError(e);
            throw e;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        ManagedConnectionHandle<Connection, ConnectionHandle> mc = this.getManagedConnection();
        try {
            return this.wrapPreparedStatement(mc.getPhysicalConnection().prepareStatement(sql, columnNames));
        }
        catch (SQLException e) {
            this.connectionError(e);
            throw e;
        }
    }

    @Override
    public Clob createClob() throws SQLException {
        ManagedConnectionHandle<Connection, ConnectionHandle> mc = this.getManagedConnection();
        try {
            return mc.getPhysicalConnection().createClob();
        }
        catch (SQLException e) {
            this.connectionError(e);
            throw e;
        }
    }

    @Override
    public Blob createBlob() throws SQLException {
        ManagedConnectionHandle<Connection, ConnectionHandle> mc = this.getManagedConnection();
        try {
            return mc.getPhysicalConnection().createBlob();
        }
        catch (SQLException e) {
            this.connectionError(e);
            throw e;
        }
    }

    @Override
    public NClob createNClob() throws SQLException {
        ManagedConnectionHandle<Connection, ConnectionHandle> mc = this.getManagedConnection();
        try {
            return mc.getPhysicalConnection().createNClob();
        }
        catch (SQLException e) {
            this.connectionError(e);
            throw e;
        }
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        ManagedConnectionHandle<Connection, ConnectionHandle> mc = this.getManagedConnection();
        try {
            return mc.getPhysicalConnection().createSQLXML();
        }
        catch (SQLException e) {
            this.connectionError(e);
            throw e;
        }
    }

    @Override
    public boolean isValid(int i) throws SQLException {
        ManagedConnectionHandle<Connection, ConnectionHandle> mc = this.getManagedConnection();
        try {
            return mc.getPhysicalConnection().isValid(i);
        }
        catch (SQLException e) {
            this.connectionError(e);
            throw e;
        }
    }

    @Override
    public void setClientInfo(String s, String s1) throws SQLClientInfoException {
        try {
            ManagedConnectionHandle<Connection, ConnectionHandle> mc = this.getManagedConnection();
            mc.getPhysicalConnection().setClientInfo(s, s1);
        }
        catch (SQLClientInfoException e) {
            this.connectionError(e);
            throw e;
        }
        catch (SQLException e) {
            this.connectionError(e);
            throw (SQLClientInfoException)new SQLClientInfoException().initCause(e);
        }
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        try {
            ManagedConnectionHandle<Connection, ConnectionHandle> mc = this.getManagedConnection();
            mc.getPhysicalConnection().setClientInfo(properties);
        }
        catch (SQLClientInfoException e) {
            this.connectionError(e);
            throw e;
        }
        catch (SQLException e) {
            this.connectionError(e);
            throw (SQLClientInfoException)new SQLClientInfoException().initCause(e);
        }
    }

    @Override
    public String getClientInfo(String s) throws SQLException {
        ManagedConnectionHandle<Connection, ConnectionHandle> mc = this.getManagedConnection();
        try {
            return mc.getPhysicalConnection().getClientInfo(s);
        }
        catch (SQLException e) {
            this.connectionError(e);
            throw e;
        }
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        ManagedConnectionHandle<Connection, ConnectionHandle> mc = this.getManagedConnection();
        try {
            return mc.getPhysicalConnection().getClientInfo();
        }
        catch (SQLException e) {
            this.connectionError(e);
            throw e;
        }
    }

    @Override
    public Array createArrayOf(String s, Object[] objects) throws SQLException {
        ManagedConnectionHandle<Connection, ConnectionHandle> mc = this.getManagedConnection();
        try {
            return mc.getPhysicalConnection().createArrayOf(s, objects);
        }
        catch (SQLException e) {
            this.connectionError(e);
            throw e;
        }
    }

    @Override
    public Struct createStruct(String s, Object[] objects) throws SQLException {
        ManagedConnectionHandle<Connection, ConnectionHandle> mc = this.getManagedConnection();
        try {
            return mc.getPhysicalConnection().createStruct(s, objects);
        }
        catch (SQLException e) {
            this.connectionError(e);
            throw e;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        ManagedConnectionHandle<Connection, ConnectionHandle> mc = this.getManagedConnection();
        try {
            return this.wrapPreparedStatement(mc.getPhysicalConnection().prepareStatement(sql, resultSetType, resultSetConcurrency));
        }
        catch (SQLException e) {
            this.connectionError(e);
            throw e;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        ManagedConnectionHandle<Connection, ConnectionHandle> mc = this.getManagedConnection();
        try {
            return this.wrapPreparedStatement(mc.getPhysicalConnection().prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability));
        }
        catch (SQLException e) {
            this.connectionError(e);
            throw e;
        }
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        ManagedConnectionHandle<Connection, ConnectionHandle> mc = this.getManagedConnection();
        try {
            return this.wrapCallableStatement(mc.getPhysicalConnection().prepareCall(sql));
        }
        catch (SQLException e) {
            this.connectionError(e);
            throw e;
        }
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        ManagedConnectionHandle<Connection, ConnectionHandle> mc = this.getManagedConnection();
        try {
            return this.wrapCallableStatement(mc.getPhysicalConnection().prepareCall(sql, resultSetType, resultSetConcurrency));
        }
        catch (SQLException e) {
            this.connectionError(e);
            throw e;
        }
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        ManagedConnectionHandle<Connection, ConnectionHandle> mc = this.getManagedConnection();
        try {
            return this.wrapCallableStatement(mc.getPhysicalConnection().prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability));
        }
        catch (SQLException e) {
            this.connectionError(e);
            throw e;
        }
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        ManagedConnectionHandle<Connection, ConnectionHandle> mc = this.getManagedConnection();
        try {
            return this.wrapMetaData(mc.getPhysicalConnection().getMetaData());
        }
        catch (SQLException e) {
            this.connectionError(e);
            throw e;
        }
    }

    @Override
    public String getCatalog() throws SQLException {
        ManagedConnectionHandle<Connection, ConnectionHandle> mc = this.getManagedConnection();
        try {
            return mc.getPhysicalConnection().getCatalog();
        }
        catch (SQLException e) {
            this.connectionError(e);
            throw e;
        }
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        ManagedConnectionHandle<Connection, ConnectionHandle> mc = this.getManagedConnection();
        try {
            mc.getPhysicalConnection().setCatalog(catalog);
        }
        catch (SQLException e) {
            this.connectionError(e);
            throw e;
        }
    }

    @Override
    public int getHoldability() throws SQLException {
        ManagedConnectionHandle<Connection, ConnectionHandle> mc = this.getManagedConnection();
        try {
            return mc.getPhysicalConnection().getHoldability();
        }
        catch (SQLException e) {
            this.connectionError(e);
            throw e;
        }
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        ManagedConnectionHandle<Connection, ConnectionHandle> mc = this.getManagedConnection();
        try {
            mc.getPhysicalConnection().setHoldability(holdability);
        }
        catch (SQLException e) {
            this.connectionError(e);
            throw e;
        }
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        ManagedConnectionHandle<Connection, ConnectionHandle> mc = this.getManagedConnection();
        try {
            return mc.getPhysicalConnection().getTransactionIsolation();
        }
        catch (SQLException e) {
            this.connectionError(e);
            throw e;
        }
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        ManagedConnectionHandle<Connection, ConnectionHandle> mc = this.getManagedConnection();
        try {
            mc.getPhysicalConnection().setTransactionIsolation(level);
        }
        catch (SQLException e) {
            this.connectionError(e);
            throw e;
        }
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        ManagedConnectionHandle<Connection, ConnectionHandle> mc = this.getManagedConnection();
        try {
            return mc.getPhysicalConnection().getTypeMap();
        }
        catch (SQLException e) {
            this.connectionError(e);
            throw e;
        }
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        ManagedConnectionHandle<Connection, ConnectionHandle> mc = this.getManagedConnection();
        try {
            mc.getPhysicalConnection().setTypeMap(map);
        }
        catch (SQLException e) {
            this.connectionError(e);
            throw e;
        }
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        ManagedConnectionHandle<Connection, ConnectionHandle> mc = this.getManagedConnection();
        try {
            return mc.getPhysicalConnection().getWarnings();
        }
        catch (SQLException e) {
            this.connectionError(e);
            throw e;
        }
    }

    @Override
    public void clearWarnings() throws SQLException {
        ManagedConnectionHandle<Connection, ConnectionHandle> mc = this.getManagedConnection();
        try {
            mc.getPhysicalConnection().clearWarnings();
        }
        catch (SQLException e) {
            this.connectionError(e);
            throw e;
        }
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        ManagedConnectionHandle<Connection, ConnectionHandle> mc = this.getManagedConnection();
        try {
            return mc.getPhysicalConnection().isReadOnly();
        }
        catch (SQLException e) {
            this.connectionError(e);
            throw e;
        }
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        ManagedConnectionHandle<Connection, ConnectionHandle> mc = this.getManagedConnection();
        try {
            mc.getPhysicalConnection().setReadOnly(readOnly);
        }
        catch (SQLException e) {
            this.connectionError(e);
            throw e;
        }
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        ManagedConnectionHandle<Connection, ConnectionHandle> mc = this.getManagedConnection();
        try {
            return mc.getPhysicalConnection().setSavepoint();
        }
        catch (SQLException e) {
            this.connectionError(e);
            throw e;
        }
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        ManagedConnectionHandle<Connection, ConnectionHandle> mc = this.getManagedConnection();
        try {
            return mc.getPhysicalConnection().setSavepoint(name);
        }
        catch (SQLException e) {
            this.connectionError(e);
            throw e;
        }
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        ManagedConnectionHandle<Connection, ConnectionHandle> mc = this.getManagedConnection();
        try {
            mc.getPhysicalConnection().releaseSavepoint(savepoint);
        }
        catch (SQLException e) {
            this.connectionError(e);
            throw e;
        }
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        ManagedConnectionHandle<Connection, ConnectionHandle> mc = this.getManagedConnection();
        try {
            mc.getPhysicalConnection().rollback(savepoint);
        }
        catch (SQLException e) {
            this.connectionError(e);
            throw e;
        }
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        ManagedConnectionHandle<Connection, ConnectionHandle> mc = this.getManagedConnection();
        try {
            return mc.getPhysicalConnection().nativeSQL(sql);
        }
        catch (SQLException e) {
            this.connectionError(e);
            throw e;
        }
    }

    @Override
    public <T> T unwrap(Class<T> tClass) throws SQLException {
        if (tClass.isInstance(this)) {
            return tClass.cast(this);
        }
        ManagedConnectionHandle<Connection, ConnectionHandle> mc = this.getManagedConnection();
        try {
            return mc.getPhysicalConnection().unwrap(tClass);
        }
        catch (SQLException e) {
            this.connectionError(e);
            throw e;
        }
    }

    @Override
    public boolean isWrapperFor(Class<?> aClass) throws SQLException {
        if (aClass.isInstance(this)) {
            return true;
        }
        ManagedConnectionHandle<Connection, ConnectionHandle> mc = this.getManagedConnection();
        try {
            return mc.getPhysicalConnection().isWrapperFor(aClass);
        }
        catch (SQLException e) {
            this.connectionError(e);
            throw e;
        }
    }
}

