/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.control.common.shutdown;

import java.util.Collection;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import org.apache.hyracks.control.common.shutdown.IShutdownStatusConditionVariable;
import org.apache.hyracks.util.Span;

public class ShutdownRun
implements IShutdownStatusConditionVariable {
    private final Set<String> shutdownNodeIds = new TreeSet<String>();
    private boolean ccStopComplete = false;
    private static final long SHUTDOWN_TIMEOUT_SECONDS = 60L;

    public ShutdownRun(Collection<String> nodeIds) {
        this.shutdownNodeIds.addAll(nodeIds);
    }

    public synchronized void notifyShutdown(String nodeId) {
        this.shutdownNodeIds.remove(nodeId);
        if (this.shutdownNodeIds.isEmpty()) {
            this.notifyAll();
        }
    }

    @Override
    public synchronized boolean waitForCompletion() throws Exception {
        Span span = Span.start((long)60L, (TimeUnit)TimeUnit.SECONDS);
        while (!span.elapsed()) {
            if (this.shutdownNodeIds.isEmpty()) {
                return true;
            }
            span.wait((Object)this);
        }
        return false;
    }

    public synchronized Set<String> getRemainingNodes() {
        return this.shutdownNodeIds;
    }

    public synchronized void notifyCcStopComplete() {
        this.ccStopComplete = true;
        this.notifyAll();
    }

    public synchronized boolean waitForCcStopCompletion() throws Exception {
        while (!this.ccStopComplete) {
            this.wait();
        }
        return true;
    }
}

