/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.clienthelper.commands;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import org.apache.asterix.clienthelper.Args;
import org.apache.asterix.clienthelper.commands.ClientCommand;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.apache.commons.io.FilenameUtils;
import org.apache.hyracks.util.file.FileUtil;
import org.mindrot.jbcrypt.BCrypt;

public class GenerateCredentialCommand
extends ClientCommand {
    private static String CREDENTIAL_FILE_NAME = "passwd";

    public GenerateCredentialCommand(Args args) {
        super(args);
    }

    @Override
    public int execute() throws IOException {
        String salt = BCrypt.gensalt((int)12);
        String username = this.args.getUsername();
        String password = this.args.getPassword();
        String passwordHash = BCrypt.hashpw((String)password, (String)salt);
        File passwd = new File(FilenameUtils.normalize((String)FileUtil.joinPath((String[])new String[]{this.args.getCredentialPath(), CREDENTIAL_FILE_NAME})));
        if (!passwd.exists()) {
            passwd.createNewFile();
        }
        try (CSVPrinter p = new CSVPrinter((Appendable)new FileWriter(passwd.getAbsolutePath(), true), CSVFormat.DEFAULT.withDelimiter(':'));){
            p.printRecord(new Object[]{username, passwordHash});
        }
        return 0;
    }
}

