/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.tpcds.row.generator;

import com.google.common.collect.ImmutableMap;
import com.teradata.tpcds.Table;
import com.teradata.tpcds.generator.GeneratorColumn;
import com.teradata.tpcds.random.RandomNumberStream;
import com.teradata.tpcds.random.RandomNumberStreamImpl;
import com.teradata.tpcds.random.RandomValueGenerator;
import com.teradata.tpcds.row.generator.RowGenerator;

public abstract class AbstractRowGenerator
implements RowGenerator {
    private final ImmutableMap<GeneratorColumn, RandomNumberStream> randomNumberStreamMap;

    public AbstractRowGenerator(Table table) {
        ImmutableMap.Builder mapBuilder = ImmutableMap.builder();
        for (GeneratorColumn column : table.getGeneratorColumns()) {
            mapBuilder.put((Object)column, (Object)new RandomNumberStreamImpl(column.getGlobalColumnNumber(), column.getSeedsPerRow()));
        }
        this.randomNumberStreamMap = mapBuilder.build();
    }

    @Override
    public void consumeRemainingSeedsForRow() {
        for (RandomNumberStream randomNumberStream : this.randomNumberStreamMap.values()) {
            while (randomNumberStream.getSeedsUsed() < randomNumberStream.getSeedsPerRow()) {
                RandomValueGenerator.generateUniformRandomInt(1, 100, randomNumberStream);
            }
            randomNumberStream.resetSeedsUsed();
        }
    }

    @Override
    public void skipRowsUntilStartingRowNumber(long startingRowNumber) {
        for (RandomNumberStream randomNumberStream : this.randomNumberStreamMap.values()) {
            randomNumberStream.skipRows((int)startingRowNumber - 1);
        }
    }

    public RandomNumberStream getRandomNumberStream(GeneratorColumn column) {
        return (RandomNumberStream)this.randomNumberStreamMap.get((Object)column);
    }
}

