/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.common.buffercache;

import org.apache.hyracks.storage.common.buffercache.BufferCache;
import org.apache.hyracks.storage.common.buffercache.CachedPage;
import org.apache.hyracks.storage.common.buffercache.ICachedPage;
import org.apache.hyracks.storage.common.buffercache.IFIFOPageWriter;
import org.apache.hyracks.storage.common.buffercache.IPageWriteCallback;
import org.apache.hyracks.storage.common.buffercache.IPageWriteFailureCallback;
import org.apache.hyracks.util.ExitUtil;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FIFOLocalWriter
implements IFIFOPageWriter {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final boolean DEBUG = false;
    private final BufferCache bufferCache;
    private final IPageWriteCallback callback;
    private final IPageWriteFailureCallback failureCallback;

    public FIFOLocalWriter(BufferCache bufferCache, IPageWriteCallback callback, IPageWriteFailureCallback failureCallback) {
        this.bufferCache = bufferCache;
        this.callback = callback;
        this.failureCallback = failureCallback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(ICachedPage page) {
        CachedPage cPage = (CachedPage)page;
        try {
            this.bufferCache.write(cPage);
            this.callback.afterWrite(cPage);
        }
        catch (Exception e) {
            this.handleWriteFailure(page, e);
            LOGGER.warn("Failed to write page {}", (Object)cPage, (Object)e);
        }
        catch (Throwable th) {
            LOGGER.error("FIFOLocalWriter has encountered a fatal error", th);
            ExitUtil.halt((int)1);
        }
        finally {
            this.bufferCache.returnPage(cPage);
        }
    }

    private void handleWriteFailure(ICachedPage page, Exception e) {
        if (this.failureCallback != null) {
            this.failureCallback.writeFailed(page, e);
        } else {
            LOGGER.error("an IO failure took place but the failure callback is not set", (Throwable)e);
        }
    }
}

