/*
 * Decompiled with CFR 0.152.
 */
package rx.subjects;

import java.lang.reflect.Array;
import java.util.ArrayList;
import rx.Observable;
import rx.annotations.Beta;
import rx.exceptions.Exceptions;
import rx.functions.Action1;
import rx.internal.operators.NotificationLite;
import rx.subjects.Subject;
import rx.subjects.SubjectSubscriptionManager;

public final class BehaviorSubject<T>
extends Subject<T, T> {
    private static final Object[] EMPTY_ARRAY = new Object[0];
    private final SubjectSubscriptionManager<T> state;
    private final NotificationLite<T> nl = NotificationLite.instance();

    public static <T> BehaviorSubject<T> create() {
        return BehaviorSubject.create(null, false);
    }

    public static <T> BehaviorSubject<T> create(T defaultValue) {
        return BehaviorSubject.create(defaultValue, true);
    }

    private static <T> BehaviorSubject<T> create(T defaultValue, boolean hasDefault) {
        final SubjectSubscriptionManager state = new SubjectSubscriptionManager();
        if (hasDefault) {
            state.setLatest(NotificationLite.instance().next(defaultValue));
        }
        state.onAdded = new Action1<SubjectSubscriptionManager.SubjectObserver<T>>(){

            @Override
            public void call(SubjectSubscriptionManager.SubjectObserver<T> o) {
                o.emitFirst(state.getLatest(), state.nl);
            }
        };
        state.onTerminated = state.onAdded;
        return new BehaviorSubject(state, state);
    }

    protected BehaviorSubject(Observable.OnSubscribe<T> onSubscribe, SubjectSubscriptionManager<T> state) {
        super(onSubscribe);
        this.state = state;
    }

    @Override
    public void onCompleted() {
        Object last = this.state.getLatest();
        if (last == null || this.state.active) {
            Object n = this.nl.completed();
            for (SubjectSubscriptionManager.SubjectObserver bo : this.state.terminate(n)) {
                bo.emitNext(n, this.state.nl);
            }
        }
    }

    @Override
    public void onError(Throwable e) {
        Object last = this.state.getLatest();
        if (last == null || this.state.active) {
            Object n = this.nl.error(e);
            ArrayList<Throwable> errors = null;
            for (SubjectSubscriptionManager.SubjectObserver bo : this.state.terminate(n)) {
                try {
                    bo.emitNext(n, this.state.nl);
                }
                catch (Throwable e2) {
                    if (errors == null) {
                        errors = new ArrayList<Throwable>();
                    }
                    errors.add(e2);
                }
            }
            Exceptions.throwIfAny(errors);
        }
    }

    @Override
    public void onNext(T v) {
        Object last = this.state.getLatest();
        if (last == null || this.state.active) {
            Object n = this.nl.next(v);
            for (SubjectSubscriptionManager.SubjectObserver bo : this.state.next(n)) {
                bo.emitNext(n, this.state.nl);
            }
        }
    }

    int subscriberCount() {
        return this.state.observers().length;
    }

    @Override
    public boolean hasObservers() {
        return this.state.observers().length > 0;
    }

    @Beta
    public boolean hasValue() {
        Object o = this.state.getLatest();
        return this.nl.isNext(o);
    }

    @Beta
    public boolean hasThrowable() {
        Object o = this.state.getLatest();
        return this.nl.isError(o);
    }

    @Beta
    public boolean hasCompleted() {
        Object o = this.state.getLatest();
        return this.nl.isCompleted(o);
    }

    @Beta
    public T getValue() {
        Object o = this.state.getLatest();
        if (this.nl.isNext(o)) {
            return this.nl.getValue(o);
        }
        return null;
    }

    @Beta
    public Throwable getThrowable() {
        Object o = this.state.getLatest();
        if (this.nl.isError(o)) {
            return this.nl.getError(o);
        }
        return null;
    }

    @Beta
    public T[] getValues(T[] a) {
        Object o = this.state.getLatest();
        if (this.nl.isNext(o)) {
            if (a.length == 0) {
                a = (Object[])Array.newInstance(a.getClass().getComponentType(), 1);
            }
            a[0] = this.nl.getValue(o);
            if (a.length > 1) {
                a[1] = null;
            }
        } else if (a.length > 0) {
            a[0] = null;
        }
        return a;
    }

    @Beta
    public Object[] getValues() {
        Object[] r = this.getValues(EMPTY_ARRAY);
        if (r == EMPTY_ARRAY) {
            return new Object[0];
        }
        return r;
    }
}

