/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.rtree.frames;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.hyracks.api.dataflow.value.IBinaryComparator;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.accessors.IntegerBinaryComparatorFactory;
import org.apache.hyracks.data.std.primitive.IntegerPointable;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.storage.am.common.api.IPrimitiveValueProvider;
import org.apache.hyracks.storage.am.common.api.ITreeIndexFrame;
import org.apache.hyracks.storage.am.common.api.ITreeIndexTupleReference;
import org.apache.hyracks.storage.am.common.api.ITreeIndexTupleWriter;
import org.apache.hyracks.storage.am.common.frames.FrameOpSpaceStatus;
import org.apache.hyracks.storage.am.common.ophelpers.SlotOffTupleOff;
import org.apache.hyracks.storage.am.rtree.api.IRTreeInteriorFrame;
import org.apache.hyracks.storage.am.rtree.frames.RTreeComputationUtils;
import org.apache.hyracks.storage.am.rtree.frames.RTreeNSMFrame;
import org.apache.hyracks.storage.am.rtree.frames.RTreePolicyType;
import org.apache.hyracks.storage.am.rtree.impls.PathList;
import org.apache.hyracks.storage.common.MultiComparator;

public class RTreeNSMInteriorFrame
extends RTreeNSMFrame
implements IRTreeInteriorFrame {
    public static final int childPtrSize = 4;
    private IBinaryComparator childPtrCmp = IntegerBinaryComparatorFactory.INSTANCE.createBinaryComparator();
    private final int keyFieldCount;

    public RTreeNSMInteriorFrame(ITreeIndexTupleWriter tupleWriter, IPrimitiveValueProvider[] keyValueProviders, RTreePolicyType rtreePolicyType, boolean isPointMBR) {
        super(tupleWriter, keyValueProviders, rtreePolicyType, isPointMBR);
        this.keyFieldCount = keyValueProviders.length;
        this.frameTuple.setFieldCount(this.keyFieldCount);
    }

    public int getBytesRequiredToWriteTuple(ITupleReference tuple) {
        return this.tupleWriter.bytesRequired(tuple) + 4 + this.slotManager.getSlotSize();
    }

    @Override
    public int findBestChild(ITupleReference tuple, MultiComparator cmp) throws HyracksDataException {
        int bestChild = this.rtreePolicy.findBestChildPosition(this, tuple, this.frameTuple, cmp);
        this.frameTuple.resetByTupleIndex((ITreeIndexFrame)this, bestChild);
        return this.buf.getInt(this.getChildPointerOff((ITupleReference)this.frameTuple));
    }

    @Override
    public boolean checkIfEnlarementIsNeeded(ITupleReference tuple, MultiComparator cmp) throws HyracksDataException {
        return !RTreeComputationUtils.containsRegion((ITupleReference)this.frameTuple, tuple, cmp, this.keyValueProviders);
    }

    public ITreeIndexTupleReference createTupleReference() {
        ITreeIndexTupleReference tuple = this.tupleWriter.createTupleReference();
        tuple.setFieldCount(this.keyFieldCount);
        return tuple;
    }

    @Override
    public int findTupleByPointer(ITupleReference tuple, MultiComparator cmp) throws HyracksDataException {
        this.frameTuple.setFieldCount(cmp.getKeyFieldCount());
        for (int i = 0; i < this.getTupleCount(); ++i) {
            this.frameTuple.resetByTupleIndex((ITreeIndexFrame)this, i);
            int c = this.pointerCmp((ITupleReference)this.frameTuple, tuple, cmp);
            if (c != 0) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int getChildPageId(int tupleIndex) {
        this.frameTuple.resetByTupleIndex((ITreeIndexFrame)this, tupleIndex);
        return this.buf.getInt(this.getChildPointerOff((ITupleReference)this.frameTuple));
    }

    @Override
    public int getChildPageIdIfIntersect(ITupleReference tuple, int tupleIndex, MultiComparator cmp) throws HyracksDataException {
        this.frameTuple.setFieldCount(cmp.getKeyFieldCount());
        this.frameTuple.resetByTupleIndex((ITreeIndexFrame)this, tupleIndex);
        int maxFieldPos = cmp.getKeyFieldCount() / 2;
        for (int i = 0; i < maxFieldPos; ++i) {
            int j = maxFieldPos + i;
            int c = cmp.getComparators()[i].compare(tuple.getFieldData(i), tuple.getFieldStart(i), tuple.getFieldLength(i), this.frameTuple.getFieldData(j), this.frameTuple.getFieldStart(j), this.frameTuple.getFieldLength(j));
            if (c > 0) {
                return -1;
            }
            c = cmp.getComparators()[i].compare(tuple.getFieldData(j), tuple.getFieldStart(j), tuple.getFieldLength(j), this.frameTuple.getFieldData(i), this.frameTuple.getFieldStart(i), this.frameTuple.getFieldLength(i));
            if (c >= 0) continue;
            return -1;
        }
        return this.buf.getInt(this.getChildPointerOff((ITupleReference)this.frameTuple));
    }

    @Override
    public int findTupleByPointer(ITupleReference tuple, PathList traverseList, int parentIndex, MultiComparator cmp) throws HyracksDataException {
        this.frameTuple.setFieldCount(cmp.getKeyFieldCount());
        for (int i = 0; i < this.getTupleCount(); ++i) {
            this.frameTuple.resetByTupleIndex((ITreeIndexFrame)this, i);
            int c = this.pointerCmp((ITupleReference)this.frameTuple, tuple, cmp);
            if (c == 0) {
                return i;
            }
            int pageId = IntegerPointable.getInteger((byte[])this.frameTuple.getFieldData(cmp.getKeyFieldCount() - 1), (int)this.getChildPointerOff((ITupleReference)this.frameTuple));
            traverseList.add(pageId, -1L, parentIndex);
        }
        return -1;
    }

    public boolean compact() {
        int i;
        this.resetSpaceParams();
        int tupleCount = this.buf.getInt(0);
        int freeSpace = this.buf.getInt(4);
        ArrayList<SlotOffTupleOff> sortedTupleOffs = new ArrayList<SlotOffTupleOff>();
        sortedTupleOffs.ensureCapacity(tupleCount);
        for (i = 0; i < tupleCount; ++i) {
            int slotOff = this.slotManager.getSlotOff(i);
            int tupleOff = this.slotManager.getTupleOff(slotOff);
            sortedTupleOffs.add(new SlotOffTupleOff(i, slotOff, tupleOff));
        }
        Collections.sort(sortedTupleOffs);
        for (i = 0; i < sortedTupleOffs.size(); ++i) {
            int tupleOff = ((SlotOffTupleOff)sortedTupleOffs.get((int)i)).tupleOff;
            this.frameTuple.resetByTupleOffset(this.buf.array(), tupleOff);
            int tupleEndOff = this.frameTuple.getFieldStart(this.frameTuple.getFieldCount() - 1) + this.frameTuple.getFieldLength(this.frameTuple.getFieldCount() - 1);
            int tupleLength = tupleEndOff - tupleOff + 4;
            System.arraycopy(this.buf.array(), tupleOff, this.buf.array(), freeSpace, tupleLength);
            this.slotManager.setSlot(((SlotOffTupleOff)sortedTupleOffs.get((int)i)).slotOff, freeSpace);
            freeSpace += tupleLength;
        }
        this.buf.putInt(4, freeSpace);
        this.buf.putInt(17, this.buf.capacity() - freeSpace - tupleCount * this.slotManager.getSlotSize());
        return false;
    }

    public FrameOpSpaceStatus hasSpaceInsert(ITupleReference tuple) throws HyracksDataException {
        int bytesRequired = this.tupleWriter.bytesRequired(tuple) + 4;
        if (bytesRequired + this.slotManager.getSlotSize() <= this.buf.capacity() - this.buf.getInt(4) - this.buf.getInt(0) * this.slotManager.getSlotSize()) {
            return FrameOpSpaceStatus.SUFFICIENT_CONTIGUOUS_SPACE;
        }
        if (bytesRequired + this.slotManager.getSlotSize() <= this.buf.getInt(17)) {
            return FrameOpSpaceStatus.SUFFICIENT_SPACE;
        }
        return FrameOpSpaceStatus.INSUFFICIENT_SPACE;
    }

    public FrameOpSpaceStatus hasSpaceInsert(int bytesRequired) {
        if (bytesRequired + this.slotManager.getSlotSize() <= this.buf.capacity() - this.buf.getInt(4) - this.buf.getInt(0) * this.slotManager.getSlotSize()) {
            return FrameOpSpaceStatus.SUFFICIENT_CONTIGUOUS_SPACE;
        }
        if (bytesRequired + this.slotManager.getSlotSize() <= this.buf.getInt(17)) {
            return FrameOpSpaceStatus.SUFFICIENT_SPACE;
        }
        return FrameOpSpaceStatus.INSUFFICIENT_SPACE;
    }

    @Override
    public void adjustKey(ITupleReference tuple, int tupleIndex, MultiComparator cmp) throws HyracksDataException {
        this.frameTuple.setFieldCount(cmp.getKeyFieldCount());
        if (tupleIndex == -1) {
            tupleIndex = this.findTupleByPointer(tuple, cmp);
        }
        if (tupleIndex == -1) {
            throw HyracksDataException.create((int)45, (Serializable[])new Serializable[0]);
        }
        this.tupleWriter.writeTuple(tuple, this.buf.array(), this.getTupleOffset(tupleIndex));
    }

    protected int pointerCmp(ITupleReference tupleA, ITupleReference tupleB, MultiComparator cmp) throws HyracksDataException {
        return this.childPtrCmp.compare(tupleA.getFieldData(cmp.getKeyFieldCount() - 1), this.getChildPointerOff(tupleA), 4, tupleB.getFieldData(cmp.getKeyFieldCount() - 1), this.getChildPointerOff(tupleB), 4);
    }

    @Override
    public int getTupleSize(ITupleReference tuple) {
        return this.tupleWriter.bytesRequired(tuple) + 4;
    }

    private int getChildPointerOff(ITupleReference tuple) {
        return tuple.getFieldStart(tuple.getFieldCount() - 1) + tuple.getFieldLength(tuple.getFieldCount() - 1);
    }

    public void insert(ITupleReference tuple, int tupleIndex) {
        this.frameTuple.setFieldCount(tuple.getFieldCount());
        this.slotManager.insertSlot(-1, this.buf.getInt(4));
        int freeSpace = this.buf.getInt(4);
        int bytesWritten = this.tupleWriter.writeTupleFields(tuple, 0, tuple.getFieldCount(), this.buf.array(), freeSpace);
        System.arraycopy(tuple.getFieldData(tuple.getFieldCount() - 1), this.getChildPointerOff(tuple), this.buf.array(), freeSpace + bytesWritten, 4);
        int tupleSize = bytesWritten + 4;
        this.buf.putInt(0, this.buf.getInt(0) + 1);
        this.buf.putInt(4, this.buf.getInt(4) + tupleSize);
        this.buf.putInt(17, this.buf.getInt(17) - tupleSize - this.slotManager.getSlotSize());
    }

    @Override
    public void delete(int tupleIndex, MultiComparator cmp) {
        this.frameTuple.setFieldCount(cmp.getKeyFieldCount());
        int slotOff = this.slotManager.getSlotOff(tupleIndex);
        int tupleOff = this.slotManager.getTupleOff(slotOff);
        this.frameTuple.resetByTupleOffset(this.buf.array(), tupleOff);
        int tupleSize = this.tupleWriter.bytesRequired((ITupleReference)this.frameTuple);
        int slotStartOff = this.slotManager.getSlotEndOff();
        int length = slotOff - slotStartOff;
        System.arraycopy(this.buf.array(), slotStartOff, this.buf.array(), slotStartOff + this.slotManager.getSlotSize(), length);
        this.buf.putInt(0, this.buf.getInt(0) - 1);
        this.buf.putInt(17, this.buf.getInt(17) + tupleSize + 4 + this.slotManager.getSlotSize());
    }

    @Override
    public void enlarge(ITupleReference tuple, MultiComparator cmp) throws HyracksDataException {
        int maxFieldPos = cmp.getKeyFieldCount() / 2;
        for (int i = 0; i < maxFieldPos; ++i) {
            int j = maxFieldPos + i;
            int c = cmp.getComparators()[i].compare(this.frameTuple.getFieldData(i), this.frameTuple.getFieldStart(i), this.frameTuple.getFieldLength(i), tuple.getFieldData(i), tuple.getFieldStart(i), tuple.getFieldLength(i));
            if (c > 0) {
                System.arraycopy(tuple.getFieldData(i), tuple.getFieldStart(i), this.frameTuple.getFieldData(i), this.frameTuple.getFieldStart(i), tuple.getFieldLength(i));
            }
            if ((c = cmp.getComparators()[j].compare(this.frameTuple.getFieldData(j), this.frameTuple.getFieldStart(j), this.frameTuple.getFieldLength(j), tuple.getFieldData(j), tuple.getFieldStart(j), tuple.getFieldLength(j))) >= 0) continue;
            System.arraycopy(tuple.getFieldData(j), tuple.getFieldStart(j), this.frameTuple.getFieldData(j), this.frameTuple.getFieldStart(j), tuple.getFieldLength(j));
        }
    }

    public ArrayList<Integer> getChildren(MultiComparator cmp) {
        ArrayList<Integer> ret = new ArrayList<Integer>();
        this.frameTuple.setFieldCount(cmp.getKeyFieldCount());
        int tupleCount = this.buf.getInt(0);
        for (int i = 0; i < tupleCount; ++i) {
            int tupleOff = this.slotManager.getTupleOff(this.slotManager.getSlotOff(i));
            this.frameTuple.resetByTupleOffset(this.buf.array(), tupleOff);
            int intVal = IntegerPointable.getInteger((byte[])this.buf.array(), (int)(this.frameTuple.getFieldStart(this.frameTuple.getFieldCount() - 1) + this.frameTuple.getFieldLength(this.frameTuple.getFieldCount() - 1)));
            ret.add(intVal);
        }
        return ret;
    }

    @Override
    public int getFieldCount() {
        return this.keyValueProviders.length;
    }

    public int getChildPointerSize() {
        return 4;
    }
}

