/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.rtree.frames;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.HashMap;
import java.util.Map;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.IJsonSerializable;
import org.apache.hyracks.api.io.IPersistedResourceRegistry;

public enum RTreePolicyType implements IJsonSerializable
{
    RTREE("RTREE"),
    RSTARTREE("RSTARTREE");

    private static final Map<String, RTreePolicyType> namesMap;
    private static final long serialVersionUID = 1L;
    private final String type;

    private RTreePolicyType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public JsonNode toJson(IPersistedResourceRegistry registry) throws HyracksDataException {
        ObjectNode json = registry.getClassIdentifier(this.getDeclaringClass(), 1L);
        json.put("type", this.getType());
        return json;
    }

    public static IJsonSerializable fromJson(IPersistedResourceRegistry registry, JsonNode json) {
        return namesMap.get(json.get("type").asText());
    }

    static {
        namesMap = new HashMap<String, RTreePolicyType>(2);
        namesMap.put("RTREE", RTREE);
        namesMap.put("RSTARTREE", RSTARTREE);
    }
}

