/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security.ssl;

import java.io.IOException;
import java.util.ArrayList;
import javax.net.ssl.SSLEngine;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.mortbay.jetty.security.SslSelectChannelConnector;

@InterfaceAudience.Private
public class SslSelectChannelConnectorSecure
extends SslSelectChannelConnector {
    public static final Log LOG = LogFactory.getLog(SslSelectChannelConnectorSecure.class);

    protected SSLEngine createSSLEngine() throws IOException {
        SSLEngine engine = super.createSSLEngine();
        ArrayList<String> nonSSLProtocols = new ArrayList<String>();
        for (String p : engine.getEnabledProtocols()) {
            if (p.contains("SSLv3")) continue;
            nonSSLProtocols.add(p);
        }
        engine.setEnabledProtocols(nonSSLProtocols.toArray(new String[nonSSLProtocols.size()]));
        return engine;
    }

    public boolean isRunning() {
        if (super.isRunning()) {
            return true;
        }
        LOG.warn((Object)"HttpServer Acceptor: isRunning is false. Rechecking.");
        try {
            Thread.sleep(10L);
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
        }
        boolean runState = super.isRunning();
        LOG.warn((Object)("HttpServer Acceptor: isRunning is " + runState));
        return runState;
    }
}

