/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.translator;

import java.io.Serializable;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Deque;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.asterix.algebra.base.ILangExpressionToPlanTranslator;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.common.functions.FunctionSignature;
import org.apache.asterix.lang.common.base.AbstractClause;
import org.apache.asterix.lang.common.base.AbstractExpression;
import org.apache.asterix.lang.common.base.Clause;
import org.apache.asterix.lang.common.base.Expression;
import org.apache.asterix.lang.common.base.ILangExpression;
import org.apache.asterix.lang.common.base.Literal;
import org.apache.asterix.lang.common.clause.GroupbyClause;
import org.apache.asterix.lang.common.clause.LetClause;
import org.apache.asterix.lang.common.clause.OrderbyClause;
import org.apache.asterix.lang.common.expression.CallExpr;
import org.apache.asterix.lang.common.expression.FieldBinding;
import org.apache.asterix.lang.common.expression.GbyVariableExpressionPair;
import org.apache.asterix.lang.common.expression.ListConstructor;
import org.apache.asterix.lang.common.expression.LiteralExpr;
import org.apache.asterix.lang.common.expression.OperatorExpr;
import org.apache.asterix.lang.common.expression.QuantifiedExpression;
import org.apache.asterix.lang.common.expression.RecordConstructor;
import org.apache.asterix.lang.common.expression.VariableExpr;
import org.apache.asterix.lang.common.literal.IntegerLiteral;
import org.apache.asterix.lang.common.literal.StringLiteral;
import org.apache.asterix.lang.common.statement.Query;
import org.apache.asterix.lang.common.struct.OperatorType;
import org.apache.asterix.lang.common.struct.QuantifiedPair;
import org.apache.asterix.lang.common.struct.VarIdentifier;
import org.apache.asterix.lang.common.util.FunctionUtil;
import org.apache.asterix.lang.common.visitor.base.ILangVisitor;
import org.apache.asterix.lang.sqlpp.clause.AbstractBinaryCorrelateClause;
import org.apache.asterix.lang.sqlpp.clause.FromClause;
import org.apache.asterix.lang.sqlpp.clause.FromTerm;
import org.apache.asterix.lang.sqlpp.clause.HavingClause;
import org.apache.asterix.lang.sqlpp.clause.JoinClause;
import org.apache.asterix.lang.sqlpp.clause.NestClause;
import org.apache.asterix.lang.sqlpp.clause.Projection;
import org.apache.asterix.lang.sqlpp.clause.SelectBlock;
import org.apache.asterix.lang.sqlpp.clause.SelectClause;
import org.apache.asterix.lang.sqlpp.clause.SelectElement;
import org.apache.asterix.lang.sqlpp.clause.SelectRegular;
import org.apache.asterix.lang.sqlpp.clause.SelectSetOperation;
import org.apache.asterix.lang.sqlpp.clause.UnnestClause;
import org.apache.asterix.lang.sqlpp.expression.CaseExpression;
import org.apache.asterix.lang.sqlpp.expression.SelectExpression;
import org.apache.asterix.lang.sqlpp.expression.WindowExpression;
import org.apache.asterix.lang.sqlpp.optype.JoinType;
import org.apache.asterix.lang.sqlpp.optype.SetOpType;
import org.apache.asterix.lang.sqlpp.struct.SetOperationInput;
import org.apache.asterix.lang.sqlpp.struct.SetOperationRight;
import org.apache.asterix.lang.sqlpp.util.SqlppRewriteUtil;
import org.apache.asterix.lang.sqlpp.util.SqlppVariableUtil;
import org.apache.asterix.lang.sqlpp.visitor.base.ISqlppVisitor;
import org.apache.asterix.metadata.declared.MetadataProvider;
import org.apache.asterix.om.base.ABoolean;
import org.apache.asterix.om.base.AInt32;
import org.apache.asterix.om.base.AString;
import org.apache.asterix.om.base.IACollection;
import org.apache.asterix.om.base.IACursor;
import org.apache.asterix.om.base.IAObject;
import org.apache.asterix.om.constants.AsterixConstantValue;
import org.apache.asterix.om.functions.BuiltinFunctionInfo;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.typecomputer.base.TypeCastUtils;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.translator.ConstantHelper;
import org.apache.asterix.translator.LangExpressionToPlanTranslator;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.common.utils.ListSet;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.algebricks.common.utils.Triple;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalExpressionTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.expressions.AbstractFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.AggregateFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.ConstantExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.IAlgebricksConstantValue;
import org.apache.hyracks.algebricks.core.algebra.expressions.IExpressionAnnotation;
import org.apache.hyracks.algebricks.core.algebra.expressions.ScalarFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.UnnestingFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.VariableReferenceExpression;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.core.algebra.functions.IFunctionInfo;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractUnnestNonMapOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AggregateOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AssignOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.DistinctOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.InnerJoinOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.LeftOuterUnnestOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.NestedTupleSourceOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.OrderOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.ProjectOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.SelectOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.SubplanOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.UnnestOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.WindowOperator;
import org.apache.hyracks.algebricks.core.algebra.plan.ALogicalPlanImpl;
import org.apache.hyracks.algebricks.core.algebra.util.OperatorManipulationUtil;
import org.apache.hyracks.api.exceptions.SourceLocation;

public class SqlppExpressionToPlanTranslator
extends LangExpressionToPlanTranslator
implements ILangExpressionToPlanTranslator,
ISqlppVisitor<Pair<ILogicalOperator, LogicalVariable>, Mutable<ILogicalOperator>> {
    private static final String ERR_MSG = "Translator should never enter this method!";
    public static final String REWRITE_IN_AS_OR_OPTION = "rewrite_in_as_or";
    private static final boolean REWRITE_IN_AS_OR_OPTION_DEFAULT = true;
    private Deque<Mutable<ILogicalOperator>> uncorrelatedRightBranchStack = new ArrayDeque<Mutable<ILogicalOperator>>();
    private final Map<VarIdentifier, IAObject> externalVars;
    private final boolean translateInAsOr;

    public SqlppExpressionToPlanTranslator(MetadataProvider metadataProvider, int currentVarCounter, Map<VarIdentifier, IAObject> externalVars) throws AlgebricksException {
        super(metadataProvider, currentVarCounter);
        this.externalVars = externalVars != null ? externalVars : Collections.emptyMap();
        this.translateInAsOr = metadataProvider.getBooleanProperty(REWRITE_IN_AS_OR_OPTION, true);
    }

    @Override
    public Pair<ILogicalOperator, LogicalVariable> visit(Query q, Mutable<ILogicalOperator> tupSource) throws CompilationException {
        Expression queryBody = q.getBody();
        SourceLocation sourceLoc = queryBody.getSourceLocation();
        if (queryBody.getKind() == Expression.Kind.SELECT_EXPRESSION) {
            SelectExpression selectExpr = (SelectExpression)queryBody;
            if (q.isTopLevel()) {
                selectExpr.setSubquery(false);
            }
            return (Pair)queryBody.accept((ILangVisitor)this, tupSource);
        }
        LogicalVariable var = this.context.newVar();
        Pair<ILogicalExpression, Mutable<ILogicalOperator>> eo = this.langExprToAlgExpression(queryBody, tupSource);
        AssignOperator assignOp = new AssignOperator(var, (Mutable)new MutableObject(eo.first));
        assignOp.getInputs().add(eo.second);
        assignOp.setSourceLocation(sourceLoc);
        ProjectOperator projectOp = new ProjectOperator(var);
        projectOp.getInputs().add(new MutableObject((Object)assignOp));
        projectOp.setSourceLocation(sourceLoc);
        return new Pair((Object)projectOp, (Object)var);
    }

    public Pair<ILogicalOperator, LogicalVariable> visit(SelectExpression selectExpression, Mutable<ILogicalOperator> tupSource) throws CompilationException {
        if (selectExpression.isSubquery()) {
            this.context.enterSubplan();
        }
        MutableObject currentOpRef = tupSource;
        if (selectExpression.hasLetClauses()) {
            for (LetClause letClause : selectExpression.getLetList()) {
                currentOpRef = new MutableObject(((Pair)letClause.accept((ILangVisitor)this, (Object)currentOpRef)).first);
            }
        }
        Pair select = (Pair)selectExpression.getSelectSetOperation().accept((ILangVisitor)this, currentOpRef);
        currentOpRef = new MutableObject(select.first);
        if (selectExpression.hasOrderby()) {
            currentOpRef = new MutableObject(((Pair)selectExpression.getOrderbyClause().accept((ILangVisitor)this, (Object)currentOpRef)).first);
        }
        if (selectExpression.hasLimit()) {
            currentOpRef = new MutableObject(((Pair)selectExpression.getLimitClause().accept((ILangVisitor)this, (Object)currentOpRef)).first);
        }
        Pair<ILogicalOperator, LogicalVariable> result = this.produceSelectPlan(selectExpression.isSubquery(), (Mutable<ILogicalOperator>)currentOpRef, (LogicalVariable)select.second);
        if (selectExpression.isSubquery()) {
            this.context.exitSubplan();
        }
        return result;
    }

    public Pair<ILogicalOperator, LogicalVariable> visit(SelectSetOperation selectSetOperation, Mutable<ILogicalOperator> tupSource) throws CompilationException {
        SelectExpression leftInputExpr;
        SetOperationInput leftInput = selectSetOperation.getLeftInput();
        if (!selectSetOperation.hasRightInputs()) {
            return (Pair)leftInput.accept((ILangVisitor)this, tupSource);
        }
        ArrayList<ILangExpression> inputExprs = new ArrayList<ILangExpression>();
        if (leftInput.selectBlock()) {
            leftInputExpr = new SelectExpression(null, new SelectSetOperation(leftInput, null), null, null, true);
            leftInputExpr.setSourceLocation(leftInput.getSelectBlock().getSourceLocation());
        } else {
            leftInputExpr = leftInput.getSubquery();
        }
        inputExprs.add((ILangExpression)leftInputExpr);
        for (SetOperationRight setOperationRight : selectSetOperation.getRightInputs()) {
            SelectExpression rightInputExpr;
            SetOpType setOpType = setOperationRight.getSetOpType();
            if (setOpType != SetOpType.UNION || setOperationRight.isSetSemantics()) {
                throw new CompilationException(1079, selectSetOperation.getSourceLocation(), new Serializable[]{"Operation " + setOpType + (setOperationRight.isSetSemantics() ? " with set semantics" : "ALL") + " is not supported."});
            }
            SetOperationInput rightInput = setOperationRight.getSetOperationRightInput();
            if (rightInput.selectBlock()) {
                rightInputExpr = new SelectExpression(null, new SelectSetOperation(rightInput, null), null, null, true);
                rightInputExpr.setSourceLocation(rightInput.getSelectBlock().getSourceLocation());
            } else {
                rightInputExpr = rightInput.getSubquery();
            }
            inputExprs.add((ILangExpression)rightInputExpr);
        }
        return this.translateUnionAllFromInputExprs(inputExprs, tupSource, selectSetOperation.getSourceLocation());
    }

    public Pair<ILogicalOperator, LogicalVariable> visit(SelectBlock selectBlock, Mutable<ILogicalOperator> tupSource) throws CompilationException {
        MutableObject currentOpRef = tupSource;
        if (selectBlock.hasGroupbyClause() && selectBlock.getGroupbyClause().isGroupAll()) {
            SourceLocation sourceLoc = selectBlock.getSourceLocation();
            SubplanOperator subplanOp = new SubplanOperator();
            subplanOp.getInputs().add(currentOpRef);
            subplanOp.setSourceLocation(sourceLoc);
            NestedTupleSourceOperator ntsOp = new NestedTupleSourceOperator((Mutable)new MutableObject((Object)subplanOp));
            ntsOp.setSourceLocation(sourceLoc);
            Mutable<ILogicalOperator> subplanCurrentOpRef = new Mutable<ILogicalOperator>((Object)ntsOp);
            subplanCurrentOpRef = this.translateFromLetWhereGroupBy(selectBlock, subplanCurrentOpRef);
            subplanOp.getNestedPlans().add(new ALogicalPlanImpl(subplanCurrentOpRef));
            currentOpRef = new MutableObject((Object)subplanOp);
        } else {
            currentOpRef = this.translateFromLetWhereGroupBy(selectBlock, (Mutable<ILogicalOperator>)currentOpRef);
        }
        if (selectBlock.hasLetHavingClausesAfterGroupby()) {
            for (AbstractClause letHavingClause : selectBlock.getLetHavingListAfterGroupby()) {
                currentOpRef = new MutableObject(((Pair)letHavingClause.accept((ILangVisitor)this, currentOpRef)).first);
            }
        }
        return this.processSelectClause(selectBlock, (Mutable<ILogicalOperator>)currentOpRef);
    }

    private Mutable<ILogicalOperator> translateFromLetWhereGroupBy(SelectBlock selectBlock, Mutable<ILogicalOperator> currentOpRef) throws CompilationException {
        if (selectBlock.hasFromClause()) {
            currentOpRef = new MutableObject(((Pair)selectBlock.getFromClause().accept((ILangVisitor)this, currentOpRef)).first);
        }
        if (selectBlock.hasLetWhereClauses()) {
            for (AbstractClause letWhereClause : selectBlock.getLetWhereList()) {
                currentOpRef = new MutableObject(((Pair)letWhereClause.accept((ILangVisitor)this, (Object)currentOpRef)).first);
            }
        }
        if (selectBlock.hasGroupbyClause()) {
            currentOpRef = new MutableObject(((Pair)selectBlock.getGroupbyClause().accept((ILangVisitor)this, (Object)currentOpRef)).first);
        }
        return currentOpRef;
    }

    public Pair<ILogicalOperator, LogicalVariable> visit(FromClause fromClause, Mutable<ILogicalOperator> arg) throws CompilationException {
        MutableObject inputSrc = arg;
        Pair topUnnest = null;
        this.uncorrelatedRightBranchStack.push((Mutable<ILogicalOperator>)inputSrc);
        for (FromTerm fromTerm : fromClause.getFromTerms()) {
            topUnnest = (Pair)fromTerm.accept((ILangVisitor)this, inputSrc);
            inputSrc = new MutableObject(topUnnest.first);
        }
        this.uncorrelatedRightBranchStack.pop();
        return topUnnest;
    }

    public Pair<ILogicalOperator, LogicalVariable> visit(FromTerm fromTerm, Mutable<ILogicalOperator> tupSource) throws CompilationException {
        UnnestOperator unnestOp;
        SourceLocation sourceLoc = fromTerm.getSourceLocation();
        LogicalVariable fromVar = this.context.newVarFromExpression((Expression)fromTerm.getLeftVariable());
        Expression fromExpr = fromTerm.getLeftExpression();
        Pair<ILogicalExpression, Mutable<ILogicalOperator>> eo = this.langExprToAlgExpression(fromExpr, tupSource);
        Pair<ILogicalExpression, Mutable<ILogicalOperator>> pUnnestExpr = this.makeUnnestExpression((ILogicalExpression)eo.first, (Mutable<ILogicalOperator>)((Mutable)eo.second));
        if (fromTerm.hasPositionalVariable()) {
            LogicalVariable pVar = this.context.newVarFromExpression((Expression)fromTerm.getPositionalVariable());
            unnestOp = new UnnestOperator(fromVar, (Mutable)new MutableObject(pUnnestExpr.first), pVar, (Object)BuiltinType.AINT64);
        } else {
            unnestOp = new UnnestOperator(fromVar, (Mutable)new MutableObject(pUnnestExpr.first));
        }
        unnestOp.getInputs().add(pUnnestExpr.second);
        unnestOp.setSourceLocation(sourceLoc);
        MutableObject topOpRef = new MutableObject((Object)unnestOp);
        if (fromTerm.hasCorrelateClauses()) {
            for (AbstractBinaryCorrelateClause correlateClause : fromTerm.getCorrelateClauses()) {
                topOpRef = new MutableObject(((Pair)correlateClause.accept((ILangVisitor)this, (Object)topOpRef)).first);
            }
        }
        return new Pair(topOpRef.getValue(), (Object)fromVar);
    }

    public Pair<ILogicalOperator, LogicalVariable> visit(JoinClause joinClause, Mutable<ILogicalOperator> leftInputRef) throws CompilationException {
        SourceLocation sourceLoc = joinClause.getSourceLocation();
        if (joinClause.getJoinType() == JoinType.INNER) {
            Mutable<ILogicalOperator> rightInputRef = this.uncorrelatedRightBranchStack.peek();
            Pair<ILogicalOperator, LogicalVariable> rightBranch = this.generateUnnestForBinaryCorrelateRightBranch((AbstractBinaryCorrelateClause)joinClause, rightInputRef, true);
            InnerJoinOperator joinOperator = new InnerJoinOperator((Mutable)new MutableObject((Object)ConstantExpression.TRUE), leftInputRef, (Mutable)new MutableObject(rightBranch.first));
            joinOperator.setSourceLocation(sourceLoc);
            MutableObject joinOpRef = new MutableObject((Object)joinOperator);
            Pair<ILogicalExpression, Mutable<ILogicalOperator>> conditionExprOpPair = this.langExprToAlgExpression(joinClause.getConditionExpression(), (Mutable<ILogicalOperator>)joinOpRef);
            SelectOperator filter = new SelectOperator((Mutable)new MutableObject(conditionExprOpPair.first), false, null);
            filter.getInputs().add(conditionExprOpPair.second);
            filter.setSourceLocation(((ILogicalExpression)conditionExprOpPair.first).getSourceLocation());
            return new Pair((Object)filter, rightBranch.second);
        }
        if (joinClause.getJoinType() == JoinType.LEFTOUTER) {
            LogicalVariable varToListify;
            boolean hasRightPosVar;
            SubplanOperator subplanOp = new SubplanOperator();
            subplanOp.getInputs().add(leftInputRef);
            subplanOp.setSourceLocation(sourceLoc);
            NestedTupleSourceOperator ntsOp = new NestedTupleSourceOperator((Mutable)new MutableObject((Object)subplanOp));
            ntsOp.setSourceLocation(sourceLoc);
            MutableObject ntsRef = new MutableObject((Object)ntsOp);
            this.context.enterSubplan();
            Pair<ILogicalOperator, LogicalVariable> rightBranch = this.generateUnnestForBinaryCorrelateRightBranch((AbstractBinaryCorrelateClause)joinClause, (Mutable<ILogicalOperator>)ntsRef, true);
            AbstractUnnestNonMapOperator rightUnnestOp = (AbstractUnnestNonMapOperator)rightBranch.first;
            Pair<ILogicalExpression, Mutable<ILogicalOperator>> conditionExprOpPair = this.langExprToAlgExpression(joinClause.getConditionExpression(), (Mutable<ILogicalOperator>)new MutableObject((Object)rightUnnestOp));
            SelectOperator filter = new SelectOperator((Mutable)new MutableObject(conditionExprOpPair.first), false, null);
            filter.getInputs().add(conditionExprOpPair.second);
            filter.setSourceLocation(((ILogicalExpression)conditionExprOpPair.first).getSourceLocation());
            SelectOperator currentTopOp = filter;
            boolean bl = hasRightPosVar = rightUnnestOp.getPositionalVariable() != null;
            if (hasRightPosVar) {
                VariableReferenceExpression rightUnnestVarRef = new VariableReferenceExpression(rightUnnestOp.getVariable());
                rightUnnestVarRef.setSourceLocation(joinClause.getRightVariable().getSourceLocation());
                VariableReferenceExpression rightUnnestPosVarRef = new VariableReferenceExpression(rightUnnestOp.getPositionalVariable());
                rightUnnestPosVarRef.setSourceLocation(joinClause.getPositionalVariable().getSourceLocation());
                ScalarFunctionCallExpression recordCreationFunc = new ScalarFunctionCallExpression((IFunctionInfo)FunctionUtil.getFunctionInfo((FunctionIdentifier)BuiltinFunctions.CLOSED_RECORD_CONSTRUCTOR), new Mutable[]{new MutableObject((Object)new ConstantExpression((IAlgebricksConstantValue)new AsterixConstantValue((IAObject)new AString("unnestvar")))), new MutableObject((Object)rightUnnestVarRef), new MutableObject((Object)new ConstantExpression((IAlgebricksConstantValue)new AsterixConstantValue((IAObject)new AString("posvar")))), new MutableObject((Object)rightUnnestPosVarRef)});
                recordCreationFunc.setSourceLocation(joinClause.getRightVariable().getSourceLocation());
                LogicalVariable recordVar = this.context.newVar();
                AssignOperator assignOp = new AssignOperator(recordVar, (Mutable)new MutableObject((Object)recordCreationFunc));
                assignOp.getInputs().add(new MutableObject((Object)currentTopOp));
                assignOp.setSourceLocation(joinClause.getRightVariable().getSourceLocation());
                currentTopOp = assignOp;
                varToListify = recordVar;
            } else {
                varToListify = rightUnnestOp.getVariable();
            }
            VariableReferenceExpression varToListifyRef = new VariableReferenceExpression(varToListify);
            varToListifyRef.setSourceLocation(currentTopOp.getSourceLocation());
            AggregateFunctionCallExpression fListify = BuiltinFunctions.makeAggregateFunctionExpression((FunctionIdentifier)BuiltinFunctions.LISTIFY, this.mkSingletonArrayList(new MutableObject((Object)varToListifyRef)));
            fListify.setSourceLocation(currentTopOp.getSourceLocation());
            LogicalVariable aggVar = this.context.newSubplanOutputVar();
            AggregateOperator aggOp = new AggregateOperator(this.mkSingletonArrayList(aggVar), this.mkSingletonArrayList(new MutableObject((Object)fListify)));
            aggOp.getInputs().add(new MutableObject((Object)currentTopOp));
            aggOp.setSourceLocation(fListify.getSourceLocation());
            this.context.exitSubplan();
            ALogicalPlanImpl subplan = new ALogicalPlanImpl((Mutable)new MutableObject((Object)aggOp));
            subplanOp.getNestedPlans().add(subplan);
            LogicalVariable outerUnnestVar = this.context.newVar();
            VariableReferenceExpression aggVarRefExpr = new VariableReferenceExpression(aggVar);
            aggVarRefExpr.setSourceLocation(aggOp.getSourceLocation());
            Pair<ILogicalExpression, Mutable<ILogicalOperator>> pUnnestExpr = this.makeUnnestExpression((ILogicalExpression)aggVarRefExpr, (Mutable<ILogicalOperator>)new MutableObject((Object)subplanOp));
            LeftOuterUnnestOperator outerUnnestOp = new LeftOuterUnnestOperator(outerUnnestVar, (Mutable)new MutableObject(pUnnestExpr.first));
            outerUnnestOp.getInputs().add(pUnnestExpr.second);
            outerUnnestOp.setSourceLocation(aggOp.getSourceLocation());
            currentTopOp = outerUnnestOp;
            if (hasRightPosVar) {
                VariableReferenceExpression outerUnnestVarRef1 = new VariableReferenceExpression(outerUnnestVar);
                outerUnnestVarRef1.setSourceLocation(joinClause.getRightVariable().getSourceLocation());
                ScalarFunctionCallExpression fieldAccessForRightUnnestVar = new ScalarFunctionCallExpression((IFunctionInfo)FunctionUtil.getFunctionInfo((FunctionIdentifier)BuiltinFunctions.FIELD_ACCESS_BY_INDEX), new Mutable[]{new MutableObject((Object)outerUnnestVarRef1), new MutableObject((Object)new ConstantExpression((IAlgebricksConstantValue)new AsterixConstantValue((IAObject)new AInt32(0))))});
                fieldAccessForRightUnnestVar.setSourceLocation(joinClause.getRightVariable().getSourceLocation());
                VariableReferenceExpression outerUnnestVarRef2 = new VariableReferenceExpression(outerUnnestVar);
                outerUnnestVarRef2.setSourceLocation(joinClause.getPositionalVariable().getSourceLocation());
                ScalarFunctionCallExpression fieldAccessForRightPosVar = new ScalarFunctionCallExpression((IFunctionInfo)FunctionUtil.getFunctionInfo((FunctionIdentifier)BuiltinFunctions.FIELD_ACCESS_BY_INDEX), new Mutable[]{new MutableObject((Object)outerUnnestVarRef2), new MutableObject((Object)new ConstantExpression((IAlgebricksConstantValue)new AsterixConstantValue((IAObject)new AInt32(1))))});
                fieldAccessForRightPosVar.setSourceLocation(joinClause.getPositionalVariable().getSourceLocation());
                LogicalVariable rightUnnestVar = this.context.newVar();
                LogicalVariable rightPosVar = this.context.newVar();
                this.context.setVar(joinClause.getRightVariable(), rightUnnestVar);
                this.context.setVar(joinClause.getPositionalVariable(), rightPosVar);
                ArrayList<LogicalVariable> assignVars = new ArrayList<LogicalVariable>();
                assignVars.add(rightUnnestVar);
                assignVars.add(rightPosVar);
                ArrayList<MutableObject> assignExprs = new ArrayList<MutableObject>();
                assignExprs.add(new MutableObject((Object)fieldAccessForRightUnnestVar));
                assignExprs.add(new MutableObject((Object)fieldAccessForRightPosVar));
                AssignOperator assignOp = new AssignOperator(assignVars, assignExprs);
                assignOp.getInputs().add(new MutableObject((Object)currentTopOp));
                assignOp.setSourceLocation(joinClause.getRightVariable().getSourceLocation());
                currentTopOp = assignOp;
            } else {
                this.context.setVar(joinClause.getRightVariable(), outerUnnestVar);
            }
            return new Pair((Object)currentTopOp, null);
        }
        throw new CompilationException(1038, joinClause.getSourceLocation(), new Serializable[]{String.valueOf(joinClause.getJoinType().toString())});
    }

    public Pair<ILogicalOperator, LogicalVariable> visit(NestClause nestClause, Mutable<ILogicalOperator> arg) throws CompilationException {
        throw new CompilationException(1079, nestClause.getSourceLocation(), new Serializable[]{"Nest clause has not been implemented"});
    }

    public Pair<ILogicalOperator, LogicalVariable> visit(UnnestClause unnestClause, Mutable<ILogicalOperator> inputOpRef) throws CompilationException {
        return this.generateUnnestForBinaryCorrelateRightBranch((AbstractBinaryCorrelateClause)unnestClause, inputOpRef, unnestClause.getJoinType() == JoinType.INNER);
    }

    public Pair<ILogicalOperator, LogicalVariable> visit(HavingClause havingClause, Mutable<ILogicalOperator> tupSource) throws CompilationException {
        Pair<ILogicalExpression, Mutable<ILogicalOperator>> p = this.langExprToAlgExpression(havingClause.getFilterExpression(), tupSource);
        SelectOperator s = new SelectOperator((Mutable)new MutableObject(p.first), false, null);
        s.getInputs().add(p.second);
        return new Pair((Object)s, null);
    }

    private Pair<ILogicalOperator, LogicalVariable> generateUnnestForBinaryCorrelateRightBranch(AbstractBinaryCorrelateClause binaryCorrelate, Mutable<ILogicalOperator> inputOpRef, boolean innerUnnest) throws CompilationException {
        UnnestOperator unnestOp;
        LogicalVariable rightVar = this.context.newVarFromExpression((Expression)binaryCorrelate.getRightVariable());
        Expression rightExpr = binaryCorrelate.getRightExpression();
        Pair<ILogicalExpression, Mutable<ILogicalOperator>> eo = this.langExprToAlgExpression(rightExpr, inputOpRef);
        Pair<ILogicalExpression, Mutable<ILogicalOperator>> pUnnestExpr = this.makeUnnestExpression((ILogicalExpression)eo.first, (Mutable<ILogicalOperator>)((Mutable)eo.second));
        if (binaryCorrelate.hasPositionalVariable()) {
            LogicalVariable pVar = this.context.newVarFromExpression((Expression)binaryCorrelate.getPositionalVariable());
            unnestOp = innerUnnest ? new UnnestOperator(rightVar, (Mutable)new MutableObject(pUnnestExpr.first), pVar, (Object)BuiltinType.AINT64) : new LeftOuterUnnestOperator(rightVar, (Mutable)new MutableObject(pUnnestExpr.first), pVar, (Object)BuiltinType.AINT64);
        } else {
            unnestOp = innerUnnest ? new UnnestOperator(rightVar, (Mutable)new MutableObject(pUnnestExpr.first)) : new LeftOuterUnnestOperator(rightVar, (Mutable)new MutableObject(pUnnestExpr.first));
        }
        unnestOp.getInputs().add(pUnnestExpr.second);
        unnestOp.setSourceLocation(binaryCorrelate.getRightVariable().getSourceLocation());
        return new Pair((Object)unnestOp, (Object)rightVar);
    }

    public Pair<ILogicalOperator, LogicalVariable> visit(SelectClause selectClause, Mutable<ILogicalOperator> tupSrc) throws CompilationException {
        throw new UnsupportedOperationException(ERR_MSG);
    }

    public Pair<ILogicalOperator, LogicalVariable> visit(SelectElement selectElement, Mutable<ILogicalOperator> arg) throws CompilationException {
        throw new UnsupportedOperationException(ERR_MSG);
    }

    public Pair<ILogicalOperator, LogicalVariable> visit(SelectRegular selectRegular, Mutable<ILogicalOperator> arg) throws CompilationException {
        throw new UnsupportedOperationException(ERR_MSG);
    }

    public Pair<ILogicalOperator, LogicalVariable> visit(Projection projection, Mutable<ILogicalOperator> arg) throws CompilationException {
        throw new UnsupportedOperationException(ERR_MSG);
    }

    public Pair<ILogicalOperator, LogicalVariable> visit(CaseExpression caseExpression, Mutable<ILogicalOperator> tupSource) throws CompilationException {
        MutableObject currentOpRef = tupSource;
        ILogicalOperator currentOperator = null;
        List whenExprList = caseExpression.getWhenExprs();
        List thenExprList = caseExpression.getThenExprs();
        ArrayList<ILogicalExpression> branchCondVarReferences = new ArrayList<ILogicalExpression>();
        ArrayList<VariableReferenceExpression> allVarReferences = new ArrayList<VariableReferenceExpression>();
        for (int index = 0; index < whenExprList.size(); ++index) {
            Expression whenExpr = (Expression)whenExprList.get(index);
            Pair whenExprResult = (Pair)whenExpr.accept((ILangVisitor)this, (Object)currentOpRef);
            currentOperator = (ILogicalOperator)whenExprResult.first;
            LogicalVariable whenConditionVar = (LogicalVariable)whenExprResult.second;
            VariableReferenceExpression whenConditionVarRef1 = new VariableReferenceExpression(whenConditionVar);
            whenConditionVarRef1.setSourceLocation(whenExpr.getSourceLocation());
            Object branchEntraceConditionExprRef = new MutableObject((Object)whenConditionVarRef1);
            if (!branchCondVarReferences.isEmpty()) {
                ArrayList<Object> arrayList = new ArrayList<Object>();
                arrayList.add(this.generateNoMatchedPrecedingWhenBranchesFilter(branchCondVarReferences, caseExpression.getSourceLocation()));
                arrayList.add(branchEntraceConditionExprRef);
                ScalarFunctionCallExpression andExpr = new ScalarFunctionCallExpression((IFunctionInfo)FunctionUtil.getFunctionInfo((FunctionIdentifier)BuiltinFunctions.AND), arrayList);
                andExpr.setSourceLocation(whenExpr.getSourceLocation());
                branchEntraceConditionExprRef = new MutableObject((Object)andExpr);
            }
            Expression expression = (Expression)thenExprList.get(index);
            Pair<ILogicalOperator, LogicalVariable> opAndVarForThen = this.constructSubplanOperatorForBranch(currentOperator, (Mutable<ILogicalExpression>)branchEntraceConditionExprRef, expression);
            VariableReferenceExpression whenConditionVarRef2 = new VariableReferenceExpression(whenConditionVar);
            whenConditionVarRef2.setSourceLocation(whenExpr.getSourceLocation());
            branchCondVarReferences.add((ILogicalExpression)whenConditionVarRef2);
            VariableReferenceExpression whenConditionVarRef3 = new VariableReferenceExpression(whenConditionVar);
            whenConditionVarRef3.setSourceLocation(whenExpr.getSourceLocation());
            allVarReferences.add(whenConditionVarRef3);
            VariableReferenceExpression thenVarRef = new VariableReferenceExpression((LogicalVariable)opAndVarForThen.second);
            thenVarRef.setSourceLocation(expression.getSourceLocation());
            allVarReferences.add(thenVarRef);
            currentOperator = (ILogicalOperator)opAndVarForThen.first;
            currentOpRef = new MutableObject((Object)currentOperator);
        }
        Mutable<ILogicalExpression> elseCondExprRef = this.generateNoMatchedPrecedingWhenBranchesFilter(branchCondVarReferences, caseExpression.getSourceLocation());
        Expression elseExpr = caseExpression.getElseExpr();
        Pair<ILogicalOperator, LogicalVariable> opAndVarForElse = this.constructSubplanOperatorForBranch(currentOperator, elseCondExprRef, elseExpr);
        LogicalVariable selectVar = this.context.newVar();
        ArrayList<MutableObject> arguments = new ArrayList<MutableObject>();
        arguments.add(new MutableObject((Object)new ConstantExpression((IAlgebricksConstantValue)new AsterixConstantValue((IAObject)ABoolean.TRUE))));
        for (ILogicalExpression iLogicalExpression : allVarReferences) {
            arguments.add(new MutableObject((Object)iLogicalExpression));
        }
        VariableReferenceExpression varForElseRef = new VariableReferenceExpression((LogicalVariable)opAndVarForElse.second);
        varForElseRef.setSourceLocation(elseExpr.getSourceLocation());
        arguments.add(new MutableObject((Object)varForElseRef));
        ScalarFunctionCallExpression scalarFunctionCallExpression = new ScalarFunctionCallExpression((IFunctionInfo)FunctionUtil.getFunctionInfo((FunctionIdentifier)BuiltinFunctions.SWITCH_CASE), arguments);
        scalarFunctionCallExpression.setSourceLocation(caseExpression.getSourceLocation());
        AssignOperator assignOp = new AssignOperator(selectVar, (Mutable)new MutableObject((Object)scalarFunctionCallExpression));
        assignOp.getInputs().add(new MutableObject(opAndVarForElse.first));
        assignOp.setSourceLocation(caseExpression.getSourceLocation());
        LogicalVariable unnestVar = this.context.newVar();
        VariableReferenceExpression selectVarRef = new VariableReferenceExpression(selectVar);
        selectVarRef.setSourceLocation(caseExpression.getSourceLocation());
        UnnestingFunctionCallExpression scanCollectionExpr = new UnnestingFunctionCallExpression((IFunctionInfo)FunctionUtil.getFunctionInfo((FunctionIdentifier)BuiltinFunctions.SCAN_COLLECTION), Collections.singletonList(new MutableObject((Object)selectVarRef)));
        scanCollectionExpr.setSourceLocation(caseExpression.getSourceLocation());
        UnnestOperator unnestOp = new UnnestOperator(unnestVar, (Mutable)new MutableObject((Object)scanCollectionExpr));
        unnestOp.getInputs().add(new MutableObject((Object)assignOp));
        unnestOp.setSourceLocation(caseExpression.getSourceLocation());
        LogicalVariable resultVar = this.context.newVar();
        VariableReferenceExpression unnestVarRef = new VariableReferenceExpression(unnestVar);
        unnestVarRef.setSourceLocation(caseExpression.getSourceLocation());
        AssignOperator finalAssignOp = new AssignOperator(resultVar, (Mutable)new MutableObject((Object)unnestVarRef));
        finalAssignOp.getInputs().add(new MutableObject((Object)unnestOp));
        finalAssignOp.setSourceLocation(caseExpression.getSourceLocation());
        return new Pair((Object)finalAssignOp, (Object)resultVar);
    }

    @Override
    protected ILogicalExpression translateVariableRef(VariableExpr varExpr) throws CompilationException {
        VarIdentifier varId = varExpr.getVar();
        if (SqlppVariableUtil.isExternalVariableIdentifier((VarIdentifier)varId)) {
            SourceLocation sourceLoc = varExpr.getSourceLocation();
            IAObject value = this.getExternalVariableValue(varId, sourceLoc);
            return this.translateConstantValue(value, sourceLoc);
        }
        return super.translateVariableRef(varExpr);
    }

    private IAObject getExternalVariableValue(VarIdentifier varId, SourceLocation sourceLoc) throws CompilationException {
        IAObject value = this.externalVars.get(varId);
        if (value == null) {
            throw new CompilationException(1038, sourceLoc, new Serializable[]{varId.toString()});
        }
        return value;
    }

    private ILogicalExpression translateConstantValue(IAObject value, SourceLocation sourceLoc) throws CompilationException {
        ConstantExpression constExpr = new ConstantExpression((IAlgebricksConstantValue)new AsterixConstantValue(value));
        constExpr.setSourceLocation(sourceLoc);
        IAType valueType = value.getType();
        if (valueType.getTypeTag().isDerivedType()) {
            ScalarFunctionCallExpression castExpr = new ScalarFunctionCallExpression((IFunctionInfo)FunctionUtil.getFunctionInfo((FunctionIdentifier)BuiltinFunctions.CAST_TYPE));
            castExpr.setSourceLocation(sourceLoc);
            castExpr.getArguments().add(new MutableObject((Object)constExpr));
            TypeCastUtils.setRequiredAndInputTypes((AbstractFunctionCallExpression)castExpr, (IAType)BuiltinType.ANY, (IAType)valueType);
            return castExpr;
        }
        return constExpr;
    }

    private Pair<ILogicalOperator, LogicalVariable> produceSelectPlan(boolean isSubquery, Mutable<ILogicalOperator> returnOpRef, LogicalVariable resVar) {
        if (isSubquery) {
            return this.aggListifyForSubquery(resVar, returnOpRef, false);
        }
        ProjectOperator pr = new ProjectOperator(resVar);
        pr.getInputs().add(returnOpRef);
        pr.setSourceLocation(((ILogicalOperator)returnOpRef.getValue()).getSourceLocation());
        return new Pair((Object)pr, (Object)resVar);
    }

    private Pair<ILogicalOperator, LogicalVariable> processSelectClause(SelectBlock selectBlock, Mutable<ILogicalOperator> tupSrc) throws CompilationException {
        LogicalVariable returnVar;
        ILogicalOperator returnOperator;
        SelectClause selectClause = selectBlock.getSelectClause();
        Expression returnExpr = selectClause.selectElement() ? selectClause.getSelectElement().getExpression() : this.generateReturnExpr(selectClause.getSelectRegular(), selectBlock);
        Pair<ILogicalExpression, Mutable<ILogicalOperator>> eo = this.langExprToAlgExpression(returnExpr, tupSrc);
        SourceLocation sourceLoc = returnExpr.getSourceLocation();
        if (returnExpr.getKind() == Expression.Kind.VARIABLE_EXPRESSION && ((ILogicalExpression)eo.first).getExpressionTag() == LogicalExpressionTag.VARIABLE) {
            VariableExpr varExpr = (VariableExpr)returnExpr;
            returnOperator = (ILogicalOperator)((Mutable)eo.second).getValue();
            returnVar = this.context.getVar(varExpr.getVar().getId());
        } else {
            returnVar = this.context.newVar();
            AssignOperator assignOp = new AssignOperator(returnVar, (Mutable)new MutableObject(eo.first));
            assignOp.getInputs().add(eo.second);
            assignOp.setSourceLocation(sourceLoc);
            returnOperator = assignOp;
        }
        if (selectClause.distinct()) {
            VariableReferenceExpression returnVarRef = new VariableReferenceExpression(returnVar);
            returnVarRef.setSourceLocation(sourceLoc);
            DistinctOperator distinctOperator = new DistinctOperator(this.mkSingletonArrayList(new MutableObject((Object)returnVarRef)));
            distinctOperator.getInputs().add(new MutableObject((Object)returnOperator));
            distinctOperator.setSourceLocation(returnOperator.getSourceLocation());
            return new Pair((Object)distinctOperator, (Object)returnVar);
        }
        return new Pair((Object)returnOperator, (Object)returnVar);
    }

    private Expression generateReturnExpr(SelectRegular selectRegular, SelectBlock selectBlock) throws CompilationException {
        ArrayList<Object> recordExprs = new ArrayList<Object>();
        ArrayList<FieldBinding> fieldBindings = new ArrayList<FieldBinding>();
        HashSet<String> fieldNames = new HashSet<String>();
        for (Projection projection : selectRegular.getProjections()) {
            if (projection.varStar()) {
                if (!fieldBindings.isEmpty()) {
                    RecordConstructor recordConstr = new RecordConstructor(new ArrayList(fieldBindings));
                    recordConstr.setSourceLocation(selectRegular.getSourceLocation());
                    recordExprs.add(recordConstr);
                    fieldBindings.clear();
                }
                Expression projectionExpr = projection.getExpression();
                SourceLocation sourceLoc = projection.getSourceLocation();
                CallExpr toObjectExpr = new CallExpr(new FunctionSignature(BuiltinFunctions.TO_OBJECT), Collections.singletonList(projectionExpr));
                toObjectExpr.setSourceLocation(sourceLoc);
                CallExpr ifMissingOrNullExpr = new CallExpr(new FunctionSignature(BuiltinFunctions.IF_MISSING_OR_NULL), Arrays.asList(toObjectExpr, new RecordConstructor(Collections.emptyList())));
                ifMissingOrNullExpr.setSourceLocation(sourceLoc);
                recordExprs.add(ifMissingOrNullExpr);
                continue;
            }
            if (projection.star()) {
                if (selectBlock.hasGroupbyClause()) {
                    this.getGroupBindings(selectBlock.getGroupbyClause(), fieldBindings, fieldNames);
                    if (!selectBlock.hasLetHavingClausesAfterGroupby()) continue;
                    this.getLetBindings(selectBlock.getLetHavingListAfterGroupby(), fieldBindings, fieldNames);
                    continue;
                }
                if (selectBlock.hasFromClause()) {
                    this.getFromBindings(selectBlock.getFromClause(), fieldBindings, fieldNames);
                    if (!selectBlock.hasLetWhereClauses()) continue;
                    this.getLetBindings(selectBlock.getLetWhereList(), fieldBindings, fieldNames);
                    continue;
                }
                if (!selectBlock.hasLetWhereClauses()) continue;
                this.getLetBindings(selectBlock.getLetWhereList(), fieldBindings, fieldNames);
                continue;
            }
            if (projection.hasName()) {
                fieldBindings.add(this.getFieldBinding(projection, fieldNames));
                continue;
            }
            throw new CompilationException(1038, projection.getSourceLocation(), new Serializable[]{""});
        }
        if (!fieldBindings.isEmpty()) {
            RecordConstructor recordConstr = new RecordConstructor(fieldBindings);
            recordConstr.setSourceLocation(selectRegular.getSourceLocation());
            recordExprs.add(recordConstr);
        }
        if (recordExprs.size() == 1) {
            return (Expression)recordExprs.get(0);
        }
        CallExpr recordConcatExpr = new CallExpr(new FunctionSignature(BuiltinFunctions.RECORD_CONCAT_STRICT), recordExprs);
        recordConcatExpr.setSourceLocation(selectRegular.getSourceLocation());
        return recordConcatExpr;
    }

    private void getFromBindings(FromClause fromClause, List<FieldBinding> outFieldBindings, Set<String> outFieldNames) throws CompilationException {
        for (FromTerm fromTerm : fromClause.getFromTerms()) {
            outFieldBindings.add(this.getFieldBinding(fromTerm.getLeftVariable(), outFieldNames));
            if (fromTerm.hasPositionalVariable()) {
                outFieldBindings.add(this.getFieldBinding(fromTerm.getPositionalVariable(), outFieldNames));
            }
            if (!fromTerm.hasCorrelateClauses()) continue;
            for (AbstractBinaryCorrelateClause correlateClause : fromTerm.getCorrelateClauses()) {
                outFieldBindings.add(this.getFieldBinding(correlateClause.getRightVariable(), outFieldNames));
                if (!correlateClause.hasPositionalVariable()) continue;
                outFieldBindings.add(this.getFieldBinding(correlateClause.getPositionalVariable(), outFieldNames));
            }
        }
    }

    private void getGroupBindings(GroupbyClause groupbyClause, List<FieldBinding> outFieldBindings, Set<String> outFieldNames) throws CompilationException {
        VariableExpr var;
        HashSet<VariableExpr> gbyKeyVars = new HashSet<VariableExpr>();
        List<GbyVariableExpressionPair> groupingSet = this.getSingleGroupingSet(groupbyClause);
        for (GbyVariableExpressionPair pair : groupingSet) {
            var = pair.getVar();
            if (!gbyKeyVars.add(var)) continue;
            outFieldBindings.add(this.getFieldBinding(var, outFieldNames));
        }
        if (groupbyClause.hasDecorList()) {
            for (GbyVariableExpressionPair pair : groupbyClause.getDecorPairList()) {
                var = pair.getVar();
                if (!gbyKeyVars.add(var)) continue;
                outFieldBindings.add(this.getFieldBinding(var, outFieldNames));
            }
        }
        if (groupbyClause.hasGroupVar()) {
            outFieldBindings.add(this.getFieldBinding(groupbyClause.getGroupVar(), outFieldNames));
        }
        if (groupbyClause.hasWithMap()) {
            throw new CompilationException(1038, groupbyClause.getSourceLocation(), new Serializable[]{groupbyClause.getWithVarMap().values().toString()});
        }
    }

    private void getLetBindings(List<AbstractClause> clauses, List<FieldBinding> outFieldBindings, Set<String> outFieldNames) throws CompilationException {
        for (AbstractClause clause : clauses) {
            if (clause.getClauseType() != Clause.ClauseType.LET_CLAUSE) continue;
            LetClause letClause = (LetClause)clause;
            outFieldBindings.add(this.getFieldBinding(letClause.getVarExpr(), outFieldNames));
        }
    }

    private FieldBinding getFieldBinding(VariableExpr varExpr, Set<String> outFieldNames) throws CompilationException {
        String fieldName = SqlppVariableUtil.variableNameToDisplayedFieldName((String)varExpr.getVar().getValue());
        return this.generateFieldBinding(fieldName, (Expression)varExpr, outFieldNames, varExpr.getSourceLocation());
    }

    private FieldBinding getFieldBinding(Projection projection, Set<String> outFieldNames) throws CompilationException {
        String fieldName = projection.getName();
        Expression fieldValueExpr = projection.getExpression();
        return this.generateFieldBinding(fieldName, fieldValueExpr, outFieldNames, projection.getSourceLocation());
    }

    private FieldBinding generateFieldBinding(String fieldName, Expression fieldValueExpr, Set<String> outFieldNames, SourceLocation sourceLoc) throws CompilationException {
        if (!outFieldNames.add(fieldName)) {
            throw new CompilationException(13, sourceLoc, new Serializable[]{fieldName});
        }
        return new FieldBinding((Expression)new LiteralExpr((Literal)new StringLiteral(fieldName)), fieldValueExpr);
    }

    @Override
    protected boolean expressionNeedsNoNesting(Expression expr) throws CompilationException {
        return super.expressionNeedsNoNesting(expr) || this.translateInAsOr && expr.getKind() == Expression.Kind.QUANTIFIED_EXPRESSION && this.isInOperatorWithStaticList((QuantifiedExpression)expr);
    }

    @Override
    public Pair<ILogicalOperator, LogicalVariable> visit(QuantifiedExpression qe, Mutable<ILogicalOperator> tupSource) throws CompilationException {
        return this.translateInAsOr && this.isInOperatorWithStaticList(qe) ? this.translateInOperatorWithStaticList(qe, tupSource) : super.visit(qe, tupSource);
    }

    private boolean isInOperatorWithStaticList(QuantifiedExpression qe) throws CompilationException {
        if (qe.getQuantifier() != QuantifiedExpression.Quantifier.SOME) {
            return false;
        }
        List qpList = qe.getQuantifiedList();
        if (qpList.size() != 1) {
            return false;
        }
        QuantifiedPair qp = (QuantifiedPair)qpList.get(0);
        Expression condExpr = qe.getSatisfiesExpr();
        if (condExpr.getKind() != Expression.Kind.OP_EXPRESSION) {
            return false;
        }
        OperatorExpr opExpr = (OperatorExpr)condExpr;
        if (opExpr.getOpList().get(0) != OperatorType.EQ) {
            return false;
        }
        List operandExprs = opExpr.getExprList();
        if (operandExprs.size() != 2) {
            return false;
        }
        VariableExpr varExpr = qp.getVarExpr();
        int varPos = operandExprs.indexOf(varExpr);
        if (varPos < 0) {
            return false;
        }
        Expression operandExpr = (Expression)operandExprs.get(1 - varPos);
        if (SqlppRewriteUtil.getFreeVariable((Expression)operandExpr).contains(varExpr)) {
            return false;
        }
        Expression inExpr = qp.getExpr();
        switch (inExpr.getKind()) {
            case LIST_CONSTRUCTOR_EXPRESSION: {
                ListConstructor listExpr = (ListConstructor)inExpr;
                List itemExprs = listExpr.getExprList();
                if (itemExprs.isEmpty()) {
                    return false;
                }
                for (Expression itemExpr : itemExprs) {
                    boolean isConst = itemExpr.getKind() == Expression.Kind.LITERAL_EXPRESSION || itemExpr.getKind() == Expression.Kind.VARIABLE_EXPRESSION && SqlppVariableUtil.isExternalVariableReference((VariableExpr)((VariableExpr)itemExpr));
                    if (isConst) continue;
                    return false;
                }
                return true;
            }
            case VARIABLE_EXPRESSION: {
                VarIdentifier inVarId = ((VariableExpr)inExpr).getVar();
                if (!SqlppVariableUtil.isExternalVariableIdentifier((VarIdentifier)inVarId)) {
                    return false;
                }
                IAObject inValue = this.externalVars.get(inVarId);
                return inValue != null && inValue.getType().getTypeTag().isListType() && ((IACollection)inValue).size() > 0;
            }
        }
        return false;
    }

    private Pair<ILogicalOperator, LogicalVariable> translateInOperatorWithStaticList(QuantifiedExpression qe, Mutable<ILogicalOperator> tupSource) throws CompilationException {
        MutableObject disjunctiveExpr;
        SourceLocation sourceLoc = qe.getSourceLocation();
        QuantifiedPair qp = (QuantifiedPair)qe.getQuantifiedList().get(0);
        VariableExpr varExpr = qp.getVarExpr();
        OperatorExpr condExpr = (OperatorExpr)qe.getSatisfiesExpr();
        List condExprHints = condExpr.getHints();
        List operandExprs = condExpr.getExprList();
        int varIdx = operandExprs.indexOf(varExpr);
        Expression operandExpr = (Expression)operandExprs.get(1 - varIdx);
        Mutable topOp = tupSource;
        Pair<ILogicalExpression, Mutable<ILogicalOperator>> eo1 = this.langExprToAlgExpression(operandExpr, topOp);
        topOp = (Mutable)eo1.second;
        LogicalVariable operandVar = this.context.newVar();
        AssignOperator operandAssign = new AssignOperator(operandVar, (Mutable)new MutableObject(eo1.first));
        operandAssign.getInputs().add(topOp);
        operandAssign.setSourceLocation(sourceLoc);
        topOp = new MutableObject((Object)operandAssign);
        ArrayList<MutableObject> disjuncts = new ArrayList<MutableObject>();
        Expression inExpr = qp.getExpr();
        switch (inExpr.getKind()) {
            case LIST_CONSTRUCTOR_EXPRESSION: {
                ListConstructor listExpr = (ListConstructor)inExpr;
                for (Expression itemExpr : listExpr.getExprList()) {
                    IAObject inValue;
                    switch (itemExpr.getKind()) {
                        case LITERAL_EXPRESSION: {
                            inValue = ConstantHelper.objectFromLiteral(((LiteralExpr)itemExpr).getValue());
                            break;
                        }
                        case VARIABLE_EXPRESSION: {
                            inValue = this.getExternalVariableValue(((VariableExpr)itemExpr).getVar(), sourceLoc);
                            break;
                        }
                        default: {
                            throw new CompilationException(1038, sourceLoc, new Serializable[]{itemExpr.getKind()});
                        }
                    }
                    ILogicalExpression eqExpr = this.createEqExpr(operandVar, inValue, condExprHints, sourceLoc);
                    disjuncts.add(new MutableObject((Object)eqExpr));
                }
                break;
            }
            case VARIABLE_EXPRESSION: {
                VarIdentifier inVarId = ((VariableExpr)inExpr).getVar();
                IAObject inVarValue = this.externalVars.get(inVarId);
                IACursor inVarCursor = ((IACollection)inVarValue).getCursor();
                inVarCursor.reset();
                while (inVarCursor.next()) {
                    IAObject inValue = inVarCursor.get();
                    ILogicalExpression eqExpr = this.createEqExpr(operandVar, inValue, condExprHints, sourceLoc);
                    disjuncts.add(new MutableObject((Object)eqExpr));
                }
                break;
            }
            default: {
                throw new IllegalStateException(String.valueOf(inExpr.getKind()));
            }
        }
        if (disjuncts.size() == 1) {
            disjunctiveExpr = (MutableObject)disjuncts.get(0);
        } else {
            AbstractFunctionCallExpression orExpr = SqlppExpressionToPlanTranslator.createFunctionCallExpressionForBuiltinOperator(OperatorType.OR, sourceLoc);
            orExpr.getArguments().addAll(disjuncts);
            disjunctiveExpr = new MutableObject((Object)orExpr);
        }
        LogicalVariable assignVar = this.context.newVar();
        AssignOperator assignOp = new AssignOperator(assignVar, (Mutable)disjunctiveExpr);
        assignOp.getInputs().add(topOp);
        assignOp.setSourceLocation(sourceLoc);
        return new Pair((Object)assignOp, (Object)assignVar);
    }

    private ILogicalExpression createEqExpr(LogicalVariable lhsVar, IAObject rhsValue, List<IExpressionAnnotation> hints, SourceLocation sourceLoc) throws CompilationException {
        VariableReferenceExpression lhsExpr = new VariableReferenceExpression(lhsVar);
        lhsExpr.setSourceLocation(sourceLoc);
        ILogicalExpression rhsExpr = this.translateConstantValue(rhsValue, sourceLoc);
        AbstractFunctionCallExpression opExpr = SqlppExpressionToPlanTranslator.createFunctionCallExpressionForBuiltinOperator(OperatorType.EQ, sourceLoc);
        opExpr.getArguments().add(new MutableObject((Object)lhsExpr));
        opExpr.getArguments().add(new MutableObject((Object)rhsExpr));
        if (hints != null) {
            for (IExpressionAnnotation hint : hints) {
                opExpr.getAnnotations().put(hint, hint);
            }
        }
        return opExpr;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Pair<ILogicalOperator, LogicalVariable> visit(WindowExpression winExpr, Mutable<ILogicalOperator> tupSource) throws CompilationException {
        VariableReferenceExpression resultExpr;
        boolean allowFromFirstLast;
        SourceLocation sourceLoc = winExpr.getSourceLocation();
        List fargs = winExpr.getExprList();
        FunctionSignature fs = winExpr.getFunctionSignature();
        BuiltinFunctionInfo finfo = BuiltinFunctions.getBuiltinFunctionInfo((FunctionIdentifier)fs.createFunctionIdentifier());
        if (finfo == null) {
            throw new CompilationException(1102, winExpr.getSourceLocation(), new Serializable[]{fs.getName()});
        }
        FunctionIdentifier fi = finfo.getFunctionIdentifier();
        boolean isWin = BuiltinFunctions.isWindowFunction((FunctionIdentifier)fi);
        boolean isWinAgg = isWin && BuiltinFunctions.builtinFunctionHasProperty((FunctionIdentifier)fi, (BuiltinFunctions.BuiltinFunctionProperty)BuiltinFunctions.WindowFunctionProperty.HAS_LIST_ARG);
        boolean prohibitOrderClause = isWin && BuiltinFunctions.builtinFunctionHasProperty((FunctionIdentifier)fi, (BuiltinFunctions.BuiltinFunctionProperty)BuiltinFunctions.WindowFunctionProperty.NO_ORDER_CLAUSE);
        boolean prohibitFrameClause = isWin && BuiltinFunctions.builtinFunctionHasProperty((FunctionIdentifier)fi, (BuiltinFunctions.BuiltinFunctionProperty)BuiltinFunctions.WindowFunctionProperty.NO_FRAME_CLAUSE);
        boolean allowRespectIgnoreNulls = isWin && BuiltinFunctions.builtinFunctionHasProperty((FunctionIdentifier)fi, (BuiltinFunctions.BuiltinFunctionProperty)BuiltinFunctions.WindowFunctionProperty.ALLOW_RESPECT_IGNORE_NULLS);
        boolean bl = allowFromFirstLast = isWin && BuiltinFunctions.builtinFunctionHasProperty((FunctionIdentifier)fi, (BuiltinFunctions.BuiltinFunctionProperty)BuiltinFunctions.WindowFunctionProperty.ALLOW_FROM_FIRST_LAST);
        if (winExpr.hasAggregateFilterExpr()) {
            throw new CompilationException(1121, sourceLoc, new Serializable[0]);
        }
        MutableObject currentOpRef = tupSource;
        List partExprListOut = Collections.emptyList();
        if (winExpr.hasPartitionList()) {
            List partExprList = winExpr.getPartitionList();
            partExprListOut = new ArrayList(partExprList.size());
            for (Expression partExpr : partExprList) {
                Pair partExprResult = (Pair)partExpr.accept((ILangVisitor)this, (Object)currentOpRef);
                VariableReferenceExpression partExprOut = new VariableReferenceExpression((LogicalVariable)partExprResult.second);
                partExprOut.setSourceLocation(partExpr.getSourceLocation());
                partExprListOut.add(new MutableObject((Object)partExprOut));
                currentOpRef = new MutableObject(partExprResult.first);
            }
        }
        int orderExprCount = 0;
        List<Pair<OrderOperator.IOrder, Mutable<ILogicalExpression>>> orderExprListOut = Collections.emptyList();
        List<Pair<OrderOperator.IOrder, Mutable<ILogicalExpression>>> frameValueExprRefs = null;
        List frameStartExprRefs = null;
        List frameStartValidationExprRefs = null;
        List frameEndExprRefs = null;
        List frameEndValidationExprRefs = null;
        List frameExcludeExprRefs = null;
        int frameExcludeNotStartIdx = -1;
        VariableReferenceExpression frameExcludeUnaryExpr = null;
        VariableReferenceExpression frameOffsetExpr = null;
        if (winExpr.hasOrderByList()) {
            if (prohibitOrderClause) {
                throw new CompilationException(1101, sourceLoc, new Serializable[0]);
            }
            List orderExprList = winExpr.getOrderbyList();
            List orderModifierList = winExpr.getOrderbyModifierList();
            orderExprCount = orderExprList.size();
            orderExprListOut = new ArrayList(orderExprCount);
            for (int i = 0; i < orderExprCount; ++i) {
                Expression orderExpr = (Expression)orderExprList.get(i);
                OrderbyClause.OrderModifier orderModifier = (OrderbyClause.OrderModifier)orderModifierList.get(i);
                Pair orderExprResult = (Pair)orderExpr.accept((ILangVisitor)this, (Object)currentOpRef);
                VariableReferenceExpression orderExprOut = new VariableReferenceExpression((LogicalVariable)orderExprResult.second);
                orderExprOut.setSourceLocation(orderExpr.getSourceLocation());
                OrderOperator.IOrder orderModifierOut = this.translateOrderModifier(orderModifier);
                orderExprListOut.add(new Pair((Object)orderModifierOut, (Object)new MutableObject((Object)orderExprOut)));
                currentOpRef = new MutableObject(orderExprResult.first);
            }
        } else if (winExpr.hasFrameDefinition()) {
            throw new CompilationException(1099, sourceLoc, new Serializable[0]);
        }
        WindowExpression.FrameMode winFrameMode = null;
        WindowExpression.FrameExclusionKind winFrameExclusionKind = null;
        WindowExpression.FrameBoundaryKind winFrameStartKind = null;
        WindowExpression.FrameBoundaryKind winFrameEndKind = null;
        Expression winFrameStartExpr = null;
        Expression winFrameEndExpr = null;
        CallExpr winFrameExcludeUnaryExpr = null;
        AbstractExpression winFrameOffsetExpr = null;
        int winFrameMaxOjbects = -1;
        if (winExpr.hasFrameDefinition()) {
            if (prohibitFrameClause) {
                throw new CompilationException(1099, sourceLoc, new Serializable[0]);
            }
            winFrameMode = winExpr.getFrameMode();
            winFrameStartKind = winExpr.getFrameStartKind();
            winFrameStartExpr = winExpr.getFrameStartExpr();
            winFrameEndKind = winExpr.getFrameEndKind();
            winFrameEndExpr = winExpr.getFrameEndExpr();
            winFrameExclusionKind = winExpr.getFrameExclusionKind();
            if (!this.isValidWindowFrameDefinition(winFrameMode, winFrameStartKind, winFrameEndKind, orderExprCount)) {
                throw new CompilationException(1098, sourceLoc, new Serializable[0]);
            }
        } else if (!prohibitFrameClause) {
            winFrameMode = WindowExpression.FrameMode.RANGE;
            winFrameStartKind = WindowExpression.FrameBoundaryKind.UNBOUNDED_PRECEDING;
            winFrameEndKind = WindowExpression.FrameBoundaryKind.CURRENT_ROW;
            winFrameExclusionKind = WindowExpression.FrameExclusionKind.NO_OTHERS;
        }
        boolean respectNulls = !this.getBooleanModifier(winExpr.getIgnoreNulls(), false, allowRespectIgnoreNulls, sourceLoc, "RESPECT/IGNORE NULLS", fs.getName());
        boolean fromLast = this.getBooleanModifier(winExpr.getFromLast(), false, allowFromFirstLast, sourceLoc, "FROM FIRST/LAST", fs.getName());
        boolean makeRunningAgg = false;
        boolean makeNestedAgg = false;
        FunctionIdentifier runningAggFunc = null;
        FunctionIdentifier nestedAggFunc = null;
        FunctionIdentifier winResultFunc = null;
        FunctionIdentifier postWinResultFunc = null;
        Expression postWinExpr = null;
        Object var45_47 = null;
        boolean postWinResultArgsReverse = false;
        if (isWinAgg) {
            makeNestedAgg = true;
            ArrayList arrayList = new ArrayList(fargs.size());
            arrayList.add(fargs.get(0));
            boolean isLead = BuiltinFunctions.LEAD_IMPL.equals((Object)fi);
            if (isLead || BuiltinFunctions.LAG_IMPL.equals((Object)fi)) {
                boolean isLag = !isLead;
                int argCount = fargs.size();
                if (argCount < 2 || argCount > 4) {
                    throw new CompilationException(1087, sourceLoc, new Serializable[]{fi.getName()});
                }
                winFrameMode = WindowExpression.FrameMode.ROWS;
                winFrameExclusionKind = WindowExpression.FrameExclusionKind.NO_OTHERS;
                if (respectNulls) {
                    winFrameEndKind = isLead ? WindowExpression.FrameBoundaryKind.BOUNDED_FOLLOWING : WindowExpression.FrameBoundaryKind.BOUNDED_PRECEDING;
                    winFrameStartKind = winFrameEndKind;
                    winFrameStartExpr = argCount == 2 ? new LiteralExpr((Literal)new IntegerLiteral(Integer.valueOf(1))) : (Expression)fargs.get(1);
                    winFrameEndExpr = (Expression)SqlppRewriteUtil.deepCopy((ILangExpression)winFrameStartExpr);
                    winFrameMaxOjbects = 1;
                } else {
                    if (isLag) {
                        SqlppExpressionToPlanTranslator.reverseOrder(orderExprListOut);
                    }
                    winFrameStartKind = WindowExpression.FrameBoundaryKind.BOUNDED_FOLLOWING;
                    winFrameStartExpr = new LiteralExpr((Literal)new IntegerLiteral(Integer.valueOf(1)));
                    winFrameEndKind = WindowExpression.FrameBoundaryKind.UNBOUNDED_FOLLOWING;
                    Expression fargLast = (Expression)fargs.get(fargs.size() - 1);
                    winFrameExcludeUnaryExpr = this.createCallExpr(BuiltinFunctions.IS_UNKNOWN, fargLast, sourceLoc);
                    if (argCount > 2) {
                        winFrameOffsetExpr = this.createOperatorExpr((Expression)fargs.get(1), OperatorType.MINUS, (Literal)new IntegerLiteral(Integer.valueOf(1)), sourceLoc);
                    }
                }
                if (argCount < 4) {
                    nestedAggFunc = BuiltinFunctions.SCALAR_FIRST_ELEMENT;
                } else {
                    nestedAggFunc = BuiltinFunctions.SCALAR_LOCAL_FIRST_ELEMENT;
                    postWinResultFunc = BuiltinFunctions.IF_SYSTEM_NULL;
                    postWinExpr = (Expression)fargs.get(2);
                }
            } else if (BuiltinFunctions.FIRST_VALUE_IMPL.equals((Object)fi)) {
                nestedAggFunc = BuiltinFunctions.SCALAR_FIRST_ELEMENT;
                if (respectNulls) {
                    winFrameMaxOjbects = 1;
                } else {
                    Expression fargLast = (Expression)fargs.get(fargs.size() - 1);
                    winFrameExcludeUnaryExpr = this.createCallExpr(BuiltinFunctions.IS_UNKNOWN, fargLast, sourceLoc);
                }
            } else if (BuiltinFunctions.LAST_VALUE_IMPL.equals((Object)fi)) {
                nestedAggFunc = BuiltinFunctions.SCALAR_LAST_ELEMENT;
                if (!respectNulls) {
                    Expression fargLast = (Expression)fargs.get(fargs.size() - 1);
                    winFrameExcludeUnaryExpr = this.createCallExpr(BuiltinFunctions.IS_UNKNOWN, fargLast, sourceLoc);
                }
            } else if (BuiltinFunctions.NTH_VALUE_IMPL.equals((Object)fi)) {
                nestedAggFunc = BuiltinFunctions.SCALAR_FIRST_ELEMENT;
                if (fromLast) {
                    SqlppExpressionToPlanTranslator.reverseOrder(orderExprListOut);
                    WindowExpression.FrameBoundaryKind tmpFrameStartKind = winFrameStartKind;
                    Expression tmpFrameStartExpr = winFrameStartExpr;
                    winFrameStartKind = this.reverseFrameBoundaryKind(winFrameEndKind);
                    winFrameStartExpr = winFrameEndExpr;
                    winFrameEndKind = this.reverseFrameBoundaryKind(tmpFrameStartKind);
                    winFrameEndExpr = tmpFrameStartExpr;
                }
                if (respectNulls) {
                    winFrameMaxOjbects = 1;
                } else {
                    Expression fargLast = (Expression)fargs.get(fargs.size() - 1);
                    winFrameExcludeUnaryExpr = this.createCallExpr(BuiltinFunctions.IS_UNKNOWN, fargLast, sourceLoc);
                }
                winFrameOffsetExpr = this.createOperatorExpr((Expression)fargs.get(1), OperatorType.MINUS, (Literal)new IntegerLiteral(Integer.valueOf(1)), sourceLoc);
            } else {
                if (!BuiltinFunctions.RATIO_TO_REPORT_IMPL.equals((Object)fi)) throw new CompilationException(1038, sourceLoc, new Serializable[]{fi.getName()});
                nestedAggFunc = BuiltinFunctions.SCALAR_SQL_SUM;
                postWinResultFunc = BuiltinFunctions.NUMERIC_DIVIDE;
                postWinExpr = (Expression)fargs.get(1);
                postWinResultArgsReverse = true;
            }
        } else if (isWin) {
            makeRunningAgg = true;
            if (BuiltinFunctions.CUME_DIST_IMPL.equals((Object)fi)) {
                winFrameMode = WindowExpression.FrameMode.RANGE;
                winFrameStartKind = WindowExpression.FrameBoundaryKind.UNBOUNDED_PRECEDING;
                winFrameEndKind = WindowExpression.FrameBoundaryKind.CURRENT_ROW;
                winFrameExclusionKind = WindowExpression.FrameExclusionKind.NO_OTHERS;
                makeNestedAgg = true;
                runningAggFunc = BuiltinFunctions.WIN_PARTITION_LENGTH_IMPL;
                nestedAggFunc = BuiltinFunctions.SCALAR_COUNT;
                List<Expression> list = this.mkSingletonArrayList((Expression)SqlppRewriteUtil.deepCopy((ILangExpression)winExpr.getWindowVar()));
                winResultFunc = BuiltinFunctions.NUMERIC_DIVIDE;
            } else {
                runningAggFunc = fi;
            }
        } else {
            makeNestedAgg = true;
            nestedAggFunc = fi;
            List list = fargs;
        }
        if (winFrameMode != null) {
            Triple<ILogicalOperator, List<Mutable<ILogicalExpression>>, List<Mutable<ILogicalExpression>>> frameEndResult;
            Triple<ILogicalOperator, List<Mutable<ILogicalExpression>>, List<Mutable<ILogicalExpression>>> frameStartResult;
            LogicalVariable rowNumVar = this.context.newVar();
            LogicalVariable denseRankVar = this.context.newVar();
            ListSet usedVars = new ListSet();
            frameValueExprRefs = this.translateWindowFrameMode(winFrameMode, winFrameStartKind, winFrameEndKind, orderExprListOut, rowNumVar, denseRankVar, (Set<LogicalVariable>)usedVars, sourceLoc);
            Pair<List<Mutable<ILogicalExpression>>, Integer> frameExclusionResult = this.translateWindowExclusion(winFrameExclusionKind, rowNumVar, denseRankVar, (Set<LogicalVariable>)usedVars, sourceLoc);
            if (frameExclusionResult != null) {
                frameExcludeExprRefs = (List)frameExclusionResult.first;
                frameExcludeNotStartIdx = (Integer)frameExclusionResult.second;
            }
            if (!usedVars.isEmpty()) {
                List partExprListClone = OperatorManipulationUtil.cloneExpressions(partExprListOut);
                List orderExprListClone = OperatorManipulationUtil.cloneOrderExpressions(orderExprListOut);
                WindowOperator helperWinOp = this.createHelperWindowOperator(partExprListClone, orderExprListClone, rowNumVar, denseRankVar, (ListSet<LogicalVariable>)usedVars, sourceLoc);
                helperWinOp.getInputs().add(currentOpRef);
                currentOpRef = new MutableObject((Object)helperWinOp);
            }
            if ((frameStartResult = this.translateWindowBoundary(winFrameStartKind, winFrameStartExpr, frameValueExprRefs, orderExprListOut, (Mutable<ILogicalOperator>)currentOpRef)) != null) {
                frameStartExprRefs = (List)frameStartResult.second;
                frameStartValidationExprRefs = (List)frameStartResult.third;
                if (frameStartResult.first != null) {
                    currentOpRef = new MutableObject(frameStartResult.first);
                }
            }
            if ((frameEndResult = this.translateWindowBoundary(winFrameEndKind, winFrameEndExpr, frameValueExprRefs, orderExprListOut, (Mutable<ILogicalOperator>)currentOpRef)) != null) {
                frameEndExprRefs = (List)frameEndResult.second;
                frameEndValidationExprRefs = (List)frameEndResult.third;
                if (frameEndResult.first != null) {
                    currentOpRef = new MutableObject(frameEndResult.first);
                }
            }
            if (winFrameExcludeUnaryExpr != null) {
                Pair frameExcludeUnaryResult = (Pair)winFrameExcludeUnaryExpr.accept((ILangVisitor)this, (Object)currentOpRef);
                frameExcludeUnaryExpr = new VariableReferenceExpression((LogicalVariable)frameExcludeUnaryResult.second);
                frameExcludeUnaryExpr.setSourceLocation(sourceLoc);
                currentOpRef = new MutableObject(frameExcludeUnaryResult.first);
            }
            if (winFrameOffsetExpr != null) {
                Pair frameOffsetResult = (Pair)winFrameOffsetExpr.accept((ILangVisitor)this, (Object)currentOpRef);
                frameOffsetExpr = new VariableReferenceExpression((LogicalVariable)frameOffsetResult.second);
                frameOffsetExpr.setSourceLocation(sourceLoc);
                currentOpRef = new MutableObject(frameOffsetResult.first);
            }
        }
        WindowOperator winOp = new WindowOperator(partExprListOut, orderExprListOut, frameValueExprRefs, frameStartExprRefs, frameStartValidationExprRefs, frameEndExprRefs, frameEndValidationExprRefs, frameExcludeExprRefs, frameExcludeNotStartIdx, frameExcludeUnaryExpr, frameOffsetExpr, winFrameMaxOjbects);
        winOp.setSourceLocation(sourceLoc);
        LogicalVariable runningAggResultVar = null;
        LogicalVariable nestedAggResultVar = null;
        if (makeNestedAgg) {
            void var45_51;
            LogicalVariable windowRecordVar = this.context.newVar();
            AbstractFunctionCallExpression windowRecordConstr = this.createRecordConstructor(winExpr.getWindowFieldList(), (Mutable<ILogicalOperator>)currentOpRef, sourceLoc);
            AssignOperator assignOp = new AssignOperator(windowRecordVar, (Mutable)new MutableObject((Object)windowRecordConstr));
            assignOp.getInputs().add(currentOpRef);
            assignOp.setSourceLocation(sourceLoc);
            NestedTupleSourceOperator ntsOp = new NestedTupleSourceOperator((Mutable)new MutableObject((Object)winOp));
            ntsOp.setSourceLocation(sourceLoc);
            VariableReferenceExpression frameRecordVarRef = new VariableReferenceExpression(windowRecordVar);
            frameRecordVarRef.setSourceLocation(sourceLoc);
            AggregateFunctionCallExpression listifyCall = BuiltinFunctions.makeAggregateFunctionExpression((FunctionIdentifier)BuiltinFunctions.LISTIFY, this.mkSingletonArrayList(new MutableObject((Object)frameRecordVarRef)));
            listifyCall.setSourceLocation(sourceLoc);
            LogicalVariable windowVar = this.context.newVar();
            AggregateOperator aggOp = new AggregateOperator(this.mkSingletonArrayList(windowVar), this.mkSingletonArrayList(new MutableObject((Object)listifyCall)));
            aggOp.getInputs().add(new MutableObject((Object)ntsOp));
            aggOp.setSourceLocation(sourceLoc);
            this.context.setVar(winExpr.getWindowVar(), windowVar);
            CallExpr callExpr = new CallExpr(new FunctionSignature(nestedAggFunc), (List)var45_51);
            Pair exprResult = (Pair)callExpr.accept((ILangVisitor)this, (Object)new MutableObject((Object)aggOp));
            winOp.getNestedPlans().add(new ALogicalPlanImpl((Mutable)new MutableObject(exprResult.first)));
            currentOpRef = new MutableObject((Object)assignOp);
            nestedAggResultVar = (LogicalVariable)exprResult.second;
        }
        if (makeRunningAgg) {
            CallExpr callExpr = new CallExpr(new FunctionSignature(runningAggFunc), fargs);
            Pair callExprResult = (Pair)callExpr.accept((ILangVisitor)this, (Object)currentOpRef);
            ILogicalOperator op = (ILogicalOperator)callExprResult.first;
            if (op.getOperatorTag() != LogicalOperatorTag.ASSIGN) {
                throw new CompilationException(1038, sourceLoc, new Serializable[]{""});
            }
            AssignOperator assignOp = (AssignOperator)op;
            List assignVars = assignOp.getVariables();
            if (assignVars.size() != 1) {
                throw new CompilationException(1038, sourceLoc, new Serializable[]{""});
            }
            List assignExprs = assignOp.getExpressions();
            if (assignExprs.size() != 1) {
                throw new CompilationException(1038, sourceLoc, new Serializable[]{""});
            }
            ILogicalExpression assignExpr = (ILogicalExpression)((Mutable)assignExprs.get(0)).getValue();
            if (assignExpr.getExpressionTag() != LogicalExpressionTag.FUNCTION_CALL) {
                throw new CompilationException(1038, sourceLoc, new Serializable[]{""});
            }
            AbstractFunctionCallExpression fcallExpr = (AbstractFunctionCallExpression)assignExpr;
            if (fcallExpr.getKind() != AbstractFunctionCallExpression.FunctionKind.STATEFUL) {
                throw new CompilationException(1038, sourceLoc, new Serializable[]{fcallExpr.getKind()});
            }
            if (BuiltinFunctions.builtinFunctionHasProperty((FunctionIdentifier)fi, (BuiltinFunctions.BuiltinFunctionProperty)BuiltinFunctions.WindowFunctionProperty.INJECT_ORDER_ARGS)) {
                for (Pair<OrderOperator.IOrder, Mutable<ILogicalExpression>> p : orderExprListOut) {
                    fcallExpr.getArguments().add(new MutableObject((Object)((ILogicalExpression)((Mutable)p.second).getValue()).cloneExpression()));
                }
            }
            winOp.getVariables().addAll(assignVars);
            winOp.getExpressions().addAll(assignExprs);
            currentOpRef = new MutableObject(((Mutable)assignOp.getInputs().get(0)).getValue());
            runningAggResultVar = (LogicalVariable)assignVars.get(0);
        }
        winOp.getInputs().add(currentOpRef);
        currentOpRef = new MutableObject((Object)winOp);
        if (makeRunningAgg && makeNestedAgg) {
            VariableReferenceExpression runningAggResultVarRef = new VariableReferenceExpression(runningAggResultVar);
            runningAggResultVarRef.setSourceLocation(sourceLoc);
            VariableReferenceExpression nestedAggResultVarRef = new VariableReferenceExpression(nestedAggResultVar);
            nestedAggResultVarRef.setSourceLocation(sourceLoc);
            AbstractFunctionCallExpression resultCallExpr = SqlppExpressionToPlanTranslator.createFunctionCallExpression(winResultFunc, sourceLoc);
            resultCallExpr.getArguments().add(new MutableObject((Object)nestedAggResultVarRef));
            resultCallExpr.getArguments().add(new MutableObject((Object)runningAggResultVarRef));
            resultExpr = resultCallExpr;
        } else if (makeRunningAgg) {
            resultExpr = new VariableReferenceExpression(runningAggResultVar);
            resultExpr.setSourceLocation(sourceLoc);
        } else {
            if (!makeNestedAgg) throw new CompilationException(1038, sourceLoc, new Serializable[]{""});
            resultExpr = new VariableReferenceExpression(nestedAggResultVar);
            resultExpr.setSourceLocation(sourceLoc);
        }
        if (postWinExpr != null) {
            Pair postWinExprResult = (Pair)postWinExpr.accept((ILangVisitor)this, (Object)currentOpRef);
            currentOpRef = new MutableObject(postWinExprResult.first);
            VariableReferenceExpression postWinVarRef = new VariableReferenceExpression((LogicalVariable)postWinExprResult.second);
            postWinVarRef.setSourceLocation(sourceLoc);
            AbstractFunctionCallExpression postWinResultCallExpr = SqlppExpressionToPlanTranslator.createFunctionCallExpression(postWinResultFunc, sourceLoc);
            List postWinResultCallArgs = postWinResultCallExpr.getArguments();
            if (!postWinResultArgsReverse) {
                postWinResultCallArgs.add(new MutableObject((Object)resultExpr));
                postWinResultCallArgs.add(new MutableObject((Object)postWinVarRef));
            } else {
                postWinResultCallArgs.add(new MutableObject((Object)postWinVarRef));
                postWinResultCallArgs.add(new MutableObject((Object)resultExpr));
            }
            resultExpr = postWinResultCallExpr;
        }
        LogicalVariable resultVar = this.context.newVar();
        AssignOperator resultOp = new AssignOperator(resultVar, (Mutable)new MutableObject((Object)resultExpr));
        resultOp.setSourceLocation(sourceLoc);
        resultOp.getInputs().add(currentOpRef);
        return new Pair((Object)resultOp, (Object)resultVar);
    }

    private List<Pair<OrderOperator.IOrder, Mutable<ILogicalExpression>>> translateWindowFrameMode(WindowExpression.FrameMode frameMode, WindowExpression.FrameBoundaryKind winFrameStartKind, WindowExpression.FrameBoundaryKind winFrameEndKind, List<Pair<OrderOperator.IOrder, Mutable<ILogicalExpression>>> orderExprList, LogicalVariable rowNumVar, LogicalVariable denseRankVar, Set<LogicalVariable> outUsedVars, SourceLocation sourceLoc) throws CompilationException {
        if (winFrameStartKind == WindowExpression.FrameBoundaryKind.UNBOUNDED_PRECEDING && winFrameEndKind == WindowExpression.FrameBoundaryKind.UNBOUNDED_FOLLOWING) {
            return Collections.emptyList();
        }
        switch (frameMode) {
            case RANGE: {
                ArrayList<Pair<OrderOperator.IOrder, Mutable<ILogicalExpression>>> result = new ArrayList<Pair<OrderOperator.IOrder, Mutable<ILogicalExpression>>>(orderExprList.size());
                for (Pair<OrderOperator.IOrder, Mutable<ILogicalExpression>> p : orderExprList) {
                    result.add((Pair<OrderOperator.IOrder, Mutable<ILogicalExpression>>)new Pair(p.first, (Object)new MutableObject((Object)((ILogicalExpression)((Mutable)p.second).getValue()).cloneExpression())));
                }
                return result;
            }
            case ROWS: {
                outUsedVars.add(rowNumVar);
                VariableReferenceExpression rowNumRefExpr = new VariableReferenceExpression(rowNumVar);
                rowNumRefExpr.setSourceLocation(sourceLoc);
                return this.mkSingletonArrayList(new Pair((Object)OrderOperator.ASC_ORDER, (Object)new MutableObject((Object)rowNumRefExpr)));
            }
            case GROUPS: {
                outUsedVars.add(denseRankVar);
                VariableReferenceExpression denseRankRefExpr = new VariableReferenceExpression(denseRankVar);
                denseRankRefExpr.setSourceLocation(sourceLoc);
                return this.mkSingletonArrayList(new Pair((Object)OrderOperator.ASC_ORDER, (Object)new MutableObject((Object)denseRankRefExpr)));
            }
        }
        throw new CompilationException(1038, sourceLoc, new Serializable[]{frameMode.toString()});
    }

    private boolean isValidWindowFrameDefinition(WindowExpression.FrameMode frameMode, WindowExpression.FrameBoundaryKind startKind, WindowExpression.FrameBoundaryKind endKind, int orderExprCount) {
        block0 : switch (startKind) {
            case UNBOUNDED_FOLLOWING: {
                return false;
            }
            case BOUNDED_FOLLOWING: {
                switch (endKind) {
                    case BOUNDED_FOLLOWING: 
                    case UNBOUNDED_FOLLOWING: {
                        break block0;
                    }
                }
                return false;
            }
        }
        block7 : switch (endKind) {
            case UNBOUNDED_PRECEDING: {
                return false;
            }
            case BOUNDED_PRECEDING: {
                switch (startKind) {
                    case BOUNDED_PRECEDING: 
                    case UNBOUNDED_PRECEDING: {
                        break block7;
                    }
                }
                return false;
            }
        }
        if (frameMode == WindowExpression.FrameMode.RANGE && orderExprCount != 1) {
            block14 : switch (startKind) {
                case UNBOUNDED_PRECEDING: 
                case CURRENT_ROW: {
                    switch (endKind) {
                        case UNBOUNDED_FOLLOWING: 
                        case CURRENT_ROW: {
                            break block14;
                        }
                    }
                    return false;
                }
                default: {
                    return false;
                }
            }
        }
        return true;
    }

    private Triple<ILogicalOperator, List<Mutable<ILogicalExpression>>, List<Mutable<ILogicalExpression>>> translateWindowBoundary(WindowExpression.FrameBoundaryKind boundaryKind, Expression boundaryExpr, List<Pair<OrderOperator.IOrder, Mutable<ILogicalExpression>>> valueExprs, List<Pair<OrderOperator.IOrder, Mutable<ILogicalExpression>>> orderExprList, Mutable<ILogicalOperator> tupSource) throws CompilationException {
        if (orderExprList.isEmpty()) {
            return null;
        }
        switch (boundaryKind) {
            case CURRENT_ROW: {
                ArrayList<MutableObject> resultExprs = new ArrayList<MutableObject>(valueExprs.size());
                for (Pair<OrderOperator.IOrder, Mutable<ILogicalExpression>> p : valueExprs) {
                    resultExprs.add(new MutableObject((Object)((ILogicalExpression)((Mutable)p.second).getValue()).cloneExpression()));
                }
                return new Triple(null, resultExprs, null);
            }
            case BOUNDED_PRECEDING: {
                OperatorType opTypePreceding = ((OrderOperator.IOrder)valueExprs.get((int)0).first).getKind() == OrderOperator.IOrder.OrderKind.ASC ? OperatorType.MINUS : OperatorType.PLUS;
                return this.translateWindowBoundaryExpr(boundaryExpr, valueExprs, tupSource, opTypePreceding, BuiltinFunctions.IS_NUMERIC_ADD_COMPATIBLE);
            }
            case BOUNDED_FOLLOWING: {
                OperatorType opTypeFollowing = ((OrderOperator.IOrder)valueExprs.get((int)0).first).getKind() == OrderOperator.IOrder.OrderKind.ASC ? OperatorType.PLUS : OperatorType.MINUS;
                return this.translateWindowBoundaryExpr(boundaryExpr, valueExprs, tupSource, opTypeFollowing, BuiltinFunctions.IS_NUMERIC_ADD_COMPATIBLE);
            }
            case UNBOUNDED_FOLLOWING: 
            case UNBOUNDED_PRECEDING: {
                return null;
            }
        }
        throw new CompilationException(1038, boundaryExpr.getSourceLocation(), new Serializable[]{boundaryKind.toString()});
    }

    private Triple<ILogicalOperator, List<Mutable<ILogicalExpression>>, List<Mutable<ILogicalExpression>>> translateWindowBoundaryExpr(Expression boundaryExpr, List<Pair<OrderOperator.IOrder, Mutable<ILogicalExpression>>> valueExprs, Mutable<ILogicalOperator> tupSource, OperatorType boundaryOperator, FunctionIdentifier validationFunction) throws CompilationException {
        if (valueExprs.size() != 1) {
            throw new CompilationException(1038, boundaryExpr.getSourceLocation(), new Serializable[]{Integer.valueOf(valueExprs.size())});
        }
        ILogicalExpression valueExpr = (ILogicalExpression)((Mutable)valueExprs.get((int)0).second).getValue();
        SourceLocation sourceLoc = valueExpr.getSourceLocation();
        AbstractFunctionCallExpression validationExpr = SqlppExpressionToPlanTranslator.createFunctionCallExpression(validationFunction, sourceLoc);
        validationExpr.getArguments().add(new MutableObject((Object)valueExpr.cloneExpression()));
        AbstractFunctionCallExpression resultExpr = SqlppExpressionToPlanTranslator.createFunctionCallExpressionForBuiltinOperator(boundaryOperator, sourceLoc);
        resultExpr.getArguments().add(new MutableObject((Object)valueExpr.cloneExpression()));
        Pair<ILogicalExpression, Mutable<ILogicalOperator>> eo = this.langExprToAlgExpression(boundaryExpr, tupSource);
        resultExpr.getArguments().add(new MutableObject(eo.first));
        LogicalVariable resultVar = this.context.newVar();
        AssignOperator assignOp = new AssignOperator(resultVar, (Mutable)new MutableObject((Object)resultExpr));
        assignOp.setSourceLocation(sourceLoc);
        assignOp.getInputs().add(eo.second);
        VariableReferenceExpression resultVarRefExpr = new VariableReferenceExpression(resultVar);
        resultVarRefExpr.setSourceLocation(sourceLoc);
        return new Triple((Object)assignOp, this.mkSingletonArrayList(new MutableObject((Object)resultVarRefExpr)), this.mkSingletonArrayList(new MutableObject((Object)validationExpr)));
    }

    private Pair<List<Mutable<ILogicalExpression>>, Integer> translateWindowExclusion(WindowExpression.FrameExclusionKind frameExclusionKind, LogicalVariable rowNumVar, LogicalVariable denseRankVar, Set<LogicalVariable> outUsedVars, SourceLocation sourceLoc) throws CompilationException {
        switch (frameExclusionKind) {
            case CURRENT_ROW: {
                VariableReferenceExpression rowNumVarRefExpr = new VariableReferenceExpression(rowNumVar);
                rowNumVarRefExpr.setSourceLocation(sourceLoc);
                ArrayList<MutableObject> resultExprs = new ArrayList<MutableObject>(1);
                resultExprs.add(new MutableObject((Object)rowNumVarRefExpr));
                outUsedVars.add(rowNumVar);
                return new Pair(resultExprs, (Object)1);
            }
            case GROUP: {
                VariableReferenceExpression denseRankVarRefExpr = new VariableReferenceExpression(denseRankVar);
                denseRankVarRefExpr.setSourceLocation(sourceLoc);
                ArrayList<MutableObject> resultExprs = new ArrayList<MutableObject>(1);
                resultExprs.add(new MutableObject((Object)denseRankVarRefExpr));
                outUsedVars.add(denseRankVar);
                return new Pair(resultExprs, (Object)1);
            }
            case TIES: {
                VariableReferenceExpression denseRankVarRefExpr = new VariableReferenceExpression(denseRankVar);
                denseRankVarRefExpr.setSourceLocation(sourceLoc);
                VariableReferenceExpression rowNumVarRefExpr = new VariableReferenceExpression(rowNumVar);
                rowNumVarRefExpr.setSourceLocation(sourceLoc);
                ArrayList<MutableObject> resultExprs = new ArrayList<MutableObject>(2);
                resultExprs.add(new MutableObject((Object)denseRankVarRefExpr));
                outUsedVars.add(denseRankVar);
                resultExprs.add(new MutableObject((Object)rowNumVarRefExpr));
                outUsedVars.add(rowNumVar);
                return new Pair(resultExprs, (Object)1);
            }
            case NO_OTHERS: {
                return null;
            }
        }
        throw new CompilationException(1038, sourceLoc, new Serializable[]{frameExclusionKind.toString()});
    }

    private WindowOperator createHelperWindowOperator(List<Mutable<ILogicalExpression>> partExprList, List<Pair<OrderOperator.IOrder, Mutable<ILogicalExpression>>> orderExprList, LogicalVariable rowNumVar, LogicalVariable denseRankVar, ListSet<LogicalVariable> usedVars, SourceLocation sourceLoc) throws CompilationException {
        WindowOperator winOp = new WindowOperator(partExprList, orderExprList);
        winOp.setSourceLocation(sourceLoc);
        for (LogicalVariable usedVar : usedVars) {
            FunctionIdentifier fid;
            if (usedVar.equals((Object)rowNumVar)) {
                fid = BuiltinFunctions.ROW_NUMBER_IMPL;
            } else if (usedVar.equals((Object)denseRankVar)) {
                fid = BuiltinFunctions.DENSE_RANK_IMPL;
            } else {
                throw new CompilationException(1038, sourceLoc, new Serializable[]{usedVar.toString()});
            }
            AbstractFunctionCallExpression valueExpr = BuiltinFunctions.makeWindowFunctionExpression((FunctionIdentifier)fid, new ArrayList());
            if (BuiltinFunctions.builtinFunctionHasProperty((FunctionIdentifier)valueExpr.getFunctionIdentifier(), (BuiltinFunctions.BuiltinFunctionProperty)BuiltinFunctions.WindowFunctionProperty.INJECT_ORDER_ARGS)) {
                for (Pair<OrderOperator.IOrder, Mutable<ILogicalExpression>> p : orderExprList) {
                    valueExpr.getArguments().add(new MutableObject((Object)((ILogicalExpression)((Mutable)p.second).getValue()).cloneExpression()));
                }
            }
            valueExpr.setSourceLocation(winOp.getSourceLocation());
            winOp.getVariables().add(usedVar);
            winOp.getExpressions().add(new MutableObject((Object)valueExpr));
        }
        return winOp;
    }

    private boolean getBooleanModifier(Boolean value, boolean defaultValue, boolean isAllowed, SourceLocation sourceLoc, String displayName, String funcName) throws CompilationException {
        if (isAllowed) {
            return value != null ? value : defaultValue;
        }
        if (value != null) {
            throw new CompilationException(1104, sourceLoc, new Serializable[]{displayName, funcName});
        }
        return defaultValue;
    }

    private CallExpr createCallExpr(FunctionIdentifier func, Expression arg, SourceLocation sourceLoc) {
        CallExpr callExpr = new CallExpr(new FunctionSignature(func), this.mkSingletonArrayList(arg));
        callExpr.setSourceLocation(sourceLoc);
        return callExpr;
    }

    private AbstractExpression createOperatorExpr(Expression arg1, OperatorType opType, Literal arg2, SourceLocation sourceLoc) {
        OperatorExpr opExpr = new OperatorExpr();
        opExpr.addOperand(arg1);
        opExpr.addOperator(opType);
        opExpr.addOperand((Expression)new LiteralExpr(arg2));
        opExpr.setSourceLocation(sourceLoc);
        return opExpr;
    }

    private static void reverseOrder(List<Pair<OrderOperator.IOrder, Mutable<ILogicalExpression>>> orderExprList) throws CompilationException {
        for (Pair<OrderOperator.IOrder, Mutable<ILogicalExpression>> orderExprPair : orderExprList) {
            orderExprPair.setFirst((Object)SqlppExpressionToPlanTranslator.reverseOrder((OrderOperator.IOrder)orderExprPair.getFirst()));
        }
    }

    private static OrderOperator.IOrder reverseOrder(OrderOperator.IOrder order) throws CompilationException {
        switch (order.getKind()) {
            case ASC: {
                return OrderOperator.DESC_ORDER;
            }
            case DESC: {
                return OrderOperator.ASC_ORDER;
            }
        }
        throw new CompilationException(1079, new Serializable[0]);
    }

    private WindowExpression.FrameBoundaryKind reverseFrameBoundaryKind(WindowExpression.FrameBoundaryKind frameBoundaryKind) throws CompilationException {
        switch (frameBoundaryKind) {
            case UNBOUNDED_PRECEDING: {
                return WindowExpression.FrameBoundaryKind.UNBOUNDED_FOLLOWING;
            }
            case BOUNDED_PRECEDING: {
                return WindowExpression.FrameBoundaryKind.BOUNDED_FOLLOWING;
            }
            case CURRENT_ROW: {
                return WindowExpression.FrameBoundaryKind.CURRENT_ROW;
            }
            case BOUNDED_FOLLOWING: {
                return WindowExpression.FrameBoundaryKind.BOUNDED_PRECEDING;
            }
            case UNBOUNDED_FOLLOWING: {
                return WindowExpression.FrameBoundaryKind.UNBOUNDED_PRECEDING;
            }
        }
        throw new CompilationException(1079, new Serializable[0]);
    }
}

