/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.functions;

import java.io.IOException;
import org.apache.asterix.common.annotations.MissingNullInOutFunction;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.functions.IFunctionDescriptor;
import org.apache.asterix.om.functions.IFunctionDescriptorFactory;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.EnumDeserializer;
import org.apache.asterix.runtime.evaluators.base.AbstractScalarFunctionDynamicDescriptor;
import org.apache.asterix.runtime.evaluators.common.ListAccessor;
import org.apache.asterix.runtime.evaluators.functions.PointableHelper;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.runtime.base.IEvaluatorContext;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.AbstractPointable;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;

@MissingNullInOutFunction
public class ArrayIfNullDescriptor
extends AbstractScalarFunctionDynamicDescriptor {
    private static final long serialVersionUID = 1L;
    public static final IFunctionDescriptorFactory FACTORY = new IFunctionDescriptorFactory(){

        public IFunctionDescriptor createFunctionDescriptor() {
            return new ArrayIfNullDescriptor();
        }
    };

    public FunctionIdentifier getIdentifier() {
        return BuiltinFunctions.ARRAY_IFNULL;
    }

    public IScalarEvaluatorFactory createEvaluatorFactory(final IScalarEvaluatorFactory[] args) throws AlgebricksException {
        return new IScalarEvaluatorFactory(){
            private static final long serialVersionUID = 1L;

            public IScalarEvaluator createScalarEvaluator(IEvaluatorContext ctx) throws HyracksDataException {
                return new ArrayIfNullEval(args, ctx);
            }
        };
    }

    public class ArrayIfNullEval
    implements IScalarEvaluator {
        private final ArrayBackedValueStorage storage = new ArrayBackedValueStorage();
        private final IScalarEvaluator listArgEval;
        private final IPointable listArg = new VoidPointable();
        private final ListAccessor listAccessor;
        private final AbstractPointable item = new VoidPointable();

        public ArrayIfNullEval(IScalarEvaluatorFactory[] args, IEvaluatorContext ctx) throws HyracksDataException {
            this.listAccessor = new ListAccessor();
            this.listArgEval = args[0].createScalarEvaluator(ctx);
        }

        public void evaluate(IFrameTupleReference tuple, IPointable result) throws HyracksDataException {
            int offset;
            this.listArgEval.evaluate(tuple, this.listArg);
            if (PointableHelper.checkAndSetMissingOrNull(result, this.listArg)) {
                return;
            }
            byte[] listBytes = this.listArg.getByteArray();
            ATypeTag listType = (ATypeTag)EnumDeserializer.ATYPETAGDESERIALIZER.deserialize(listBytes[offset = this.listArg.getStartOffset()]);
            if (!listType.isListType()) {
                PointableHelper.setNull(result);
                return;
            }
            this.listAccessor.reset(listBytes, offset);
            ATypeTag itemTypeTag = this.listAccessor.getItemType();
            try {
                if (itemTypeTag == ATypeTag.NULL || itemTypeTag == ATypeTag.MISSING) {
                    PointableHelper.setNull(result);
                    return;
                }
                int numItems = this.listAccessor.size();
                for (int i = 0; i < numItems; ++i) {
                    this.listAccessor.getOrWriteItem(i, (IPointable)this.item, this.storage);
                    itemTypeTag = (ATypeTag)EnumDeserializer.ATYPETAGDESERIALIZER.deserialize(this.item.getByteArray()[this.item.getStartOffset()]);
                    if (itemTypeTag == ATypeTag.NULL || itemTypeTag == ATypeTag.MISSING) continue;
                    result.set((IValueReference)this.item);
                    return;
                }
                PointableHelper.setNull(result);
            }
            catch (IOException e) {
                throw HyracksDataException.create((Throwable)e);
            }
        }
    }
}

