/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.input.record.reader.hdfs;

import java.io.IOException;
import org.apache.asterix.external.api.IRawRecord;
import org.apache.asterix.external.indexing.ExternalFileIndexAccessor;
import org.apache.asterix.external.indexing.RecordId;
import org.apache.asterix.external.input.record.GenericRecord;
import org.apache.asterix.external.input.record.reader.hdfs.AbstractHDFSLookupRecordReader;
import org.apache.asterix.hivecompat.io.RCFile;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.serde2.columnar.BytesRefArrayWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Writable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RCLookupReader
extends AbstractHDFSLookupRecordReader<BytesRefArrayWritable> {
    private static final Logger LOGGER = LogManager.getLogger();
    private RCFile.Reader reader;
    private LongWritable key = new LongWritable();
    private BytesRefArrayWritable value = new BytesRefArrayWritable();
    private GenericRecord<BytesRefArrayWritable> record = new GenericRecord();
    private long offset;
    private int row;

    public RCLookupReader(ExternalFileIndexAccessor snapshotAccessor, FileSystem fs, Configuration conf) {
        super(snapshotAccessor, fs, conf);
    }

    @Override
    public Class<?> getRecordClass() throws IOException {
        return Writable.class;
    }

    @Override
    protected IRawRecord<BytesRefArrayWritable> lookup(RecordId rid) throws IOException {
        if (rid.getOffset() != this.offset) {
            this.offset = rid.getOffset();
            if (this.reader.getPosition() != this.offset) {
                this.reader.seek(this.offset);
            }
            this.reader.resetBuffer();
            this.row = -1;
        }
        while (this.row < rid.getRow()) {
            this.reader.next(this.key);
            this.reader.getCurrentRow(this.value);
            ++this.row;
        }
        this.record.set(this.value);
        return this.record;
    }

    @Override
    protected void closeFile() {
        if (this.reader == null) {
            return;
        }
        try {
            this.reader.close();
        }
        catch (Exception e) {
            LOGGER.warn("Error closing HDFS file", (Throwable)e);
        }
    }

    @Override
    protected void openFile() throws IllegalArgumentException, IOException {
        this.reader = new RCFile.Reader(this.fs, new Path(this.file.getFileName()), this.conf);
        this.offset = -1L;
        this.row = -1;
    }
}

