/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.optimizer.rules.subplan;

import java.io.Serializable;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.common.exceptions.ErrorCode;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AggregateOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AssignOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.DataSourceScanOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.DelegateOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.DistinctOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.EmptyTupleSourceOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.ExchangeOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.ForwardOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.GroupByOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.InnerJoinOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.IntersectOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.LeftOuterJoinOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.LeftOuterUnnestMapOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.LeftOuterUnnestOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.LimitOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.MaterializeOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.NestedTupleSourceOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.OrderOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.ProjectOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.ReplicateOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.RunningAggregateOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.ScriptOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.SelectOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.SplitOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.SubplanOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.TokenizeOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.UnionAllOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.UnnestMapOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.UnnestOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.WindowOperator;
import org.apache.hyracks.algebricks.core.algebra.visitors.ILogicalOperatorVisitor;
import org.apache.hyracks.algebricks.core.algebra.visitors.IQueryOperatorVisitor;

class SubplanSpecialFlatteningCheckVisitor
implements IQueryOperatorVisitor<Boolean, Void> {
    private boolean rejectPending = false;
    private ILogicalOperator qualifiedNtsOp;

    SubplanSpecialFlatteningCheckVisitor() {
    }

    public ILogicalOperator getQualifiedNts() {
        return this.qualifiedNtsOp;
    }

    public Boolean visitAggregateOperator(AggregateOperator op, Void arg) throws AlgebricksException {
        return this.visitCardinalityReduceOperator((ILogicalOperator)op);
    }

    public Boolean visitRunningAggregateOperator(RunningAggregateOperator op, Void arg) throws AlgebricksException {
        return this.visitCardinalityReduceOperator((ILogicalOperator)op);
    }

    public Boolean visitEmptyTupleSourceOperator(EmptyTupleSourceOperator op, Void arg) throws AlgebricksException {
        return false;
    }

    public Boolean visitGroupByOperator(GroupByOperator op, Void arg) throws AlgebricksException {
        return this.visitCardinalityReduceOperator((ILogicalOperator)op);
    }

    public Boolean visitLimitOperator(LimitOperator op, Void arg) throws AlgebricksException {
        return this.visitTupleDiscardingOperator((ILogicalOperator)op);
    }

    public Boolean visitInnerJoinOperator(InnerJoinOperator op, Void arg) throws AlgebricksException {
        for (Mutable childRef : op.getInputs()) {
            if (((Boolean)((ILogicalOperator)childRef.getValue()).accept((ILogicalOperatorVisitor)this, null)).booleanValue() && !this.rejectPending) {
                return true;
            }
            this.rejectPending = false;
        }
        return false;
    }

    public Boolean visitLeftOuterJoinOperator(LeftOuterJoinOperator op, Void arg) throws AlgebricksException {
        boolean isLeftBranchQualified = (Boolean)((ILogicalOperator)((Mutable)op.getInputs().get(0)).getValue()).accept((ILogicalOperatorVisitor)this, null);
        return !this.rejectPending && isLeftBranchQualified;
    }

    public Boolean visitNestedTupleSourceOperator(NestedTupleSourceOperator op, Void arg) throws AlgebricksException {
        this.qualifiedNtsOp = op;
        return true;
    }

    public Boolean visitOrderOperator(OrderOperator op, Void arg) throws AlgebricksException {
        return this.visitInputs((ILogicalOperator)op);
    }

    public Boolean visitAssignOperator(AssignOperator op, Void arg) throws AlgebricksException {
        return this.visitInputs((ILogicalOperator)op);
    }

    public Boolean visitSelectOperator(SelectOperator op, Void arg) throws AlgebricksException {
        return this.visitTupleDiscardingOperator((ILogicalOperator)op);
    }

    public Boolean visitDelegateOperator(DelegateOperator op, Void arg) throws AlgebricksException {
        return false;
    }

    public Boolean visitProjectOperator(ProjectOperator op, Void arg) throws AlgebricksException {
        return this.visitInputs((ILogicalOperator)op);
    }

    public Boolean visitReplicateOperator(ReplicateOperator op, Void arg) throws AlgebricksException {
        return this.visitInputs((ILogicalOperator)op);
    }

    public Boolean visitSplitOperator(SplitOperator op, Void arg) throws AlgebricksException {
        return this.visitInputs((ILogicalOperator)op);
    }

    public Boolean visitMaterializeOperator(MaterializeOperator op, Void arg) throws AlgebricksException {
        return this.visitInputs((ILogicalOperator)op);
    }

    public Boolean visitScriptOperator(ScriptOperator op, Void arg) throws AlgebricksException {
        return false;
    }

    public Boolean visitSubplanOperator(SubplanOperator op, Void arg) throws AlgebricksException {
        return this.visitInputs((ILogicalOperator)op);
    }

    public Boolean visitUnionOperator(UnionAllOperator op, Void arg) throws AlgebricksException {
        return false;
    }

    public Boolean visitIntersectOperator(IntersectOperator op, Void arg) throws AlgebricksException {
        return false;
    }

    public Boolean visitUnnestOperator(UnnestOperator op, Void arg) throws AlgebricksException {
        return this.visitInputs((ILogicalOperator)op);
    }

    public Boolean visitLeftOuterUnnestOperator(LeftOuterUnnestOperator op, Void arg) throws AlgebricksException {
        return this.visitInputs((ILogicalOperator)op);
    }

    public Boolean visitUnnestMapOperator(UnnestMapOperator op, Void arg) throws AlgebricksException {
        return false;
    }

    public Boolean visitLeftOuterUnnestMapOperator(LeftOuterUnnestMapOperator op, Void arg) throws AlgebricksException {
        return false;
    }

    public Boolean visitDataScanOperator(DataSourceScanOperator op, Void arg) throws AlgebricksException {
        return false;
    }

    public Boolean visitDistinctOperator(DistinctOperator op, Void arg) throws AlgebricksException {
        return this.visitTupleDiscardingOperator((ILogicalOperator)op);
    }

    public Boolean visitExchangeOperator(ExchangeOperator op, Void arg) throws AlgebricksException {
        return this.visitInputs((ILogicalOperator)op);
    }

    public Boolean visitTokenizeOperator(TokenizeOperator op, Void arg) throws AlgebricksException {
        return this.visitInputs((ILogicalOperator)op);
    }

    public Boolean visitForwardOperator(ForwardOperator op, Void arg) throws AlgebricksException {
        throw new CompilationException(ErrorCode.COMPILATION_ERROR, op.getSourceLocation(), new Serializable[]{"Forward operator should have been disqualified for this rewriting!"});
    }

    public Boolean visitWindowOperator(WindowOperator op, Void arg) throws AlgebricksException {
        return this.visitInputs((ILogicalOperator)op);
    }

    private boolean visitInputs(ILogicalOperator op) throws AlgebricksException {
        for (Mutable childRef : op.getInputs()) {
            if (!((Boolean)((ILogicalOperator)childRef.getValue()).accept((ILogicalOperatorVisitor)this, null)).booleanValue()) continue;
            return true;
        }
        return false;
    }

    private Boolean visitCardinalityReduceOperator(ILogicalOperator op) throws AlgebricksException {
        return this.visitTupleDiscardingOrCardinalityReduceOperator(op);
    }

    private Boolean visitTupleDiscardingOperator(ILogicalOperator op) throws AlgebricksException {
        return this.visitTupleDiscardingOrCardinalityReduceOperator(op);
    }

    private boolean visitTupleDiscardingOrCardinalityReduceOperator(ILogicalOperator op) throws AlgebricksException {
        boolean result = this.visitInputs(op);
        this.rejectPending = true;
        return result;
    }
}

