/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.control.nc.result;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.MinimalPrettyPrinter;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hyracks.api.dataflow.state.IStateObject;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.FileReference;
import org.apache.hyracks.api.io.IFileHandle;
import org.apache.hyracks.api.io.IIOManager;
import org.apache.hyracks.api.io.IWorkspaceFileFactory;
import org.apache.hyracks.api.job.JobId;
import org.apache.hyracks.api.partitions.ResultSetPartitionId;
import org.apache.hyracks.control.nc.result.Page;
import org.apache.hyracks.control.nc.result.ResultMemoryManager;

public class ResultState
implements IStateObject {
    private static final String FILE_PREFIX = "result_";
    private final ResultSetPartitionId resultSetPartitionId;
    private final boolean asyncMode;
    private final int frameSize;
    private final IIOManager ioManager;
    private final IWorkspaceFileFactory fileFactory;
    private final AtomicBoolean eos;
    private final AtomicBoolean failed;
    private final List<Page> localPageList;
    private FileReference fileRef;
    private IFileHandle fileHandle;
    private volatile int referenceCount = 0;
    private long size;
    private long persistentSize;
    private long remainingReads;

    ResultState(ResultSetPartitionId resultSetPartitionId, boolean asyncMode, IIOManager ioManager, IWorkspaceFileFactory fileFactory, int frameSize, long maxReads) {
        if (maxReads <= 0L) {
            throw new IllegalArgumentException("maxReads must be > 0");
        }
        this.resultSetPartitionId = resultSetPartitionId;
        this.asyncMode = asyncMode;
        this.ioManager = ioManager;
        this.fileFactory = fileFactory;
        this.frameSize = frameSize;
        this.remainingReads = maxReads;
        this.eos = new AtomicBoolean(false);
        this.failed = new AtomicBoolean(false);
        this.localPageList = new ArrayList<Page>();
        this.fileRef = null;
        this.fileHandle = null;
    }

    public synchronized void open() {
        this.size = 0L;
        this.persistentSize = 0L;
        this.referenceCount = 0;
    }

    public synchronized void close() {
        this.eos.set(true);
        this.closeWriteFileHandle();
        this.notifyAll();
    }

    public synchronized void closeAndDelete() {
        this.failed.set(true);
        this.closeWriteFileHandle();
        if (this.fileRef != null) {
            this.fileRef.delete();
            this.fileRef = null;
        }
    }

    private void closeWriteFileHandle() {
        if (this.fileHandle != null) {
            this.doCloseFileHandle();
        }
    }

    private void doCloseFileHandle() {
        if (--this.referenceCount == 0) {
            try {
                this.ioManager.close(this.fileHandle);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.fileHandle = null;
        }
    }

    public synchronized void write(ByteBuffer buffer) throws HyracksDataException {
        if (this.fileRef == null) {
            this.initWriteFileHandle();
        }
        this.size += (long)this.ioManager.syncWrite(this.fileHandle, this.size, buffer);
        this.notifyAll();
    }

    public synchronized void write(ResultMemoryManager resultMemoryManager, ByteBuffer buffer) throws HyracksDataException {
        int srcOffset = 0;
        Page destPage = null;
        if (!this.localPageList.isEmpty()) {
            destPage = this.localPageList.get(this.localPageList.size() - 1);
        }
        while (srcOffset < buffer.limit()) {
            if (destPage == null || destPage.getBuffer().remaining() <= 0) {
                destPage = resultMemoryManager.requestPage(this.resultSetPartitionId, this);
                this.localPageList.add(destPage);
            }
            int srcLength = Math.min(buffer.limit() - srcOffset, destPage.getBuffer().remaining());
            destPage.getBuffer().put(buffer.array(), srcOffset, srcLength);
            srcOffset += srcLength;
            this.size += (long)srcLength;
        }
        this.notifyAll();
    }

    public synchronized void readOpen() {
        if (this.isExhausted()) {
            throw new IllegalStateException("Result reads exhausted");
        }
        --this.remainingReads;
    }

    public synchronized void readClose() throws HyracksDataException {
        if (this.fileHandle != null) {
            this.doCloseFileHandle();
        }
    }

    public synchronized long read(long offset, ByteBuffer buffer) throws HyracksDataException {
        long readSize = 0L;
        while (offset >= this.size && !this.eos.get() && !this.failed.get()) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                throw HyracksDataException.create((Throwable)e);
            }
        }
        if (offset >= this.size && this.eos.get() || this.failed.get()) {
            return readSize;
        }
        if (this.fileHandle == null) {
            this.initReadFileHandle();
        }
        readSize = this.ioManager.syncRead(this.fileHandle, offset, buffer);
        return readSize;
    }

    public synchronized long read(ResultMemoryManager resultMemoryManager, long offset, ByteBuffer buffer) throws HyracksDataException {
        long readSize = 0L;
        while (offset >= this.size && !this.eos.get() && !this.failed.get()) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                throw HyracksDataException.create((Throwable)e);
            }
        }
        if (offset >= this.size && this.eos.get() || this.failed.get()) {
            return readSize;
        }
        if (offset < this.persistentSize) {
            if (this.fileHandle == null) {
                this.initReadFileHandle();
            }
            if ((readSize = (long)this.ioManager.syncRead(this.fileHandle, offset, buffer)) < 0L) {
                throw new HyracksDataException("Premature end of file");
            }
        }
        if (readSize < (long)buffer.capacity()) {
            long localPageOffset = offset - this.persistentSize;
            int localPageIndex = (int)(localPageOffset / (long)ResultMemoryManager.getPageSize());
            int pageOffset = (int)(localPageOffset % (long)ResultMemoryManager.getPageSize());
            Page page = this.getPage(localPageIndex);
            if (page == null) {
                return readSize;
            }
            readSize += (long)buffer.remaining();
            buffer.put(page.getBuffer().array(), pageOffset, buffer.remaining());
        }
        resultMemoryManager.pageReferenced(this.resultSetPartitionId);
        return readSize;
    }

    public synchronized void abort() {
        this.failed.set(true);
        this.notifyAll();
    }

    public synchronized Page returnPage() throws HyracksDataException {
        Page page = this.removePage();
        if (page == null) {
            this.ioManager.close(this.fileHandle);
            return null;
        }
        page.getBuffer().flip();
        if (this.fileRef == null) {
            this.initWriteFileHandle();
        }
        long delta = this.ioManager.syncWrite(this.fileHandle, this.persistentSize, page.getBuffer());
        this.persistentSize += delta;
        return page;
    }

    public synchronized void setEOS(boolean eos) {
        this.eos.set(eos);
    }

    public ResultSetPartitionId getResultSetPartitionId() {
        return this.resultSetPartitionId;
    }

    public int getFrameSize() {
        return this.frameSize;
    }

    public IIOManager getIOManager() {
        return this.ioManager;
    }

    public boolean getAsyncMode() {
        return this.asyncMode;
    }

    public JobId getJobId() {
        return this.resultSetPartitionId.getJobId();
    }

    public Object getId() {
        return this.resultSetPartitionId;
    }

    public long getMemoryOccupancy() {
        throw new UnsupportedOperationException();
    }

    public void toBytes(DataOutput out) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void fromBytes(DataInput in) throws IOException {
        throw new UnsupportedOperationException();
    }

    private Page getPage(int index) {
        Page page = null;
        if (!this.localPageList.isEmpty()) {
            page = this.localPageList.get(index);
        }
        return page;
    }

    private Page removePage() {
        Page page = null;
        if (!this.localPageList.isEmpty()) {
            page = this.localPageList.remove(this.localPageList.size() - 1);
        }
        return page;
    }

    private void initWriteFileHandle() throws HyracksDataException {
        if (this.fileHandle == null) {
            String fName = FILE_PREFIX + String.valueOf(this.resultSetPartitionId.getPartition());
            this.fileRef = this.fileFactory.createUnmanagedWorkspaceFile(fName);
            this.fileHandle = this.ioManager.open(this.fileRef, IIOManager.FileReadWriteMode.READ_WRITE, IIOManager.FileSyncMode.METADATA_ASYNC_DATA_ASYNC);
            if (this.referenceCount != 0) {
                throw new IllegalStateException("Illegal reference count " + this.referenceCount);
            }
            this.referenceCount = 1;
            this.notifyAll();
        }
    }

    private void initReadFileHandle() throws HyracksDataException {
        while (this.fileRef == null && !this.failed.get()) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                throw HyracksDataException.create((Throwable)e);
            }
        }
        if (this.failed.get()) {
            return;
        }
        if (this.fileHandle == null) {
            this.fileHandle = this.ioManager.open(this.fileRef, IIOManager.FileReadWriteMode.READ_ONLY, IIOManager.FileSyncMode.METADATA_ASYNC_DATA_ASYNC);
        }
        ++this.referenceCount;
    }

    public String toString() {
        try {
            ObjectMapper om = new ObjectMapper();
            ObjectNode on = om.createObjectNode();
            on.put("rspid", this.resultSetPartitionId.toString());
            on.put("async", this.asyncMode);
            on.put("remainingReads", this.remainingReads);
            on.put("eos", this.eos.get());
            on.put("failed", this.failed.get());
            on.put("fileRef", String.valueOf(this.fileRef));
            return om.writer((PrettyPrinter)new MinimalPrettyPrinter()).writeValueAsString((Object)on);
        }
        catch (JsonProcessingException e) {
            return e.getMessage();
        }
    }

    public synchronized boolean isExhausted() {
        return this.remainingReads == 0L;
    }
}

