/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.invertedindex.ondisk;

import java.nio.ByteBuffer;
import org.apache.hyracks.api.comm.FrameHelper;
import org.apache.hyracks.api.comm.IFrameTupleAccessor;
import org.apache.hyracks.api.dataflow.value.ITypeTraits;
import org.apache.hyracks.api.exceptions.HyracksDataException;

public abstract class AbstractInvertedListSearchResultFrameTupleAccessor
implements IFrameTupleAccessor {
    protected final int frameSize;
    protected ByteBuffer buffer;
    protected final ITypeTraits[] fields;

    protected abstract void verifyTypeTraits() throws HyracksDataException;

    public AbstractInvertedListSearchResultFrameTupleAccessor(int frameSize, ITypeTraits[] fields) throws HyracksDataException {
        this.frameSize = frameSize;
        this.fields = fields;
        this.verifyTypeTraits();
    }

    public ByteBuffer getBuffer() {
        return this.buffer;
    }

    public int getFieldCount() {
        return this.fields.length;
    }

    public int getTupleLength(int tupleIndex) {
        return this.getTupleEndOffset(tupleIndex) - this.getTupleStartOffset(tupleIndex);
    }

    public int getFieldSlotsLength() {
        return 0;
    }

    public int getTupleCount() {
        return this.buffer != null ? this.buffer.getInt(FrameHelper.getTupleCountOffset((int)this.frameSize)) : 0;
    }

    public int getTupleEndOffset(int tupleIndex) {
        return this.getFieldEndOffset(tupleIndex, this.fields.length - 1);
    }

    public int getAbsoluteFieldStartOffset(int tupleIndex, int fIdx) {
        return this.getTupleStartOffset(tupleIndex) + this.getFieldSlotsLength() + this.getFieldStartOffset(tupleIndex, fIdx);
    }

    public void reset(ByteBuffer buffer) {
        this.buffer = buffer;
    }
}

