/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.invertedindex.ondisk.fixedsize;

import org.apache.hyracks.api.dataflow.value.ITypeTraits;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.storage.am.lsm.invertedindex.ondisk.AbstractInvertedListBuilder;
import org.apache.hyracks.storage.am.lsm.invertedindex.util.InvertedIndexUtils;

public class FixedSizeElementInvertedListBuilder
extends AbstractInvertedListBuilder {
    private final int listElementSize;

    public FixedSizeElementInvertedListBuilder(ITypeTraits[] invListFields) throws HyracksDataException {
        super(invListFields);
        InvertedIndexUtils.verifyAllFixedSizeTypeTrait(invListFields);
        int tmp = 0;
        for (int i = 0; i < invListFields.length; ++i) {
            tmp += invListFields[i].getFixedLength();
        }
        this.listElementSize = tmp;
    }

    @Override
    public boolean startNewList(ITupleReference tuple, int numTokenFields) {
        if (this.pos + this.listElementSize > this.targetBuf.length) {
            return false;
        }
        this.listSize = 0;
        return true;
    }

    @Override
    public boolean appendElement(ITupleReference tuple, int numTokenFields, int numElementFields) {
        if (this.pos + this.listElementSize > this.targetBuf.length) {
            return false;
        }
        for (int i = 0; i < numElementFields; ++i) {
            int field = numTokenFields + i;
            System.arraycopy(tuple.getFieldData(field), tuple.getFieldStart(field), this.targetBuf, this.pos, tuple.getFieldLength(field));
        }
        ++this.listSize;
        this.pos += this.listElementSize;
        return true;
    }

    @Override
    public boolean isFixedSize() {
        return true;
    }
}

