/*
 * Decompiled with CFR 0.152.
 */
package rx.subscriptions;

import java.util.concurrent.atomic.AtomicReference;
import rx.Subscription;
import rx.subscriptions.Subscriptions;

public final class MultipleAssignmentSubscription
implements Subscription {
    final AtomicReference<State> state = new AtomicReference<State>(new State(false, Subscriptions.empty()));

    @Override
    public boolean isUnsubscribed() {
        return this.state.get().isUnsubscribed;
    }

    @Override
    public void unsubscribe() {
        State newState;
        State oldState;
        AtomicReference<State> localState = this.state;
        do {
            oldState = localState.get();
            if (!oldState.isUnsubscribed) continue;
            return;
        } while (!localState.compareAndSet(oldState, newState = oldState.unsubscribe()));
        oldState.subscription.unsubscribe();
    }

    public void set(Subscription s) {
        State newState;
        State oldState;
        if (s == null) {
            throw new IllegalArgumentException("Subscription can not be null");
        }
        AtomicReference<State> localState = this.state;
        do {
            oldState = localState.get();
            if (!oldState.isUnsubscribed) continue;
            s.unsubscribe();
            return;
        } while (!localState.compareAndSet(oldState, newState = oldState.set(s)));
    }

    public Subscription get() {
        return this.state.get().subscription;
    }

    static final class State {
        final boolean isUnsubscribed;
        final Subscription subscription;

        State(boolean u, Subscription s) {
            this.isUnsubscribed = u;
            this.subscription = s;
        }

        State unsubscribe() {
            return new State(true, this.subscription);
        }

        State set(Subscription s) {
            return new State(this.isUnsubscribed, s);
        }
    }
}

