/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.hivecompat.io;

import java.io.DataInput;
import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.io.UTFDataFormatException;
import org.apache.hadoop.hive.common.io.NonSyncByteArrayInputStream;

public class NonSyncDataInputBuffer
extends FilterInputStream
implements DataInput {
    private final NonSyncByteArrayInputStream buffer;
    byte[] buff = new byte[16];

    public NonSyncDataInputBuffer() {
        this(new NonSyncByteArrayInputStream());
    }

    private NonSyncDataInputBuffer(NonSyncByteArrayInputStream buffer) {
        super((InputStream)buffer);
        this.buffer = buffer;
    }

    public void reset(byte[] input, int length) {
        this.buffer.reset(input, 0, length);
    }

    public void reset(byte[] input, int start, int length) {
        this.buffer.reset(input, start, length);
    }

    public int getPosition() {
        return this.buffer.getPosition();
    }

    public int getLength() {
        return this.buffer.getLength();
    }

    @Override
    public final int read(byte[] buffer) throws IOException {
        return this.in.read(buffer, 0, buffer.length);
    }

    @Override
    public final int read(byte[] buffer, int offset, int length) throws IOException {
        return this.in.read(buffer, offset, length);
    }

    @Override
    public final boolean readBoolean() throws IOException {
        int temp = this.in.read();
        if (temp < 0) {
            throw new EOFException();
        }
        return temp != 0;
    }

    @Override
    public final byte readByte() throws IOException {
        int temp = this.in.read();
        if (temp < 0) {
            throw new EOFException();
        }
        return (byte)temp;
    }

    private int readToBuff(int count) throws IOException {
        int offset;
        int bytesRead;
        for (offset = 0; offset < count; offset += bytesRead) {
            bytesRead = this.in.read(this.buff, offset, count - offset);
            if (bytesRead != -1) continue;
            return bytesRead;
        }
        return offset;
    }

    @Override
    public final char readChar() throws IOException {
        if (this.readToBuff(2) < 0) {
            throw new EOFException();
        }
        return (char)((this.buff[0] & 0xFF) << 8 | this.buff[1] & 0xFF);
    }

    @Override
    public final double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    @Override
    public final float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    @Override
    public final void readFully(byte[] buffer) throws IOException {
        this.readFully(buffer, 0, buffer.length);
    }

    @Override
    public final void readFully(byte[] buffer, int offset, int length) throws IOException {
        if (length < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (length == 0) {
            return;
        }
        if (this.in == null || buffer == null) {
            throw new NullPointerException("Null Pointer to underlying input stream");
        }
        if (offset < 0 || offset > buffer.length - length) {
            throw new IndexOutOfBoundsException();
        }
        while (length > 0) {
            int result = this.in.read(buffer, offset, length);
            if (result < 0) {
                throw new EOFException();
            }
            offset += result;
            length -= result;
        }
    }

    @Override
    public final int readInt() throws IOException {
        if (this.readToBuff(4) < 0) {
            throw new EOFException();
        }
        return (this.buff[0] & 0xFF) << 24 | (this.buff[1] & 0xFF) << 16 | (this.buff[2] & 0xFF) << 8 | this.buff[3] & 0xFF;
    }

    @Override
    @Deprecated
    public final String readLine() throws IOException {
        StringBuilder line = new StringBuilder(80);
        boolean foundTerminator = false;
        block5: while (true) {
            int nextByte = this.in.read();
            switch (nextByte) {
                case -1: {
                    if (line.length() == 0 && !foundTerminator) {
                        return null;
                    }
                    return line.toString();
                }
                case 13: {
                    if (foundTerminator) {
                        ((PushbackInputStream)this.in).unread(nextByte);
                        return line.toString();
                    }
                    foundTerminator = true;
                    if (this.in.getClass() == PushbackInputStream.class) continue block5;
                    this.in = new PushbackInputStream(this.in);
                    continue block5;
                }
                case 10: {
                    return line.toString();
                }
            }
            if (foundTerminator) {
                ((PushbackInputStream)this.in).unread(nextByte);
                return line.toString();
            }
            line.append((char)nextByte);
        }
    }

    @Override
    public final long readLong() throws IOException {
        if (this.readToBuff(8) < 0) {
            throw new EOFException();
        }
        int i1 = (this.buff[0] & 0xFF) << 24 | (this.buff[1] & 0xFF) << 16 | (this.buff[2] & 0xFF) << 8 | this.buff[3] & 0xFF;
        int i2 = (this.buff[4] & 0xFF) << 24 | (this.buff[5] & 0xFF) << 16 | (this.buff[6] & 0xFF) << 8 | this.buff[7] & 0xFF;
        return ((long)i1 & 0xFFFFFFFFL) << 32 | (long)i2 & 0xFFFFFFFFL;
    }

    @Override
    public final short readShort() throws IOException {
        if (this.readToBuff(2) < 0) {
            throw new EOFException();
        }
        return (short)((this.buff[0] & 0xFF) << 8 | this.buff[1] & 0xFF);
    }

    @Override
    public final int readUnsignedByte() throws IOException {
        int temp = this.in.read();
        if (temp < 0) {
            throw new EOFException();
        }
        return temp;
    }

    @Override
    public final int readUnsignedShort() throws IOException {
        if (this.readToBuff(2) < 0) {
            throw new EOFException();
        }
        return (char)((this.buff[0] & 0xFF) << 8 | this.buff[1] & 0xFF);
    }

    @Override
    public final String readUTF() throws IOException {
        return this.decodeUTF(this.readUnsignedShort());
    }

    String decodeUTF(int utfSize) throws IOException {
        return NonSyncDataInputBuffer.decodeUTF(utfSize, this);
    }

    private static String decodeUTF(int utfSize, DataInput in) throws IOException {
        byte[] buf = new byte[utfSize];
        char[] out = new char[utfSize];
        in.readFully(buf, 0, utfSize);
        return NonSyncDataInputBuffer.convertUTF8WithBuf(buf, out, 0, utfSize);
    }

    public static final String readUTF(DataInput in) throws IOException {
        return NonSyncDataInputBuffer.decodeUTF(in.readUnsignedShort(), in);
    }

    @Override
    public final int skipBytes(int count) throws IOException {
        long skip;
        int skipped = 0;
        while (skipped < count && (skip = this.in.skip(count - skipped)) != 0L) {
            skipped = (int)((long)skipped + skip);
        }
        if (skipped < 0) {
            throw new EOFException();
        }
        return skipped;
    }

    public static String convertUTF8WithBuf(byte[] buf, char[] out, int offset, int utfSize) throws UTFDataFormatException {
        int count = 0;
        int s = 0;
        while (count < utfSize) {
            byte b;
            if ((out[s] = (char)buf[offset + count++]) < '\u0080') {
                ++s;
                continue;
            }
            char a = out[s];
            if ((a & 0xE0) == 192) {
                if (count >= utfSize) {
                    throw new UTFDataFormatException();
                }
                if (((b = buf[count++]) & 0xC0) != 128) {
                    throw new UTFDataFormatException();
                }
                out[s++] = (char)((a & 0x1F) << 6 | b & 0x3F);
                continue;
            }
            if ((a & 0xF0) == 224) {
                if (count + 1 >= utfSize) {
                    throw new UTFDataFormatException();
                }
                b = buf[count++];
                byte c = buf[count++];
                if ((b & 0xC0) != 128 || (c & 0xC0) != 128) {
                    throw new UTFDataFormatException();
                }
                out[s++] = (char)((a & 0xF) << 12 | (b & 0x3F) << 6 | c & 0x3F);
                continue;
            }
            throw new UTFDataFormatException();
        }
        return new String(out, 0, s);
    }
}

