/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.dataflow;

import java.io.Serializable;
import org.apache.asterix.common.exceptions.ErrorCode;
import org.apache.asterix.common.exceptions.RuntimeDataException;
import org.apache.asterix.external.api.AsterixInputStream;
import org.apache.asterix.external.api.IStreamDataParser;
import org.apache.asterix.external.dataflow.AbstractFeedDataFlowController;
import org.apache.asterix.external.dataflow.TupleForwarder;
import org.apache.asterix.external.util.FeedLogManager;
import org.apache.hyracks.api.comm.IFrameWriter;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.storage.am.common.api.ITupleFilter;

public class FeedStreamDataFlowController
extends AbstractFeedDataFlowController {
    private final IStreamDataParser dataParser;
    private final AsterixInputStream stream;

    public FeedStreamDataFlowController(IHyracksTaskContext ctx, FeedLogManager feedLogManager, IStreamDataParser streamParser, AsterixInputStream inputStream) {
        super(ctx, feedLogManager, 1);
        this.dataParser = streamParser;
        this.stream = inputStream;
    }

    @Override
    public void start(IFrameWriter writer, ITupleFilter tupleFilter, long outputLimit) throws HyracksDataException {
        if (tupleFilter != null || outputLimit >= 0L) {
            throw new RuntimeDataException(ErrorCode.DATAFLOW_ILLEGAL_STATE, new Serializable[0]);
        }
        try {
            this.tupleForwarder = new TupleForwarder(this.ctx, writer);
            while (this.parseNext()) {
                this.tb.addFieldEndOffset();
                this.tupleForwarder.addTuple(this.tb);
                ++this.incomingRecordsCount;
            }
            this.tupleForwarder.complete();
        }
        catch (Throwable e) {
            throw HyracksDataException.create((Throwable)e);
        }
    }

    private boolean parseNext() throws HyracksDataException {
        while (true) {
            try {
                this.tb.reset();
                return this.dataParser.parse(this.tb.getDataOutput());
            }
            catch (Exception e) {
                if (this.handleException(e)) continue;
                throw e;
            }
            break;
        }
    }

    @Override
    public boolean stop(long timeout) throws HyracksDataException {
        try {
            if (this.stream.stop()) {
                return true;
            }
            this.stream.close();
        }
        catch (Exception e) {
            throw HyracksDataException.create((Throwable)e);
        }
        return false;
    }

    private boolean handleException(Throwable th) {
        boolean handled = true;
        try {
            if (handled &= this.stream.handleException(th)) {
                handled &= this.dataParser.reset(this.stream);
            }
        }
        catch (Exception e) {
            th.addSuppressed(e);
            return false;
        }
        return handled;
    }

    @Override
    public String getStats() {
        return "{\"incoming-records-number\": " + this.incomingRecordsCount + "}";
    }
}

