/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.library.java;

import java.util.HashMap;
import java.util.Map;
import org.apache.asterix.external.api.IJListAccessor;
import org.apache.asterix.external.api.IJObject;
import org.apache.asterix.external.api.IJObjectAccessor;
import org.apache.asterix.external.api.IJRecordAccessor;
import org.apache.asterix.external.library.TypeInfo;
import org.apache.asterix.external.library.java.JObjectAccessors;
import org.apache.asterix.external.library.java.base.JRecord;
import org.apache.asterix.om.pointables.AFlatValuePointable;
import org.apache.asterix.om.pointables.AListVisitablePointable;
import org.apache.asterix.om.pointables.ARecordVisitablePointable;
import org.apache.asterix.om.pointables.base.IVisitablePointable;
import org.apache.asterix.om.pointables.visitor.IVisitablePointableVisitor;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IPointable;

public class JObjectPointableVisitor
implements IVisitablePointableVisitor<IJObject, TypeInfo> {
    private final Map<ATypeTag, IJObjectAccessor> flatJObjectAccessors = new HashMap<ATypeTag, IJObjectAccessor>();
    private final Map<IVisitablePointable, IJRecordAccessor> raccessorToJObject = new HashMap<IVisitablePointable, IJRecordAccessor>();
    private final Map<IVisitablePointable, IJListAccessor> laccessorToPrinter = new HashMap<IVisitablePointable, IJListAccessor>();

    public IJObject visit(AListVisitablePointable accessor, TypeInfo arg) throws HyracksDataException {
        IJObject result = null;
        IJListAccessor jListAccessor = this.laccessorToPrinter.get(accessor);
        if (jListAccessor == null) {
            jListAccessor = new JObjectAccessors.JListAccessor(arg.getObjectPool());
            this.laccessorToPrinter.put((IVisitablePointable)accessor, jListAccessor);
        }
        result = jListAccessor.access(accessor, arg.getObjectPool(), arg.getAtype(), this);
        return result;
    }

    public IJObject visit(ARecordVisitablePointable accessor, TypeInfo arg) throws HyracksDataException {
        JRecord result = null;
        IJRecordAccessor jRecordAccessor = this.raccessorToJObject.get(accessor);
        if (jRecordAccessor == null) {
            jRecordAccessor = new JObjectAccessors.JRecordAccessor(accessor.getInputRecordType(), arg.getObjectPool());
            this.raccessorToJObject.put((IVisitablePointable)accessor, jRecordAccessor);
        }
        result = jRecordAccessor.access(accessor, arg.getObjectPool(), (ARecordType)arg.getAtype(), this);
        return result;
    }

    public IJObject visit(AFlatValuePointable accessor, TypeInfo arg) throws HyracksDataException {
        ATypeTag typeTag = arg.getTypeTag();
        IJObject result = null;
        IJObjectAccessor jObjectAccessor = this.flatJObjectAccessors.get(typeTag);
        if (jObjectAccessor == null) {
            jObjectAccessor = JObjectAccessors.createFlatJObjectAccessor(typeTag);
            this.flatJObjectAccessors.put(typeTag, jObjectAccessor);
        }
        result = jObjectAccessor.access((IPointable)accessor, arg.getObjectPool());
        return result;
    }

    public IJObject visit(AFlatValuePointable accessor, ATypeTag typeTag, TypeInfo arg) throws HyracksDataException {
        IJObject result = null;
        IJObjectAccessor jObjectAccessor = this.flatJObjectAccessors.get(typeTag);
        if (jObjectAccessor == null) {
            jObjectAccessor = JObjectAccessors.createFlatJObjectAccessor(typeTag);
            this.flatJObjectAccessors.put(typeTag, jObjectAccessor);
        }
        result = jObjectAccessor.access((IPointable)accessor, arg.getObjectPool());
        return result;
    }
}

